import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import SceneCtrl from "../ctrls/sceneCtrl";
import NetConst, { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import GameConst from "../GameConst";
import Waiting from "../waiting/Waiting";

export default class GiftScene extends Scene {

    public get skinKey() { return "pop/Gift" }

    public itemList: eui.Scroller;
    public itemGroup: eui.Group;
    public dianum: eui.Label;
    public mygiftBtn: eui.Button;
    public backBtn: eui.Button;

    private prefabPool: any[] = [];
    private prefunc: any[] = [];
    private diamond:any;

    private scene: any;
    constructor(data) {
        super();
        this.initUI(data);
        this.diamond = data.diamond
        this.scene = data.scene;
    }

    initUI(data) {
        this.itemList.height = GameConst.stage.stageHeight - 300
        if (data.diamond) {
            this.dianum.text = data.diamond;
            this.dianum.text = GameConst.tranNumber(data.diamond, 1)
        }
        if (data.data.length > 0) {
            for (let i: number = 0; i < data.data.length; i++) {
                for(let n:number = 0; n<data.data2.length;n++){
                    if(data.data[i].itemId == data.data2[n].id){
                        let prefab = this.createPrefab(data.data[i],data.data2[n]);
                        if (i % 3 == 0) {
                            prefab.x = 0;
                        } else if (i % 3 == 1) {
                            prefab.x = 224;
                        } else if (i % 3 == 2) {
                            prefab.x = 448;
                        }
                        prefab.y = Math.floor(i / 3) * 341;
                        prefab.width = 197;
                        prefab.height = 306;
                        this.prefabPool.push(prefab);
                        this.itemGroup.addChild(prefab);
                    }
                }
                

            }
            

            for (let n = 0; n < this.prefabPool.length; n++) {
                let dataitem = { predia: this.prefabPool[n].diamond, preid: this.prefabPool[n].id, preicon: this.prefabPool[n].icon, prename: this.prefabPool[n].name };
                let func = this.onTap_giftBtn.bind(this, dataitem);
                this.prefunc.push(func)
                this.onTap(this.prefabPool[n]['giftBtn'], this.prefunc[n]);
                if (this.prefabPool[n].flag) {
                    this.clearTap(this.prefabPool[n]['giftBtn'], this.prefunc[n])
                }

                if (data.diamond < this.prefabPool[n].diamond) {
                    this.setColor(this.prefabPool[n]['giftBtn'])
                    this.clearTap(this.prefabPool[n]['giftBtn'], this.prefunc[n])
                    this.onTap(this.prefabPool[n]['giftBtn'],this.onTap_toast);
                }
            }
        }
    }

    createPrefab(data,data2) {
        let prefab: any = new eui.Component();

        let name:string = data2.name;
        name = name.substr(0,6);


        prefab.skinName = "GiftItemSkin";
        prefab['giftImg'].source = data2.icon;
        prefab['giftname'].text = name;
        prefab['giftnum'].text = data.diamond;

        if (data.exchangeFlag) {
            prefab['giftBtn'].icon = "gifted_png"
        } else {
            prefab['giftBtn'].icon = "ungift_png"
        }
        prefab.diamond = data.diamond;
        prefab.flag = data.exchangeFlag;
        prefab.id = data.itemId;
        prefab.icon = data2.icon;
        prefab.name = name;
        return prefab;
    }
    initEvents() {
        super.initEvents();
        this.onTap(this.mygiftBtn, this.onTap_mygiftBtn);
        this.onTap(this.backBtn, this.onTap_backBtn);
    }
    onTap_mygiftBtn() {

        
        Waiting.instance.show();
        weidianNet.getrecord((s)=>{
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            let data = { data: DataManager.ins.getData("getrecord").data, scene: this }
            PanelCtrl.instance.showImmediately(ModuleTypes.GIFTLIST_PANEL, data);
        },window['projectxId'])



    }
    onTap_giftBtn(data) {
        

        let dataitem = { predia: data.predia, preid: data.preid,preicon:data.preicon,prename:data.prename,diamond:this.diamond }
        PanelCtrl.instance.show(ModuleTypes.CONVERT_PANEL, dataitem);

    }
    onTap_backBtn() {
        Waiting.instance.show()
        weidianNet.index((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            
            this.scene.updateData();
            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE)
        }, window['projectxId'])

    }
    onTap_toast(){
        ToastCtrl.instance.show("钻石数量不够哦~");
    }

    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    removeEvents() {
        super.removeEvents();
        for (let i = 0; i < this.prefabPool.length; i++) {
            this.clearTap(this.prefabPool[i]['giftBtn'], this.prefunc[i])
        }
    }
}