import { playSound, SoundType } from './../ctrls/soundCtrl';

import { GCache } from './../../libs/tc/util/GCache';
import { wait } from './../GameConst';
import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Ani from "../mainScene/Ani";
import GameConst from "../GameConst";
import PanelCtrl from "../ctrls/panelCtrl";
import Waiting from '../waiting/Waiting';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class UpLevelPanel extends Panel {
    protected get skinKey() { return 'pop/UpLevel' }

    public closeBtn: eui.Button;
    public upshowBtn: eui.Button;
    public uptext: eui.Label;
    public leveltext: eui.Label;
    public reward: eui.Label;
    public rewardtype: eui.Image;
    public rewardnum: eui.Label;

    public func: any;
    private feeNewEnable: any;
    private chickenNewEnable: any;
    private grabNewEnable: any;
    private exchangeNewEnable: any;
    private storeLevel: any;
    private hasUpgradeReward: boolean;
    private upgradeReward: any;
    private isGuide: boolean = false;

    private uid: any;
    private scene: any;

    public upshowBtnExposure: any;

    constructor(data) {
        super();
        this.scene = data.scene;
        this.hasUpgradeReward = data.hasUpgradeReward;
        this.upgradeReward = data.upgradeReward;
        this.chickenNewEnable = data.chickenNewEnable;
        this.feeNewEnable = data.feeNewEnable;
        this.grabNewEnable = data.grabNewEnable;
        this.exchangeNewEnable = data.exchangeNewEnable;
        this.storeLevel = data.storeLevel;
        this.uid = data.partnerUserId;
        this.scene.updateLevel(data.storeLevel)
        this.initUI(data);
        this.initBuired();
    }
    initBuired() {
        let upshowBtnDpmOut = Buried.connectDpm(110, 32, 1); // 点击埋点   
        let upshowBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.upshowBtnExposure = Buried.createExposure(upshowBtnDpmOut, upshowBtnDcmOut);
        NetManager.ins.showLog(this.upshowBtnExposure);

    }

    async initUI(data) {

        if (GCache.readCache("isPlayMusic") == "1") {
            playSound(SoundType.levelUp)
            if (GameConst.isIOS()) {
                console.log("url");
                window['playMusic']("levelUp", true, false)
            } else {
                playSound(SoundType.levelUp)
            }
        }

        this.isGuide = data.isGuide;
        this.uptext.text = "恭喜店长，\n店铺成功升级到Lv" + data.storeLevel + "啦~"
        this.leveltext.visible = false;
        if (this.storeLevel < 10) {
            this.leveltext.x = 450;
        } else {
            this.leveltext.x = 440;
        }

        if (this.upgradeReward && this.upgradeReward > 0) {
            this.rewardnum.text = data.upgradeReward;
            await wait(800)
            await Ani.instance.awardDiamondAni(this);
            this.scene.updateDiamond(Number(this.scene.mainConfig.diamond) )
        } else {
            this.reward.visible = false;
            this.rewardnum.visible = false;
            this.rewardtype.visible = false;
        }


        // if (this.grabNewEnable || this.chickenNewEnable || this.feeNewEnable || this.exchangeNewEnable) {
        //     if (this.chickenNewEnable) {
        //         let pumpdata = { storeLevel: this.storeLevel, chickenNewEnable: this.chickenNewEnable, scene: this.scene }
        //         this.scene.updateAddSpeed(pumpdata);
        //     }
        //     if (this.exchangeNewEnable) {
        //         let pumpdata = { storeLevel: this.storeLevel, exchangeNewEnable: this.exchangeNewEnable, scene: this.scene }
        //         this.scene.updateExchange(pumpdata);
        //     }
        //     if (this.grabNewEnable) {
        //         let pumpdata = { storeLevel: this.storeLevel, grabNewEnable: this.grabNewEnable, scene: this.scene }
        //         this.scene.updateVie(pumpdata)
        //     }
        //     if (this.feeNewEnable) {
        //         let pumpdata = { storeLevel: this.storeLevel, feeNewEnable: this.feeNewEnable, scene: this.scene }
        //         this.scene.updateFee(pumpdata);
        //     }
        // }

        this.onTap(this.closeBtn, this.onTap_closeBtn);
    }

    initEvents() {
        //super.initEvents();
        //this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.upshowBtn, this.onTap_show);
    }

    onTap_closeBtn() {
        //主页面增加钻石数
        // debugger
        Waiting.instance.show();
        weidianNet.index((s) => {
            this.hidePanel();
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            // if (this.isGuide) {
            // this.scene.updateData();
            // this.scene.updateDiamond(DataManager.ins.getData("index").data.diamond);
            if (this.scene.mainConfig.table.level == 0) {
                this.scene.guideStep = 3;
                GDispatcher.dispatchEvent("guideTest");
            }
            // }
            if (this.grabNewEnable || this.chickenNewEnable || this.feeNewEnable || this.exchangeNewEnable) {
                if (this.chickenNewEnable) {
                    let pumpdata = { storeLevel: this.storeLevel, chickenNewEnable: this.chickenNewEnable, scene: this.scene }
                    this.scene.updateAddSpeed(pumpdata);
                }
                if (this.exchangeNewEnable) {
                    let pumpdata = { storeLevel: this.storeLevel, exchangeNewEnable: this.exchangeNewEnable, scene: this.scene }
                    this.scene.updateExchange(pumpdata);
                }
                if (this.grabNewEnable) {
                    let pumpdata = { storeLevel: this.storeLevel, grabNewEnable: this.grabNewEnable, scene: this.scene }
                    this.scene.updateVie(pumpdata)
                }
                if (this.feeNewEnable) {
                    let pumpdata = { storeLevel: this.storeLevel, feeNewEnable: this.feeNewEnable, scene: this.scene }
                    this.scene.updateFee(pumpdata);
                }
            }
        }, window['projectxId'])
    }
    onTap_show() {
        //分享弹窗
        NetManager.ins.clickLog(this.upshowBtnExposure);
        Waiting.instance.show();
        weidianNet.getInviteCode((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("分享失败，请重试~");
                return
            }
            let sharecode = DataManager.ins.getData("getShopStatus").data;
            window['shareWX'](sharecode, this.uid);
            weidianNet.index(async (s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                //this.slideDown()

                this.scene.updateData();
                this.scene.updateDiamond(DataManager.ins.getData("index").data.diamond);
                this.hidePanel();
            }, window['projectxId'])
        }, window['projectxId'])
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.upshowBtn, this.onTap_show);
    }
}