import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import { weidianNet } from "../NetConst";
import GameConst from "../GameConst";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Waiting from "../waiting/Waiting";
import Ani from "../mainScene/Ani";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Data } from '../../libs/tw/data/Data';
export default class TaskPanel extends Panel {
    protected get skinKey() { return 'pop/Task' }
    public closeBtn: eui.Button;
    public taskList: eui.Scroller;
    public taskeGroup: eui.Group;
    public taskevery: eui.Group;
    public day1: eui.Image;
    public day2: eui.Image;
    public day3: eui.Image;
    public day4: eui.Image;
    public day5: eui.Image;
    public get1: eui.Label;
    public get2: eui.Label;
    public get3: eui.Label;
    public get4: eui.Label;
    public get5: eui.Label;
    public clockBtn: eui.Button;
    public task1lab: eui.Label;
    public task2lab: eui.Label;
    public task3lab: eui.Label;
    public task4lab: eui.Label;
    public task5lab: eui.Label;
    public task6lab: eui.Label;

    public task1: eui.Group;
    public task1Btn: eui.Button;
    public counttime: eui.Label;
    public task2: eui.Group;
    public task2Btn: eui.Button;
    public task3: eui.Group;
    public task3Btn: eui.Button;
    public task4: eui.Group;
    public task4Btn: eui.Button;
    public task5: eui.Group;
    public task5Btn: eui.Button;
    public task6: eui.Group;
    public task6Btn: eui.Button;
    public task7: eui.Group;
    public task7Btn: eui.Button;

    public havefinish: eui.Label;
    public finished: eui.Label;
    public haveget: eui.Label;
    public geted: eui.Label;

    public sharefinish:eui.Label;
    public sharetimes:eui.Label;
    public brofinish:eui.Label;
    public brotimes:eui.Label;
    public buyfinish:eui.Label;
    public buytimes:eui.Label;


    private functask1: any;
    private functask2: any;
    private functask3: any;
    private functask4: any;
    private functask5: any;
    private functask6: any;
    private functask7: any;
    public _data: any;
    private scene: any;
    private uid: any;
    private signdate: number = 0;
    private isGuide: boolean = false;

    public task1coin: eui.Label;
    public task1coins: eui.Image;
    public task2coin: eui.Label;
    public task2coins: eui.Image;
    public task3coin: eui.Label;
    public task3coins: eui.Image;
    public task4coin: eui.Label;
    public task4coins: eui.Image;
    public task4dia: eui.Label;
    public task4dias: eui.Image;
    public task5coin: eui.Label;
    public task5coins: eui.Image;
    public task5dia: eui.Label;
    public task5dias: eui.Image;
    public task6coin: eui.Label;
    public task6coins: eui.Image;
    public task6dia: eui.Label;
    public task6dias: eui.Image;



    public clockBtnExposure: any;
    public task1BtnExposure: any;
    public task2BtnExposure: any;
    public task3BtnExposure: any;
    public task4BtnExposure: any;
    public task5BtnExposure: any;
    public task6BtnExposure: any;

    private browsetime:number = 0;

    private isend:boolean;

    private task3time:any;
    constructor(data) {
        super();

        this.isGuide = data.isGuide;
        this.percentHeight = 100;
        this.percentWidth = 100;
        this._data = data.data;
        this.isend = data.isend;
        this.initUI(this._data);
        this.scene = data.scene;
        this.uid = data.partnerUserId;
        this.initBuired();

    }

    initBuired() {
        let clockBtnDpmOut = Buried.connectDpm(110, 12, 1); // 点击埋点   
        let clockBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.clockBtnExposure = Buried.createExposure(clockBtnDpmOut, clockBtnDcmOut);
        NetManager.ins.showLog(this.clockBtnExposure);

        let task1BtnDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
        let task1BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.task1BtnExposure = Buried.createExposure(task1BtnDpmOut, task1BtnDcmOut);
        NetManager.ins.showLog(this.task1BtnExposure);

        let task2BtnDpmOut = Buried.connectDpm(110, 14, 1); // 点击埋点   
        let task2BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.task2BtnExposure = Buried.createExposure(task2BtnDpmOut, task2BtnDcmOut);
        NetManager.ins.showLog(this.task2BtnExposure);

        let task3BtnDpmOut = Buried.connectDpm(110, 15, 1); // 点击埋点   
        let task3BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.task3BtnExposure = Buried.createExposure(task3BtnDpmOut, task3BtnDcmOut);
        NetManager.ins.showLog(this.task3BtnExposure);

        let task4BtnDpmOut = Buried.connectDpm(110, 16, 1); // 点击埋点   
        let task4BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.task4BtnExposure = Buried.createExposure(task4BtnDpmOut, task4BtnDcmOut);
        NetManager.ins.showLog(this.task4BtnExposure);

        let task5BtnDpmOut = Buried.connectDpm(110, 17, 1); // 点击埋点   
        let task5BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.task5BtnExposure = Buried.createExposure(task5BtnDpmOut, task5BtnDcmOut);
        NetManager.ins.showLog(this.task5BtnExposure);

        let task6BtnDpmOut = Buried.connectDpm(110, 18, 1); // 点击埋点   
        let task6BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.task6BtnExposure = Buried.createExposure(task6BtnDpmOut, task6BtnDcmOut);
        NetManager.ins.showLog(this.task6BtnExposure);

    }

    initUI(data) {
        this.taskList.height = GameConst.stage.stageHeight *0.54;
        //taskevery
        if (data.dayInfos) {

            for (let i = 0; i < 5; i++) {
                this["day" + (i + 1)].visible = data.dayInfos[i].sign;
                if (i < 4) {
                    this["get" + (i + 1)].text = GameConst.tranNumber(data.dayInfos[i].coins, 1);
                } else {
                    this["get" + (i + 1)].text = GameConst.tranNumber(data.dayInfos[i].diamonds);
                }

            }
            for (let n = 0; n < 5; n++) {
                if (data.dayInfos[n].sign == false) {
                    this.signdate = n;
                    break;
                }
            }

        }
        if (data.sign) {
            this.setColor(this.clockBtn);
            this.clockBtn.touchChildren = false;
            this.clockBtn.touchEnabled = false;
            this.clearTap(this.clockBtn, this.onTap_clockBtn);
        }

        //task1 每日领金币 倒计时 是否已领取奖励
        this._data = data;
        if (window['takecoins']) {
            this.task1lab.text = "每天7-9点、13-15点、18-21点,\n可免费领取";
            this.task1coin.text = GameConst.tranNumber(window['takecoins']);
            this.task1coins.x = this.task1coin.x + this.task1coin.width + 5;
        } else {
            this.task1lab.text = "每天7-9点、13-15点、18-21点,\n可免费领取1000";
            this.task1coin.text = "1000";
            this.task1coins.x = this.task1coin.x + this.task1coin.width + 5;
        }


        //task1 领取每日金币
        this.counttime.visible = false;
        if (data.takeCoinsTask.takeSign) {
            this.task1Btn.icon = "task1Btn1_png"
            this.onTap(this.task1Btn, this.onTap_task1Btn);
        } else {
            let hour = new Date().getHours();
            let issign: boolean = false;
            if (hour >= 7 && hour < 9) {
                issign = true;
            } else if (hour >= 13 && hour < 15) {
                issign = true;
            } else if (hour >= 18 && hour < 21) {
                issign = true;
            } else {
                issign = false;
            }
            if (issign) {
                this.task1Btn.icon = "task1Btn2_png"
                this.task1Btn.touchChildren = false;
                this.task1Btn.touchEnabled = false;
                this.clearTap(this.task1Btn, this.onTap_task1Btn);
            } else {
                this.counttime.visible = true;
                this.task1Btn.icon = "btnBG_png";
                //this.counttime.text = data.takeCoinsTask[0].nextTakeTime;
                this.clearTap(this.task1Btn, this.onTap_task1Btn);
            }
        }
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame.bind(this, this._data), this);


        //task2 每日分享
        if (data.shareTask) {
            //task2状态
            if (data.shareTask.status == 2) {
                this.task2Btn.icon = "tomorrow_png";
                this.setColor(this.task2Btn);
                this.task2Btn.touchChildren = false;
                this.task2Btn.touchEnabled = false;
                this.sharefinish.visible = false;
                this.sharetimes.visible = false;
                this.clearTap(this.task2Btn, this.functask2);
            } else if (data.shareTask.status == 1) {
                this.task2Btn.icon = "task1Btn1_png";
                this.sharefinish.text = "待领取   次"
                this.sharetimes.text = data.shareTask.unclaimed;
                this.functask2 = this.onTap_task2Btn.bind(this, data.shareTask.status);
                this.onTap(this.task2Btn, this.functask2)
            } else if (data.shareTask.status == 0) {
                this.task2Btn.icon = "task2Btn1_png";
                this.sharefinish.text = "已完成   次"
                this.sharetimes.text = data.shareTask.completed;
                this.functask2 = this.onTap_task2Btn.bind(this, data.shareTask.status);
                this.onTap(this.task2Btn, this.functask2)
            }
            this.task2lab.text = "每天分享，可获得";
            this.task2coin.text = GameConst.tranNumber(data.shareTask.coins);
            this.task2coins.x = this.task2coin.x + this.task2coin.width + 5;
        }
        //task3 浏览
        if (data.browseTask) {
            if (data.browseTask.status == 2) {
                this.task3Btn.icon = "tomorrow_png";
                this.setColor(this.task3Btn);
                this.task3Btn.touchChildren = false;
                this.task3Btn.touchEnabled = false;
                this.brofinish.visible = false;
                this.brotimes.visible = false;
                this.clearTap(this.task3Btn, this.functask3);
            } else if (data.browseTask.status == 1) {
                this.task3Btn.icon = "task1Btn1_png";
                this.brofinish.text = "待领取   次"
                this.brotimes.text = data.browseTask.unclaimed;
                this.functask3 = this.onTap_task3Btn.bind(this, data.browseTask.status, data);
                this.onTap(this.task3Btn, this.functask3)
            } else if (data.browseTask.status == 0) {
                this.task3Btn.icon = "task3Btn1_png";
                this.brofinish.text = "已完成   次"
                this.brotimes.text = data.browseTask.completed;
                this.functask3 = this.onTap_task3Btn.bind(this, data.browseTask.status, data);
                this.onTap(this.task3Btn, this.functask3)
            }
            this.task3lab.text = "浏览指定商品60s以上，\n可获得";
            this.task3coin.text = GameConst.tranNumber(data.browseTask.coins);
            this.task3coins.x = this.task3coin.x + this.task3coin.width + 5;
        }

        //task4 邀请开店
        if (data.openShopTask) {

            if (data.openShopTask.status == 2) {
                this.task4Btn.icon = "tomorrow_png";
                //this.setColor(this.task4Btn);
                this.task4Btn.touchEnabled = false;
                this.task4Btn.touchChildren = false;
                this.finished.visible = false;
                this.havefinish.visible = false;
                this.clearTap(this.task4Btn, this.functask4);
            } else if (data.openShopTask.status == 1) {
                this.task4Btn.icon = "task1Btn1_png";
                this.havefinish.text = "待领取   次"
                this.finished.text = data.openShopTask.unclaimed;
                this.functask4 = this.onTap_task4Btn.bind(this, data.openShopTask.status, data);
                this.onTap(this.task4Btn, this.functask4)
            } else if (data.openShopTask.status == 0) {
                this.task4Btn.icon = "task4Btn1_png";
                this.havefinish.text = "已完成   次"
                this.finished.text = data.openShopTask.completed;
                this.functask4 = this.onTap_task4Btn.bind(this, data.openShopTask.status, data);
                this.onTap(this.task4Btn, this.functask4)
            }
            this.task4lab.text = "邀请好友开店，可获得\n";
            this.task4dia.text = GameConst.tranNumber(data.openShopTask.diamonds);
            this.task4dias.x = this.task4dia.x + this.task4dia.width + 5;
            this.task4coin.x = this.task4dias.x + this.task4dias.width + 5;
            this.task4coin.text = GameConst.tranNumber(data.openShopTask.coins);
            this.task4coins.x = this.task4coin.x + this.task4coin.width + 5;
        }
        //task5 邀请下载
        if (data.downloadTask) {
            this.geted.text = data.downloadTask.unclaimed;
            if (data.downloadTask.status == 2) {
                this.task5Btn.icon = "tomorrow_png";
                //this.setColor(this.task5Btn);
                this.task5Btn.touchChildren = false;
                this.task5Btn.touchEnabled = false;
                this.clearTap(this.task5Btn, this.functask5);
                this.geted.visible = false;
                this.haveget.visible = false;
            } else if (data.downloadTask.status == 1) {
                this.task5Btn.icon = "task1Btn1_png";
                this.haveget.text = "待领取   次"
                this.geted.text = data.downloadTask.unclaimed;
                this.functask5 = this.onTap_task5Btn.bind(this, data.downloadTask.status, data);
                this.onTap(this.task5Btn, this.functask5)


            } else if (data.downloadTask.status == 0) {
                this.task5Btn.icon = "task4Btn1_png";
                this.haveget.text = "已完成   次"
                this.geted.text = data.downloadTask.completed;
                this.functask5 = this.onTap_task5Btn.bind(this, data.downloadTask.status, data);
                this.onTap(this.task5Btn, this.functask5)


            }

            this.task5lab.text = "邀请好友下载微店APP，\n可获得"
            this.task5dia.text = GameConst.tranNumber(data.downloadTask.diamonds);
            this.task5dias.x = this.task5dia.x + this.task5dia.width + 5;
            this.task5coin.x = this.task5dias.x + this.task5dias.width + 5;
            this.task5coin.text = GameConst.tranNumber(data.downloadTask.coins);
            this.task5coins.x = this.task5coin.x + this.task5coin.width + 5;
        }
        //task6 前往购物
        if (data.orderTask) {
            if (data.orderTask.status == 2) {
                this.task6Btn.icon = "tomorrow_png";
                this.setColor(this.task6Btn);
                this.task6Btn.touchChildren = false;
                this.task6Btn.touchEnabled = false;
                this.buyfinish.visible = false;
                this.buytimes.visible = false;
                this.clearTap(this.task6Btn, this.functask6);
            } else if (data.orderTask.status == 1) {
                this.task6Btn.icon = "task1Btn1_png";
                this.buyfinish.text = "待领取   次"
                this.buytimes.text = data.orderTask.unclaimed;
                this.functask6 = this.onTap_task6Btn.bind(this, data.orderTask.status, data);
                this.onTap(this.task6Btn, this.functask6)
            } else if (data.orderTask.status == 0) {
                this.task6Btn.icon = "task6Btn1_png";
                this.buyfinish.text = "已完成   次"
                this.buytimes.text = data.orderTask.completed;
                this.functask6 = this.onTap_task6Btn.bind(this, data.orderTask.status, data);
                this.onTap(this.task6Btn, this.functask6)
            }
            this.task6lab.text = "去指定页面下单成功，可获得\n";
            this.task6dia.text = GameConst.tranNumber(data.orderTask.diamonds);
            this.task6dias.x = this.task6dia.x + this.task6dia.width + 5;
            this.task6coin.x = this.task6dias.x + this.task6dias.width + 5;
            this.task6coin.text = GameConst.tranNumber(data.orderTask.coins);
            this.task6coins.x = this.task6coin.x + this.task6coin.width + 5;
        }

        if(this.isend){
            setTimeout(() => {
                console.log('this.itemList.viewport.contentHeight=',this.taskList.viewport.contentHeight);
                this.taskList.viewport.scrollV = (this.taskList.viewport.contentHeight - this.taskList.height);
            }, 50);
        }
    }

    initEvents() {
        //super.initEvents();
        this.onTap(this.clockBtn, this.onTap_clockBtn);
        if (!this.isGuide) {
            this.onTap(this.closeBtn, this.onTap_closeBtn);
        }
    }

    onEnterFrame(data) {

        //倒计时
        let now = new Date();
        let hour = now.getHours();
        if (hour == 7 || hour == 9 || hour == 13 || hour == 15 || hour == 18 || hour == 21) {
            if (now.getMinutes() == 0 && now.getSeconds() == 0) {
                weidianNet.getTaskInfo((s) => {
                    Waiting.instance.hide();
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.removeEvents();
                    this.onTap(this.clockBtn, this.onTap_clockBtn);
                    this.onTap(this.closeBtn, this.onTap_closeBtn);
                    this.initUI(data.data)
                }, window['projectxId'])
            }
        }
        if (hour < 7) {
            this.task1Btn.icon = "btnBG_png";
            this.counttime.visible = true;
            this.getTimeDiff(7);
        } else if (hour >= 9 && hour < 13) {
            this.task1Btn.icon = "btnBG_png";
            this.counttime.visible = true;
            this.getTimeDiff(13);
        } else if (hour >= 15 && hour < 18) {
            this.task1Btn.icon = "btnBG_png";
            this.counttime.visible = true;
            this.getTimeDiff(18);
        } else if (hour >= 21) {
            this.task1Btn.icon = "btnBG_png";
            this.counttime.visible = true;
            this.getTimeDiff(7);
        }
    }
    getTimeDiff(endTime) {
        let now: any = new Date();
        let year: any = now.getFullYear();
        let month: any = now.getMonth() + 1;
        let day: any = now.getDate();
        let hour = now.getHours();
        if (month < 10) {
            month = "0" + month;
        }
        if (day < 10) {
            day = "0" + day;
        }
        if (endTime < 10) {
            endTime = "0" + endTime;
        }
        endTime = year + "/" + month + "/" + day + " " + endTime + ":00:00";
        var date2 = new Date(endTime);    //结束时间
        if (hour >= 21) {
            var date3 = date2.getTime() - now.getTime() + 24 * 60 * 60 * 1000;
        } else {
            var date3 = date2.getTime() - now.getTime();  //时间差的毫秒数
        }

        //计算出小时数
        var leave1 = date3 % (24 * 3600 * 1000);    //计算天数后剩余的毫秒数
        var hours: any = Math.floor(leave1 / (3600 * 1000));
        //计算相差分钟数
        var leave2 = leave1 % (3600 * 1000);        //计算小时数后剩余的毫秒数
        var minutes: any = Math.floor(leave2 / (60 * 1000));
        //计算相差秒数
        var leave3 = leave2 % (60 * 1000);      //计算分钟数后剩余的毫秒数
        var seconds: any = Math.round(leave3 / 1000);
        //alert(" 用时： " + days + "天 " + hours + "小时 " + minutes + " 分钟" + seconds + " 秒")

        if (seconds < 10) {
            seconds = "0" + seconds;
        } else if (seconds == 60) {
            seconds = "00";
            minutes += 1;
        }
        if (hours < 10) {
            hours = "0" + hours;
        }
        if (minutes < 10) {
            minutes = "0" + minutes;
        }

        this.counttime.text = hours + ":" + minutes + ":" + seconds;
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }

    onTap_clockBtn() {
        //接口
        NetManager.ins.clickLog(this.clockBtnExposure);
        Waiting.instance.show();
        weidianNet.doSign(async (s) => {
            if (!s) {
                if (DataManager.ins.getData("doSign").code == 100211) {
                    ToastCtrl.instance.show(DataManager.ins.getData("doSign").message);
                } else {
                    ToastCtrl.instance.show("打卡失败，请重试~")
                }
                return
            }
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                Waiting.instance.hide();
                let data = DataManager.ins.getData("getTaskInfo").data
                this.removeEvents();
                this.onTap(this.clockBtn, this.onTap_clockBtn);
                this.onTap(this.closeBtn, this.onTap_closeBtn);
                this.initUI(data)
            }, window['projectxId'])
            // ToastCtrl.instance.show("今日打卡成功")
            this.setColor(this.clockBtn);
            this.clockBtn.touchChildren = false;
            this.clockBtn.touchEnabled = false;
            this["day" + (this.signdate + 1)].visible = true;
            this.clearTap(this.clockBtn, this.onTap_clockBtn);
            if (DataManager.ins.getData("getTaskInfo").data.dayInfos[this.signdate].diamonds > 0) {
                await Ani.instance.awardDiamondAni(this);
            } else {
                await Ani.instance.awardCoinAni(this);
            }

            let data = DataManager.ins.getData("doSign").data;
            this.scene.updateData();
            this.scene.updateCoin(Number(data.nowCoins));
            this.scene.updateDiamond(Number(data.nowDiamonds));
            this.scene.updateLevel(data.storeLevel)
            if (data.storeUpgrade) {
                
                this.scene.updateLevel(data.storeLevel)
                if(data.hasUpgradeReward){
                    this.hidePanel();
                    let taskevedata = { storeLevel: data.storeLevel, hasUpgradeReward: data.hasUpgradeReward, upgradeReward: data.upgradeReward, chickenNewEnable: data.chickenNewEnable, feeNewEnable: data.feeNewEnable, grabNewEnable: data.grabNewEnable, exchangeNewEnable: data.exchangeNewEnable, partnerUserId: this.uid, scene: this.scene };
                    PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL, taskevedata);
                }//else{
                //     if (data.grabNewEnable || data.chickenNewEnable || data.feeNewEnable || data.exchangeNewEnable) {
                //         if (data.chickenNewEnable) {
                //             let pumpdata = { storeLevel: data.storeLevel, chickenNewEnable: data.chickenNewEnable, scene: this.scene }
                //             this.scene.updateAddSpeed(pumpdata);
                //         }
                //         if (data.exchangeNewEnable) {
                //             let pumpdata = { storeLevel: data.storeLevel, exchangeNewEnable: data.exchangeNewEnable, scene: this.scene }
                //             this.scene.updateExchange(pumpdata);
                //         }
                //         if (data.grabNewEnable) {
                //             let pumpdata = { storeLevel: data.storeLevel, grabNewEnable: data.grabNewEnable, scene: this.scene }
                //             this.scene.updateVie(pumpdata)
                //         }
                //         if (data.feeNewEnable) {
                //             let pumpdata = { storeLevel: data.storeLevel, feeNewEnable: data.feeNewEnable, scene: this.scene }
                //             this.scene.updateFee(pumpdata);
                //         }
                //     }
                // }
                    
                
            }

        }, window['projectxId'])
    }

    onTap_task1Btn() {
        //接口
        NetManager.ins.clickLog(this.task1BtnExposure);
        Waiting.instance.show();
        weidianNet.getCoin((s) => {
            Waiting.instance.hide();
            if (!s) {
                if (DataManager.ins.getData("getCoin").message) {
                    ToastCtrl.instance.show(DataManager.ins.getData("getCoin").message);
                } else {
                    ToastCtrl.instance.show("领取失败，请稍后重试~")
                }
                return
            }
            ToastCtrl.instance.show("领取成功")
            this.scene.updateCoin(DataManager.ins.getData("getCoin").data.nowCoins);
            this.scene.updateDiamond(DataManager.ins.getData("getCoin").data.nowDiamonds);
            weidianNet.getTaskInfo((s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新任务失败~")
                    return
                }
                let data = DataManager.ins.getData("getTaskInfo").data
                this.removeEvents();
                this.onTap(this.clockBtn, this.onTap_clockBtn);
                this.onTap(this.closeBtn, this.onTap_closeBtn);
                this.initUI(data)
            }, window['projectxId'])
            this.task1Btn.icon = "task1Btn2_png";
            this.clearTap(this.task1Btn, this.onTap_task1Btn)
        }, window['projectxId'])

    }

    //  status == 0未分享 status==1领取奖励
    onTap_task2Btn(status) {
        if (status == 1) {
            Waiting.instance.show();
            //setTimeout(() => {
            weidianNet.doShare((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    if (DataManager.ins.getData("doShare").message) {
                        ToastCtrl.instance.show(DataManager.ins.getData("doShare").message);
                    } else {
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                ToastCtrl.instance.show("领取成功")
                weidianNet.getTaskInfo((s) => {
                    Waiting.instance.hide();
                    if (!s) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.removeEvents();
                    this.onTap(this.clockBtn, this.onTap_clockBtn);
                    this.onTap(this.closeBtn, this.onTap_closeBtn);
                    this.initUI(data)
                }, window['projectxId'])
                let data = DataManager.ins.getData("doShare").data;
                this.scene.updateData();
                this.scene.updateCoin(data.nowCoins);
                this.scene.updateDiamond(data.nowDiamonds);
                this.scene.updateLevel(data.storeLevel)
                if (data.storeUpgrade) {
                    
                    this.scene.updateLevel(data.storeLevel)
                    if(data.hasUpgradeReward){
                        this.hidePanel();
                        let taskevedata = { storeLevel: data.storeLevel, hasUpgradeReward: data.hasUpgradeReward, upgradeReward: data.upgradeReward, chickenNewEnable: data.chickenNewEnable, feeNewEnable: data.feeNewEnable, grabNewEnable: data.grabNewEnable, exchangeNewEnable: data.exchangeNewEnable, partnerUserId: this.uid, scene: this.scene };
                        PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL, taskevedata);
                    }//else{
                    //     if (data.grabNewEnable || data.chickenNewEnable || data.feeNewEnable || data.exchangeNewEnable) {
                    //         if (data.chickenNewEnable) {
                    //             let pumpdata = { storeLevel: data.storeLevel, chickenNewEnable: data.chickenNewEnable, scene: this.scene }
                    //             this.scene.updateAddSpeed(pumpdata);
                    //         }
                    //         if (data.exchangeNewEnable) {
                    //             let pumpdata = { storeLevel: data.storeLevel, exchangeNewEnable: data.exchangeNewEnable, scene: this.scene }
                    //             this.scene.updateExchange(pumpdata);
                    //         }
                    //         if (data.grabNewEnable) {
                    //             let pumpdata = { storeLevel: data.storeLevel, grabNewEnable: data.grabNewEnable, scene: this.scene }
                    //             this.scene.updateVie(pumpdata)
                    //         }
                    //         if (data.feeNewEnable) {
                    //             let pumpdata = { storeLevel: data.storeLevel, feeNewEnable: data.feeNewEnable, scene: this.scene }
                    //             this.scene.updateFee(pumpdata);
                    //         }
                    //     }
                    // }
                    
                }
            }, window['projectxId'])
            //}, 5000);
        } else if (status == 0) {
            //分享接口
            //回调 
            NetManager.ins.clickLog(this.task2BtnExposure);
            Waiting.instance.show();
            weidianNet.getInviteCode((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    ToastCtrl.instance.show("分享失败，请重试~");
                    return
                }
                let sharecode = DataManager.ins.getData("getShopStatus").data;
                window['shareWX'](sharecode, this.uid);
                setTimeout(() => {
                    weidianNet.goShare((ss) => {
                        if (!ss) {
                            Waiting.instance.hide();
                            ToastCtrl.instance.show("分享失败，请重试~")
                            return
                        }
                        weidianNet.getTaskInfo((sss) => {
                            Waiting.instance.hide();
                            if (!sss) {
                                ToastCtrl.instance.show("更新任务失败，请重试~")
                                return
                            }
                            let data = DataManager.ins.getData("getTaskInfo").data
                            this.removeEvents();
                            this.onTap(this.clockBtn, this.onTap_clockBtn);
                            this.onTap(this.closeBtn, this.onTap_closeBtn);
                            this.initUI(data)

                        }, window['projectxId'])
                    }, window['projectxId'])
                }, 5000);

            }, window['projectxId'])
        }
    }

    onTap_task3Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    if (DataManager.ins.getData("takeReward").message) {
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    } else {
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                ToastCtrl.instance.show("领取成功")
                this.scene.updateCoin(DataManager.ins.getData("takeReward").data.nowCoins);
                this.scene.updateDiamond(DataManager.ins.getData("takeReward").data.nowDiamonds);
                weidianNet.getTaskInfo((ss) => {
                    Waiting.instance.hide();
                    if (!ss) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.removeEvents();
                    this.onTap(this.clockBtn, this.onTap_clockBtn);
                    this.onTap(this.closeBtn, this.onTap_closeBtn);
                    this.initUI(data)
                }, window['projectxId'])
                // this.clearTap(this.task3Btn, this.functask3);
                // this.task3Btn.icon = "task1Btn2_png";
            }, "browse", window['projectxId'])
        } else if (status == 0) {
            //浏览商品接口
            //回调
            NetManager.ins.clickLog(this.task3BtnExposure);
            if (data.browseTask.url) {
                window.location.href = `weidianbuyer://wdb/webview?url=${encodeURIComponent(data.browseTask.url)}`;
                this.browsetime = new Date().getTime()
                this.task3time = setTimeout(() => {
                    // window.location.reload();
                    Waiting.instance.show();
                    
                        weidianNet.getTaskInfo((s) => {
                            Waiting.instance.hide();
                            if (!s) {
                                ToastCtrl.instance.show("更新任务失败，请重试~")
                                return
                            }
                            this.removeEvents();
                            this.onTap(this.clockBtn, this.onTap_clockBtn);
                            this.onTap(this.closeBtn, this.onTap_closeBtn);
                            let data = { data: DataManager.ins.getData("getTaskInfo").data, partnerUserId: DataManager.ins.getData("index").data.partnerUserId, scene: this }
                            this.initUI(data.data)
                        }, window['projectxId'])
                    
                }, 65000);
            }


            // weidianNet.getTaskInfo((s) => {
            //     Waiting.instance.hide();
            //     if (!s) {
            //         ToastCtrl.instance.show("更新任务失败，请重试~")
            //         return
            //     }
            //     let data = DataManager.ins.getData("getTaskInfo").data
            //     this.initUI(data)
            // }, window['projectxId'])
            // this.task3Btn.icon = "task1Btn1_png";
            // this.clearTap(this.task3Btn, this.functask3);
            // this.functask3 = this.onTap_task3Btn.bind(this, 1);
            // this.onTap(this.task3Btn, this.functask3);
        }
    }
    onTap_task4Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    if (DataManager.ins.getData("takeReward").message) {
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    } else {
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                ToastCtrl.instance.show("领取成功")
                this.scene.updateCoin(DataManager.ins.getData("takeReward").data.nowCoins);
                this.scene.updateDiamond(DataManager.ins.getData("takeReward").data.nowDiamonds);
                weidianNet.getTaskInfo((ss) => {
                    Waiting.instance.hide();
                    if (!ss) {

                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.removeEvents();
                    this.onTap(this.clockBtn, this.onTap_clockBtn);
                    this.onTap(this.closeBtn, this.onTap_closeBtn);
                    this.initUI(data)
                }, window['projectxId'])
                // this.clearTap(this.task4Btn, this.functask4);
                // this.task4Btn.icon = "task1Btn2_png";
            }, "open", window['projectxId'])
        } else if (status == 0) {
            //邀请开店开店接口
            //回调
            NetManager.ins.clickLog(this.task4BtnExposure);
            Waiting.instance.show();
            weidianNet.getInviteCode((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    ToastCtrl.instance.show("分享失败，请重试~");
                    return
                }
                let sharecode = DataManager.ins.getData("getShopStatus").data;
                window['shareWX'](sharecode, this.uid);

                setTimeout(() => {
                    weidianNet.getTaskInfo((s) => {
                        Waiting.instance.hide();
                        if (!s) {
                            ToastCtrl.instance.show("更新任务失败，请重试~")
                            return
                        }
                        let data = DataManager.ins.getData("getTaskInfo").data
                        this.removeEvents();
                        this.onTap(this.clockBtn, this.onTap_clockBtn);
                        this.onTap(this.closeBtn, this.onTap_closeBtn);
                        this.initUI(data)
                    }, window['projectxId'])
                }, 5000)

                // this.task4Btn.icon = "task1Btn1_png";
                // this.clearTap(this.task4Btn, this.functask4);
                // this.functask4 = this.onTap_task4Btn.bind(this, 1);
                // this.onTap(this.task4Btn, this.functask4);
                // }, window['projectxId'])
            }, window['projectxId'])
        }
    }
    onTap_task5Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                if (!s) {

                    Waiting.instance.hide();
                    if (DataManager.ins.getData("takeReward").message) {
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    } else {
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }
                ToastCtrl.instance.show("领取成功")
                this.scene.updateCoin(DataManager.ins.getData("takeReward").data.nowCoins);
                this.scene.updateDiamond(DataManager.ins.getData("takeReward").data.nowDiamonds);
                weidianNet.getTaskInfo((ss) => {
                    Waiting.instance.hide();
                    if (!ss) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.removeEvents();
                    this.onTap(this.clockBtn, this.onTap_clockBtn);
                    this.onTap(this.closeBtn, this.onTap_closeBtn);
                    this.initUI(data)
                }, window['projectxId'])
                //this.clearTap(this.task5Btn, this.functask5);
                // this.task5Btn.icon = "task1Btn2_png";
            }, "download", window['projectxId'])
        } else if (status == 0) {
            //邀请下载接口
            //回调
            NetManager.ins.clickLog(this.task5BtnExposure);
            Waiting.instance.show();
            weidianNet.getInviteCode((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    ToastCtrl.instance.show("分享失败，请重试~");
                    return
                }
                let sharecode = DataManager.ins.getData("getShopStatus").data;
                window['shareWX'](sharecode, this.uid);
                setTimeout(() => {

                    weidianNet.getTaskInfo((s) => {
                        Waiting.instance.hide();
                        if (!s) {
                            ToastCtrl.instance.show("更新任务失败，请重试~")
                            return
                        }
                        let data = DataManager.ins.getData("getTaskInfo").data
                        this.removeEvents();
                        this.onTap(this.clockBtn, this.onTap_clockBtn);
                        this.onTap(this.closeBtn, this.onTap_closeBtn);
                        this.initUI(data)
                    }, window['projectxId'])
                }, 5000)
            })

        }
    }
    onTap_task6Btn(status, data) {
        if (status == 1) {
            Waiting.instance.show();
            weidianNet.takeReward((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    if (DataManager.ins.getData("takeReward").message) {
                        ToastCtrl.instance.show(DataManager.ins.getData("takeReward").message);
                    } else {
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    }
                    return
                }

                ToastCtrl.instance.show("领取成功")
                this.scene.updateCoin(DataManager.ins.getData("takeReward").data.nowCoins);
                this.scene.updateDiamond(DataManager.ins.getData("takeReward").data.nowDiamonds);
                weidianNet.getTaskInfo((ss) => {
                    Waiting.instance.hide();
                    if (!ss) {
                        ToastCtrl.instance.show("更新任务失败，请重试~")
                        return
                    }
                    let data = DataManager.ins.getData("getTaskInfo").data
                    this.removeEvents();
                    this.onTap(this.clockBtn, this.onTap_clockBtn);
                    this.onTap(this.closeBtn, this.onTap_closeBtn);
                    this.initUI(data)
                }, window['projectxId'])
                // this.clearTap(this.task6Btn, this.functask6);
                // this.task6Btn.icon = "task1Btn2_png";
            }, "order", window['projectxId'])
        } else if (status == 0) {
            //购买好物接口
            //回调
            NetManager.ins.clickLog(this.task6BtnExposure);
            if (data.orderTask.url) {
                window.location.href = `weidianbuyer://wdb/webview?url=${encodeURIComponent(data.orderTask.url)}`;
                setTimeout(() => {
                    Waiting.instance.show();
                    setTimeout(()=>{
                        weidianNet.getTaskInfo((s) => {
                            Waiting.instance.hide();
                            if (!s) {
                                ToastCtrl.instance.show("更新任务失败，请重试~")
                                return
                            }
                            this.removeEvents();
                            this.onTap(this.clockBtn, this.onTap_clockBtn);
                            this.onTap(this.closeBtn, this.onTap_closeBtn);
                            let data = { data: DataManager.ins.getData("getTaskInfo").data, partnerUserId: DataManager.ins.getData("index").data.partnerUserId, scene: this }
                            this.initUI(data.data)
                        }, window['projectxId'])
                    },1000)
                    
                    // window.location.reload();
                }, 3000);
            }


            // Waiting.instance.show();
            // weidianNet.getTaskInfo((s) => {
            //     Waiting.instance.hide();
            //     if (!s) {
            //         ToastCtrl.instance.show("更新任务失败，请重试~")
            //         return
            //     }
            //     let data = DataManager.ins.getData("getTaskInfo").data
            //     this.initUI(data)
            // }, window['projectxId'])
            // this.task6Btn.icon = "task1Btn1_png";
            // this.clearTap(this.task6Btn, this.functask6);
            // this.functask6 = this.onTap_task6Btn.bind(this, 1);
            // this.onTap(this.task6Btn, this.functask6);
        }
    }

    onTap_closeBtn() {
        Waiting.instance.show();
        if(this.browsetime>0){
            let now = new Date().getTime();
            if(now-this.browsetime<65000){
                clearTimeout(this.task3time);
            }
        }
        weidianNet.index((s) => {
            Waiting.instance.hide()
            if (!s) {       
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            weidianNet.getTaskInfo((ss) => {
                if (!ss) {
                    ToastCtrl.instance.show("更新任务失败，请重试~")
                    return
                }
                const unclaimed = DataManager.ins.getData("getTaskInfo").data.unclaimed;
                if (unclaimed) {
                    this.scene.redPoint.visible = true;
                } else {
                    this.scene.redPoint.visible = false;
                }

            }, window['projectxId'])
            this.scene.updateData()
            this.slideDown()
        }, window['projectxId'])
    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.clockBtn, this.onTap_clockBtn);
        this.clearTap(this.task1Btn, this.onTap_task1Btn);
        this.clearTap(this.task2Btn, this.functask2);
        this.clearTap(this.task3Btn, this.functask3);
        this.clearTap(this.task4Btn, this.functask4);
        this.clearTap(this.task5Btn, this.functask5);
        this.clearTap(this.task6Btn, this.functask6);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame.bind(this, this._data), this)

    }

}