import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import { weidianNet } from "../NetConst";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import Waiting from "../waiting/Waiting";
import { DataManager } from './../../libs/tw/manager/DataManager';
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class SignPanel extends Panel {
    protected get skinKey() { return 'pop/Sign' }
    public closeBtn: eui.Button;
    public right1: eui.Image;
    public right2: eui.Image;
    public right3: eui.Image;
    public right4: eui.Image;
    public right5: eui.Image;
    public getCoinBtn: eui.Button;

    public day1Img: eui.Image;
    public day2Img: eui.Image;
    public day3Img: eui.Image;
    public day4Img: eui.Image;
    public day5Img: eui.Image;

    public day1: eui.Label;
    public day2: eui.Label;
    public day3: eui.Label;
    public day4: eui.Label;
    public day5: eui.Label;

    private func: any;
    private scene: any;
    private uid: any;
    private sign: any;

    private signdate: number = 0;

    public getCoinBtnExposure:any;
    constructor(data) {
        super();
        let _data = data.data;
        this.scene = data.scene;
        this.uid = data.partnerUserId;
        this.sign = data.sign;
        this.initUI(_data)
        this.initBuired();
    }

    initBuired(){
        let getCoinBtnDpmOut = Buried.connectDpm(110, 29, 1); // 点击埋点   
        let getCoinBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.getCoinBtnExposure = Buried.createExposure(getCoinBtnDpmOut, getCoinBtnDcmOut);
        NetManager.ins.showLog(this.getCoinBtnExposure);
        
    }
    initUI(data) {
        this.right1.visible = false;
        this.right2.visible = false;
        this.right3.visible = false;
        this.right4.visible = false;
        this.right5.visible = false;

        if (data.dayInfos) {
            for (let i = 0; i < 5; i++) {
                if (data.dayInfos[i].diamonds > 0) {
                    this["day" + (i + 1) + "Img"].source = "popdia_png";
                    this["day" + (i + 1)].text = data.dayInfos[i].diamonds;
                } else {
                    this["day" + (i + 1) + "Img"].source = "signcoin_png";
                    this["day" + (i + 1)].text = data.dayInfos[i].coins;
                }

                this["right" + (i + 1)].visible = data.dayInfos[i].sign
            }
            for (let n = 0; n < 5; n++) {
                if (data.dayInfos[n].sign == false) {
                    this.signdate = n;
                    break;
                }
            }
        }
        if (!this.sign) {
            this.onTap(this.getCoinBtn, this.onTap_getCoin);
        }
    }
    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
    }

    onTap_getCoin() {
        //接口
        if (!this.sign) {
            NetManager.ins.clickLog(this.getCoinBtnExposure);
            Waiting.instance.show()
            weidianNet.doSign(async (s) => {
                Waiting.instance.hide()
                if (!s) {
                    if (DataManager.ins.getData("doSign").code == 100211) {
                        ToastCtrl.instance.show(DataManager.ins.getData("doSign").message);
                    } else {
                        ToastCtrl.instance.show("打卡失败，请重试~")
                    }
                    return
                }
                this.setColor(this.getCoinBtn);
                this.getCoinBtn.touchChildren = false;
                this.getCoinBtn.touchEnabled = false;
                // this.clearTap(this.getCoinBtn, this.func);
                // this.func = this.onTap_getCoin.bind(this, true);
                // this.onTap(this.getCoinBtn, this.func);
                this["right" + (this.signdate + 1)].visible = true;
                if (DataManager.ins.getData("getTaskInfo").data.dayInfos[this.signdate].diamonds > 0) {
                    await Ani.instance.awardDiamondAni(this);
                } else {
                    await Ani.instance.awardCoinAni(this);
                }

                let data = DataManager.ins.getData("doSign").data;
                // this.scene.updateData();
                this.scene.updateCoin(data.nowCoins);
                this.scene.updateDiamond(data.nowDiamonds);
                this.scene.updateLevel(data.storeLevel)
                this.hidePanel();
                if (data.storeUpgrade) {
                    if(data.hasUpgradeReward){
                        let signdata = { hasUpgradeReward: data.hasUpgradeReward,storeLevel: data.storeLevel, upgradeReward: data.upgradeReward, exchangeNewEnable: data.exchangeNewEnable, chickenNewEnable: data.chickenNewEnable, feeNewEnable: data.feeNewEnable, grabNewEnable: data.grabNewEnable, partnerUserId: this.uid, scene: this.scene };
                        PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL, signdata);
                    }//else{
                        // if (data.grabNewEnable || data.chickenNewEnable || data.feeNewEnable || data.exchangeNewEnable) {
                        //     if (data.chickenNewEnable) {
                        //         let pumpdata = { storeLevel: data.storeLevel, chickenNewEnable: data.chickenNewEnable, scene: this.scene }
                        //         this.scene.updateAddSpeed(pumpdata);
                        //     }
                        //     if (data.exchangeNewEnable) {
                        //         let pumpdata = { storeLevel: data.storeLevel, exchangeNewEnable: data.exchangeNewEnable, scene: this.scene }
                        //         this.scene.updateExchange(pumpdata);
                        //     }
                        //     if (data.grabNewEnable) {
                        //         let pumpdata = { storeLevel: data.storeLevel, grabNewEnable: data.grabNewEnable, scene: this.scene }
                        //         this.scene.updateVie(pumpdata)
                        //     }
                        //     if (data.feeNewEnable) {
                        //         let pumpdata = { storeLevel: data.storeLevel, feeNewEnable: data.feeNewEnable, scene: this.scene }
                        //         this.scene.updateFee(pumpdata);
                        //     }
                        // }
                    // }
                    
                }

            }, window['projectxId']);
        }
    }


    onTap_closeBtn() {
        this.hidePanel();
    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.getCoinBtn, this.func);
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
}