import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import GameConst, { wait } from "../GameConst";
import Waiting from "../waiting/Waiting";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class SharePanel extends Panel {
    protected get skinKey() { return 'pop/Share' }
    public closeBtn: eui.Button;
    public wxshareBtn: eui.Button;
    public sharelab: eui.Label;
    private uid: any;

    public wxshareBtnExposure:any;

    private scene: any;
    constructor(data?) {
        super();
        if (data) {
            this.scene = data.scene;
            this.uid = data.partnerUserId;
            this.sharelab.text = "好友通过邀请成功开店，\n你可获得超值钻石金币奖励";
        }
        this.initBuired();
    }
    initBuired(){
        let wxshareBtnDpmOut = Buried.connectDpm(110, 24, 1); // 点击埋点   
        let wxshareBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.wxshareBtnExposure = Buried.createExposure(wxshareBtnDpmOut, wxshareBtnDcmOut);
        NetManager.ins.showLog(this.wxshareBtnExposure);
        

    }

    initEvents() {
        //super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.wxshareBtn, this.onTap_shareBtn);
    }
    onTap_closeBtn() {
        Waiting.instance.show();
        if (this.scene) {
            weidianNet.index((s) => {
                Waiting.instance.hide();
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                this.scene.updateData()
                this.hidePanel();
            }, window['projectxId'])
        } else {
            weidianNet.index((s) => {
                Waiting.instance.hide();
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                this.hidePanel();
            }, window['projectxId'])
        }

    }
    onTap_shareBtn() {
        //分享唤起
        NetManager.ins.clickLog(this.wxshareBtnExposure);
        Waiting.instance.show();
        weidianNet.getInviteCode((s) => {
            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("分享失败，请重试~");
                return
            }
            let sharecode = DataManager.ins.getData("getShopStatus").data;
            window['shareWX'](sharecode, this.uid);
            weidianNet.index((s) => {
                Waiting.instance.hide();
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                //this.slideDown()
                console.log(this.scene);
                
                if(this.scene ){
                    if( this.scene.skinKey == "Main"){
                         this.scene.updateData();
                    }
                   

                }
                this.hidePanel();
            }, window['projectxId'])
        }, window['projectxId'])

    }
}