import { wait } from './../GameConst';
import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Waiting from "../waiting/Waiting";
import { GCache } from '../../libs/tc/util/GCache';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class RevenuePanel extends Panel {
    protected get skinKey() { return 'pop/Revenue' }
    public shareBtn: eui.Button;
    public closeBtn: eui.Button;
    public revenuenum: eui.Label;
    private scene: any;
    private uid: any;

    public shareBtnExposure:any;

    constructor(data) {
        super();
        this.scene = data.scene;
        this.initUI(data);
        this.uid = data.partnerUserId;
        this.initBuired();
    }
    initBuired(){
        let shareBtnDpmOut = Buried.connectDpm(110, 33, 1); // 点击埋点   
        let shareBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.shareBtnExposure = Buried.createExposure(shareBtnDpmOut, shareBtnDcmOut);
        NetManager.ins.showLog(this.shareBtnExposure);
        
    }

    initUI(data) {
        this.revenuenum.text = GameConst.tranNumber(data.coin);
    }
    initEvents() {
        // super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.shareBtn, this.onTap_shareBtn);

    }

    onTap_closeBtn() {
        //领取coin type = 服务员
        Waiting.instance.show();
        weidianNet.waiterGold((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("活动太火爆了，请稍后再来~");
                return
            }
            weidianNet.index(async (s) => {
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")

                    await Ani.instance.awardCoinAni(this);
                    this.scene.updateCoin(Number(DataManager.ins.getData("waiterGold").data));
                    this.scene.updateSign();
                    this.goSign();
                    this.hidePanel();
                    return

                }
                await Ani.instance.awardCoinAni(this);
                this.scene.updateData();
                this.scene.updateCoin(Number(DataManager.ins.getData("waiterGold").data));
                this.hidePanel()
                this.goSign();

            }, window['projectxId'])
        }, window['projectxId'], false);
    }
    onTap_shareBtn() {
        //分享弹窗
        //弹窗跳起
        NetManager.ins.clickLog(this.shareBtnExposure);
        Waiting.instance.show();
        weidianNet.getInviteCode((s) => {

            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("分享失败，请重试~");
                return
            }
            let sharecode = DataManager.ins.getData("getShopStatus").data;
            window['shareWX'](sharecode, this.uid);
            setTimeout(() => {
                weidianNet.waiterGold((s) => {
                    Waiting.instance.hide();
                    if (!s) {
                        ToastCtrl.instance.show("活动太火爆了，请稍后再来~");
                        return
                    }
                    weidianNet.index(async (s) => {
                        if (!s) {
                            ToastCtrl.instance.show("更新数据失败，请重试~")

                        }
                        await wait(500)
                        await Ani.instance.awardCoinAni(this);
                        this.scene.updateCoin(Number(DataManager.ins.getData("waiterGold").data));
                        this.hidePanel()
                        this.goSign();
                    }, window['projectxId'])
                }, window['projectxId'], true);
            }, 5000)

        }, window['projectxId'])


    }

    goSign() {
        let sign = DataManager.ins.getData("getTaskInfo").data.sign
        if (!sign && !GCache.readCache(new Date(new Date().toLocaleDateString()).getTime() + DataManager.ins.getData("index").data.partnerUserId + "")) {
            // 每日首次访问
            GCache.writeCache(new Date(new Date().toLocaleDateString()).getTime() + DataManager.ins.getData("index").data.partnerUserId + "", 1)
            // 今日未签到  弹签到弹窗
            let data = { sign: sign, partnerUserId: this.uid, data: DataManager.ins.getData("getTaskInfo").data, scene: this.scene }
            PanelCtrl.instance.show(ModuleTypes.SIGN_PANEL, data);
        }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.shareBtn, this.onTap_shareBtn);
    }
} 