import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class PumpedPanel extends Panel {
    protected get skinKey() { return 'pop/Pumped' }
    public textImg: eui.Image;
    public pumpBtn: eui.Button;
    public closeBtn: eui.Button;

    private scene: any;

    public light: eui.Image;
    public start1: eui.Image;
    public start2: eui.Image;
    public start3: eui.Image;


    public pump1BtnExposure: any;
    public pump2BtnExposure: any;
    public pump3BtnExposure: any;

    private chickenNewEnable: any;
    private grabNewEnable: any;
    private exchangeNewEnable: any;
    constructor(data) {
        super();
        this.scene = data.scene;
        this.chickenNewEnable = data.chickenNewEnable;
        this.grabNewEnable = data.grabNewEnable;
        this.exchangeNewEnable = data.exchangeNewEnable;
        this.initUI(data);
        this.initBuired();
    }
    initBuired() {
        if(this.chickenNewEnable){
            let pump1BtnDpmOut = Buried.connectDpm(110, 25, 1); // 点击埋点   
            let pump1BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.pump1BtnExposure = Buried.createExposure(pump1BtnDpmOut, pump1BtnDcmOut);
            NetManager.ins.showLog(this.pump1BtnExposure);
        }
        if(this.grabNewEnable){
            let pump2BtnDpmOut = Buried.connectDpm(110, 26, 1); // 点击埋点   
            let pump2BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.pump2BtnExposure = Buried.createExposure(pump2BtnDpmOut, pump2BtnDcmOut);
            NetManager.ins.showLog(this.pump2BtnExposure);
        }
        if(this.exchangeNewEnable){
            let pump3BtnDpmOut = Buried.connectDpm(110, 27, 1); // 点击埋点   
            let pump3BtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.pump3BtnExposure = Buried.createExposure(pump3BtnDpmOut, pump3BtnDcmOut);
            NetManager.ins.showLog(this.pump3BtnExposure);
        }

    }
    initUI(data) {
        
        if (data.chickenNewEnable) {
            this.textImg.source = "pumpedtext_png"//打鸡血
            this.textImg.width = 510;
            this.textImg.height = 175;
            this.pumpBtn.icon = "pumpedBtn_png"
        } else if (data.grabNewEnable) {
            this.textImg.source = "oktext_png"//抢单
            this.textImg.width = 510;
            this.textImg.height = 175;
            this.pumpBtn.icon = "okBtn_png"
        } else if (data.exchangeNewEnable) {
            this.textImg.source = "changetext_png"//兑换
            this.textImg.width = 510;
            this.textImg.height = 79;
            this.pumpBtn.icon = "changeBtn_png"
        }
        egret.Tween.get(this.start1)
            .set({ y: 295, alpha: 0 })
            .wait(380)
            .to({ alpha: 1 })
            .to({ y: 220 }, 240)
            .to({ y: 230 }, 100)
        egret.Tween.get(this.start2)
            .set({ y: 271, alpha: 0 })
            .wait(450)
            .to({ alpha: 1 })
            .to({ y: 196 }, 230)
            .to({ y: 206 }, 100)
        egret.Tween.get(this.start3)
            .set({ y: 295, alpha: 0 })
            .wait(520)
            .to({ alpha: 1 })
            .to({ y: 220 }, 230)
            .to({ y: 230 }, 100)
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.pumpBtn, this.onTap_closeBtn);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }
    onEnterFrame() {
        this.light.rotation++;
    }

    onTap_closeBtn() {
        if (this.chickenNewEnable) {
            NetManager.ins.clickLog(this.pump1BtnExposure);
        } else if (this.grabNewEnable) {
            NetManager.ins.clickLog(this.pump2BtnExposure);
        } else if (this.exchangeNewEnable) {
            NetManager.ins.clickLog(this.pump3BtnExposure);
        }
        weidianNet.index((s) => {
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.hidePanel();
            this.scene.updateData();
            this.scene.updateVie();

        }, window['projectxId'])
    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.pumpBtn, this.onTap_closeBtn);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    }

}