import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import GameConst from "../GameConst";
import Waiting from "../waiting/Waiting";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class PayPanel extends Panel {
    protected get skinKey() { return 'pop/Pay' }
    public payBtn: eui.Button;
    public closeBtn: eui.Button;
    public costnum: eui.Label;
    public coinnum: eui.Label;
    public lineImg: eui.Image;

    public func: any;
    public func2: any;
    public scene: any;

    public payBtnExposure: any;
    constructor(data) {
        super();
        this.initUI(data);
        this.initBuired();
    }
    initBuired() {
        let payBtnDpmOut = Buried.connectDpm(110, 28, 1); // 点击埋点   
        let payBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.payBtnExposure = Buried.createExposure(payBtnDpmOut, payBtnDcmOut);
        NetManager.ins.showLog(this.payBtnExposure);

    }
    initUI(data) {
        //获取缴费数据
        console.log(data)
        this.scene = data.scene;
        this.func2 = data.func;
        this.costnum.text = GameConst.tranNumber(data.data.coins);
        this.coinnum.text = GameConst.tranNumber(data.data.coins / 0.8);
        this.func = this.onTap_payBtn.bind(this, data.goldCoin, data.data.coins);
        this.onTap(this.payBtn, this.func);

    }
    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);

    }
    onTap_closeBtn() {
        Waiting.instance.show();
        weidianNet.index((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.scene.updateData()
            this.hidePanel();
        }, window['projectxId'])
    }

    onTap_payBtn(goldCoin, coins) {
        if (goldCoin >= coins) {
            //接口
            NetManager.ins.clickLog(this.payBtnExposure);
            Waiting.instance.show();
            weidianNet.doPay((s) => {
                Waiting.instance.hide()
                if (!s) {
                    if (DataManager.ins.getData("doPay").code == 100301 || DataManager.ins.getData("doPay").code == 100302 || DataManager.ins.getData("doPay").code == 100303) {
                        ToastCtrl.instance.show(DataManager.ins.getData("doPay").message);
                    } else {
                        ToastCtrl.instance.show("缴费失败，请重试~");
                    }
                    return
                }
                this.scene.mainConfig.feeBuff = 1;
                ToastCtrl.instance.show("缴费成功");
                weidianNet.index((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("更新数据失败，请重试~")
                        return
                    }
                    this.scene.updateData()
                    if (this.scene.mainConfig.chickrenStatus == 2) {
                        this.scene.updateWaitressCapacity(1500)
                    } else {
                        this.scene.updateWaitressCapacity()
                    }
                    this.func2();
                    this.hidePanel();
                }, window['projectxId'])
            }, window['projectxId'])
        } else {
            Waiting.instance.show();
            weidianNet.index((s) => {
                Waiting.instance.hide();
                if (!s) {
                    ToastCtrl.instance.show("更新数据失败，请重试~")
                    return
                }
                ToastCtrl.instance.show("金币不足哦~")
                this.scene.updateData()
                this.hidePanel();
            }, window['projectxId'])

        }

    }
}