import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class LeavePanel extends Panel {
    protected get skinKey() { return 'pop/Leave' }
    public closeBtn: eui.Button;
    public leaveBtn: eui.Button;
    public nextBtn: eui.Button;

    public leaveBtnExposure: any;
    public nextBtnExposure: any;
    constructor(data) {
        super();
        this.initBuired();
    }
    initBuired() {
        let leaveBtnDpmOut = Buried.connectDpm(110, 30, 1); // 点击埋点   
        let leaveBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.leaveBtnExposure = Buried.createExposure(leaveBtnDpmOut, leaveBtnDcmOut);
        NetManager.ins.showLog(this.leaveBtnExposure);

        let nextBtnDpmOut = Buried.connectDpm(110, 31, 1); // 点击埋点   
        let nextBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.nextBtnExposure = Buried.createExposure(nextBtnDpmOut, nextBtnDcmOut);
        NetManager.ins.showLog(this.nextBtnExposure);

    }
    initEvents() {
        //super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.nextBtn, this.onTap_closeBtn);
        this.onTap(this.leaveBtn, this.onTap_leave);
    }
    onTap_closeBtn() {
        NetManager.ins.clickLog(this.nextBtnExposure);
        weidianNet.index((s) => {
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.hidePanel()
        }, window['projectxId'])
    }
    onTap_leave() {
        //退出游戏
        NetManager.ins.clickLog(this.leaveBtnExposure);
        this.leaveGame();
    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.nextBtn, this.onTap_closeBtn);
        this.clearTap(this.leaveBtn, this.onTap_leave);
    }


    leaveGame() {
        window["playMusic"]("bgMusic", false);

        var param = {} 
        window['KDJSBridge2'].call('WDJSBridge', 'goBack', function (data) { })
    }
}