import { playSound, SoundType } from './../ctrls/soundCtrl';

import { wait } from './../GameConst';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import { GCache } from './../../libs/tc/util/GCache';
import { weidianNet } from './../NetConst';
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import SceneCtrl from "../ctrls/sceneCtrl";
import GameConst from "../GameConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Ani from "../mainScene/Ani";
import Waiting from '../waiting/Waiting';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';

export default class GuideSurePanel extends Panel {
    protected get skinKey() { return 'pop/GuideSure' }

    public shebeiImg: eui.Image;
    public title: eui.Label;
    public message: eui.Label;
    public coinnum: eui.Label;
    public dianum: eui.Label;
    public buyBtn: eui.Button;
    public closeBtn: eui.Button;
    public costnum: eui.Label;
    public costcoin: eui.Image;
    public gstip1: eui.Image;
    public gstip2: eui.Image;
    public tipclose: eui.Image;
    public func: any;
    public funcclose: any;
    public scene: any;
    private uid: any;
    private isGuide: boolean = false;

    public buyBtnExposure: any;

    constructor(data) {
        super();
        this.isGuide = data.isGuide;
        this.scene = data.scene;
        this.uid = data.partnerUserId;
        this.initUI(data);
        this.initBuired();
    }

    initBuired() {
        let buyBtnDpmOut = Buried.connectDpm(110, 19, 1); // 点击埋点   
        let buyBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.buyBtnExposure = Buried.createExposure(buyBtnDpmOut, buyBtnDcmOut);
        NetManager.ins.showLog(this.buyBtnExposure);

    }

    initUI(data) {
        this.gstip2.visible = false;
        this.onTap(this.gstip1, this.onTap_gstip1);
        //this.onTap(this.tipclose,this.onTap_gstip2);
        this.tipclose.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_gstip2, this)
        let name: string = "";
        //金币数据 钻石数据  名称文案缺
        if (data.type == 1) {
            name = "desk";
            if (data.level == 1) {
                this.title.text = "简易木质桌椅"
                this.message.text = "简单实用的首选"
            } else if (data.level == 2) {
                this.title.text = "复古典雅桌椅"
                this.message.text = "怀旧人士的最爱"
            } else if (data.level == 3) {
                this.title.text = "尊贵首席桌椅"
                this.message.text = "逼格提升专用桌椅"
            }
        } else if (data.type == 4) {
            name = "coffee";
            if (data.level == 1) {
                this.title.text = "简易迷你咖啡机"
                this.message.text = "滴漏式咖啡壶茶壶两用"
            } else if (data.level == 2) {
                this.title.text = "半自动美式咖啡机"
                this.message.text = "新鲜研磨，还原醇香"
            } else if (data.level == 3) {
                this.title.text = "全自动现磨一体机"
                this.message.text = "花式咖啡，一键制作"
            }
        } else if (data.type == 5) {
            name = "cash";
            if (data.level == 1) {
                this.title.text = "简约现代收银台"
                this.message.text = "招揽生意入门级法宝"
            } else if (data.level == 2) {
                this.title.text = "宽敞别致收银台"
                this.message.text = "瞬间勾住门外顾客"
            } else if (data.level == 3) {
                this.title.text = "招财进宝型收银台"
                this.message.text = "据说用这个收银台的\n都很赚"
            }
        } else if (data.type == 2) {
            name = "oven";
            if (data.level == 1) {
                this.title.text = "小型蛋糕烤箱"
                this.message.text = "自动烘焙多功能"
            } else if (data.level == 2) {
                this.title.text = "全自动多功能烘焙"
                this.message.text = "极简呈现，焙出腔调"
            } else if (data.level == 3) {
                this.title.text = "嵌入式蒸烤一体机"
                this.message.text = "花样72变,精致厨房生活"
            }
        } else if (data.type == 3) {
            name = "frige";
            if (data.level == 1) {
                this.title.text = "双门实用冰箱"
                this.message.text = "别看我小，但我实用"
            } else if (data.level == 2) {
                this.title.text = "智能静音双开门"
                this.message.text = "超大容量，智能锁鲜"
            } else if (data.level == 3) {
                this.title.text = "6门复式冰箱"
                this.message.text = "高贵优雅，智能温控"
            }
        } else if (data.type == 6) {
            name = "wait"
            if (data.level == 1) {
                this.title.text = "贱萌胖妹妹"
                this.message.text = "爱做鬼脸，不爱减肥"
            } else if (data.level == 2) {
                this.title.text = "超嗲小猫咪"
                this.message.text = "别养猫了，养服务员吧"
            } else if (data.level == 3) {
                this.title.text = "人气小兔纸"
                this.message.text = "可能会带来额外小费哦"
            }
        }
        this.shebeiImg.source = "gb" + name + data.level + "_png";
        this.costnum.text = GameConst.tranNumber(data.cost, 1);
        this.coinnum.text = GameConst.tranNumber(Math.floor(data.capacity / 24)) + " 每小时"
        this.dianum.text = data.rewardDiamond;
        this.func = this.onTap_Buy.bind(this, data.cost, data.coin, data.type, data.level);
        this.costnum.touchEnabled = false;
        this.onTap(this.buyBtn, this.func);
        if (data.status == 1) {
            if (data.cost > data.coin) {
                this.setColor(this.costnum);
                this.setColor(this.buyBtn);
                this.buyBtn.touchChildren = false;
                this.buyBtn.touchEnabled = false;
                this.setColor(this.costcoin);
            }
        } else if (data.status == 3 || data.status == 4) {
            this.buyBtn.touchChildren = false;
            this.buyBtn.touchEnabled = false;
            this.buyBtn.icon = "gsbuy_png";
            this.setColor(this.buyBtn);
            this.costcoin.visible = false;
            this.costnum.visible = false;
        }

        if (this.isGuide && this.scene.mainConfig.table.level == 0 && this.scene.guideStep < 2) {
            let finger = new eui.Image();
            finger.source = `finger_png`;
            finger.scaleX = 1;
            finger.scaleY = 1;
            finger.touchEnabled = false;
            finger.x = 385;
            // finger.y = 768;
            finger.verticalCenter = this.buyBtn.verticalCenter + 20;
            this.addChild(finger);
            egret.Tween.get(finger, { loop: true })
                .set({ scaleX: 1.5, scaleY: 1.5 })
                .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                .wait(330)
            this.closeBtn.visible = false;
        } else {
            this.closeBtn.visible = true;
            this.funcclose = this.onTap_close.bind(this, data.data, data.coin)
            this.onTap(this.closeBtn, this.funcclose);
        }

        this.gstip1.x = this.dianum.x + this.dianum.width + 20;
        this.gstip2.x = this.dianum.x + this.dianum.width + 20 + 15;
    }

    initEvents() {

    }

    onTap_close(data, coin) {
        this.hidePanel();
        let _data = { data: data, coin: coin, scene: this.scene }
        PanelCtrl.instance.slideUp(ModuleTypes.GUIDEBUY_PANEL, GameConst.stage.stageHeight * 2 / 5, _data);
    }
    //购买
    onTap_Buy(cost, coin, type, level) {
        let name = ""
        switch (type + "") {
            case "1":
                name = "table"
                break;
            case "2":
                name = "oven"
                break;
            case "3":
                name = "refrigerator"
                break;
            case "4":
                name = "coffeeMaker"
                break;
            case "5":
                name = "barCounter"
                break;
            case "6":
                name = "waitress"
                break;
        }
        if (cost > coin) {
            //toast
            //若用户金币不足，按钮置灰；金币充足可购买；
            ToastCtrl.instance.show("金币不足哦~")
        } else {
            //接口
            NetManager.ins.clickLog(this.buyBtnExposure);
            Waiting.instance.show();
            this.buyBtn.touchEnabled = false;
            weidianNet.upgrade(async (s) => {
                Waiting.instance.hide();
                if (!s) {
                    this.buyBtn.touchEnabled = true;
                    let code = DataManager.ins.getData("upgrade").code;
                    if (code == 100201 || code == 100202) {
                        ToastCtrl.instance.show(DataManager.ins.getData("upgrade").message);
                    } else {
                        ToastCtrl.instance.show("网络异常，请刷新重试~");
                    }
                    return
                }
                const { goldCoin, diamond, capacity, storeUpgrade, hasUpgradeReward, upgradeReward, storeLevel, chickenNewEnable, feeNewEnable, grabNewEnable, exchangeNewEnable } = DataManager.ins.getData("upgrade").data

                this.scene.mainConfig[name].capacity = capacity;
                this.scene.mainConfig.coin = goldCoin;
                this.scene.mainConfig.diamond = diamond;
                // if (this.isGuide) {
                GCache.writeCache("isGuided", 1);
                // }
                if (storeUpgrade) {
                    this.scene['levelTxt'].text = "Lv" + storeLevel + ""
                }
                await wait(500)
                await Ani.instance.awardDiamondAni(this)
                // this.scene.updateDiamond(DataManager.ins.getData("upgrade").data.diamond);

                this.hidePanel();
                this.scene.touchEnabled = false;
                this.scene.touchChildren = false;
                wait(1000).then(() => {
                    this.scene.updateCoin(DataManager.ins.getData("upgrade").data.goldCoin);
                    this.buyBtn.touchEnabled = true;
                    this.scene.touchEnabled = true;
                    this.scene.touchChildren = true;
                    this.scene.guideStep = 2;
                    GDispatcher.dispatchEvent("guideTest")
                    this.scene.openStore = false;
                    // if (grabNewEnable || chickenNewEnable || feeNewEnable || exchangeNewEnable) {
                    //     if (chickenNewEnable) {
                    //         let pumpdata = { storeLevel: storeLevel, chickenNewEnable: chickenNewEnable, scene: this.scene }
                    //         this.scene.updateAddSpeed(pumpdata);
                    //     }
                    //     if (exchangeNewEnable) {
                    //         let pumpdata = { storeLevel: storeLevel, exchangeNewEnable: exchangeNewEnable, scene: this.scene }
                    //         this.scene.updateExchange(pumpdata);
                    //     }
                    //     if (grabNewEnable) {
                    //         let pumpdata = { storeLevel: storeLevel, grabNewEnable: grabNewEnable, scene: this.scene }
                    //         this.scene.updateVie(pumpdata)
                    //     }
                    //     if (feeNewEnable) {
                    //         let pumpdata = { storeLevel: storeLevel, feeNewEnable: feeNewEnable, scene: this.scene }
                    //         this.scene.updateFee(pumpdata);
                    //     }
                    // }
                    if (storeUpgrade) {
                        // 有升级奖励
                        this.scene.updateDiamond(Number(DataManager.ins.getData("upgrade").data.diamond));
                        this.scene.updateLevel(storeLevel)
                        if(hasUpgradeReward){
                            let data = {
                                hasUpgradeReward: hasUpgradeReward,
                                upgradeReward: upgradeReward,
                                storeLevel: storeLevel,
                                scene: this.scene,
                                chickenNewEnable: chickenNewEnable,
                                exchangeNewEnable: exchangeNewEnable,
                                grabNewEnable: grabNewEnable,
                                feeNewEnable: feeNewEnable,
                                partnerUserId: this.uid
                            }
                            PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL, data)
                        }
                        
                    } else {
                        this.scene.updateDiamond(DataManager.ins.getData("upgrade").data.diamond);
                        this.hidePanel();
                    }
                })


                // 设备升级动画
                if (GCache.readCache("isPlayMusic") == "1") {
                    if (GameConst.isIOS()) {
                        console.log("url");
                        window['playMusic']("createEq", true, false)
                    } else {
                        playSound(SoundType.createEq)
                    }
                }
                await Ani.instance.upgradeAni(type, level, this.scene);

                // 1桌椅 2烤箱 3冰柜 4咖啡机 5收银台 6服务员
                if (type == "6") {
                    this.scene.mainConfig.waitress.level = level;
                    if (this.scene.mainConfig.chickenStatus == 2) {
                        this.scene.updateWaitressCapacity(1500);
                        this.scene.randomMove(8);
                    } else {
                        this.scene.updateWaitressCapacity();
                        this.scene.randomMove();
                    }
                } else {
                    this.scene.updateCapacity(name)
                }

            }, window['projectxId'], type, level);
        }
    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }

    onTap_gstip1() {
        this.gstip2.visible = true;
        setTimeout(() => {
            this.gstip2.visible = false;
        }, 2000);


    }
    onTap_gstip2() {
        this.gstip2.visible = false;

    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_close);
        this.clearTap(this.buyBtn, this.func);
        this.clearTap(this.gstip1, this.onTap_gstip1);
        //this.clearTap(this.tipclose,this.onTap_gstip2);
        this.tipclose.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_gstip2, this)
    }
}