import { wait } from './../GameConst';
import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import Panel from "../views/Panel";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import ToastCtrl from "../ctrls/toastCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';

export default class GuideNewPanel extends Panel {
    protected get skinKey() { return 'pop/GuideNew' }

    public closeBtn: eui.Button;
    public startBtn: eui.Button;
    public newlab: eui.Label;

    private scene: any;
    private addCoins: number;

    public startBtnExposure:any;

    constructor(data) {

        super();


        this.scene = data.scene;
        this.addCoins = data.data;
        this.newlab.text = "欢迎来到你的咖啡店！\n奖励开店资金" + GameConst.tranNumber(this.addCoins) + "，快去装修吧~"

        this.initAni();
        this.initBuired();
    }
    initBuired(){
        let startBtnDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let startBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.startBtnExposure = Buried.createExposure(startBtnDpmOut, startBtnDcmOut);
        NetManager.ins.showLog(this.startBtnExposure);
        
    }

    async initAni() {
        await wait(500)
        await Ani.instance.awardCoinAni(this);
        this.scene.updateCoin(Number(this.scene.mainConfig.coin) + Number(this.addCoins))
        this.scene.mainConfig.coin = Number(this.scene.mainConfig.coin) + Number(this.addCoins);
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.startBtn, this.onTap_closeBtn);
        this.onTap(this.closeBtn, this.onTap_closeBtn);

    }
    onTap_closeBtn() {
        NetManager.ins.clickLog(this.startBtnExposure);
        this.hidePanel();
        // 派发事件  检测是否进行引导
        GDispatcher.dispatchEvent("guideTest");
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.startBtn, this.onTap_closeBtn);
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    }



}