import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import Panel from "../views/Panel";
import { GCache } from "../../libs/tc/util/GCache";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import GameConst from "../GameConst";
import Waiting from "../waiting/Waiting";

export default class GuideBuyPanel extends Panel {
    protected get skinKey() { return "pop/GuideBuy" }

    public goodsList: eui.Scroller;
    public goodGroup: eui.Group;
    public desk1Group: eui.Group;
    public desk2Group: eui.Group;
    public desk3Group: eui.Group;
    public coffee1Group: eui.Group;
    public coffee2Group: eui.Group;
    public coffee3Group: eui.Group;
    public cash1Group: eui.Group;
    public cash2Group: eui.Group;
    public cash3Group: eui.Group;
    public oven1Group: eui.Group;
    public oven2Group: eui.Group;
    public oven3Group: eui.Group;
    public frige1Group: eui.Group;
    public frige2Group: eui.Group;
    public frige3Group: eui.Group;
    public wait1Group: eui.Group;
    public wait2Group: eui.Group;
    public wait3Group: eui.Group;

    public desk1right: eui.Image;
    public desk2right: eui.Image;
    public desk3right: eui.Image;
    public coffee1right: eui.Image;
    public coffee2right: eui.Image;
    public coffee3right: eui.Image;
    public cash1right: eui.Image;
    public cash2right: eui.Image;
    public cash3right: eui.Image;
    public oven1right: eui.Image;
    public oven2right: eui.Image;
    public oven3right: eui.Image;
    public frige1right: eui.Image;
    public frige2right: eui.Image;
    public frige3right: eui.Image;
    public wait1right: eui.Image;
    public wait2right: eui.Image;
    public wait3right: eui.Image;

    public deskcoin1: eui.Label;
    public deskcoin2: eui.Label;
    public deskcoin3: eui.Label;
    public coffeecoin1: eui.Label;
    public coffeecoin2: eui.Label;
    public coffeecoin3: eui.Label;
    public cashcoin1: eui.Label;
    public cashcoin2: eui.Label;
    public cashcoin3: eui.Label;
    public ovencoin1: eui.Label;
    public ovencoin2: eui.Label;
    public ovencoin3: eui.Label;
    public frigecoin1: eui.Label;
    public frigecoin2: eui.Label;
    public frigecoin3: eui.Label;
    public waitcoin1: eui.Label;
    public waitcoin2: eui.Label;
    public waitcoin3: eui.Label;



    public closeBtn: eui.Button;


    private func1: any;
    private func2: any;
    private func3: any;
    private func4: any;
    private func5: any;
    private func6: any;
    private func7: any;
    private func8: any;
    private func9: any;
    private func10: any;
    private func11: any;
    private func12: any;
    private func13: any;
    private func14: any;
    private func15: any;
    private func16: any;
    private func17: any;
    private func18: any;
    private scene: any;

    private uid: any;
    private isGuide: boolean = false;

    public coinnum: number = 0;
    constructor(data) {
        super();
        let _data = data.data;
        this.coinnum = data.coin;
        this.uid = data.partnerUserId;
        this.scene = data.scene;
        this.isGuide = data.isGuide;
        this.bindData(_data);
        this.initUI(_data);
    }

    initUI(data) {

        this.goodsList.height = GameConst.stage.stageHeight * 3 / 5;

        this.desk1right.visible = false;
        this.desk2right.visible = false;
        this.desk3right.visible = false;
        this.coffee1right.visible = false;
        this.coffee2right.visible = false;
        this.coffee3right.visible = false;
        this.cash1right.visible = false;
        this.cash2right.visible = false;
        this.cash3right.visible = false;
        this.oven1right.visible = false;
        this.oven2right.visible = false;
        this.oven3right.visible = false;
        this.frige1right.visible = false;
        this.frige2right.visible = false;
        this.frige3right.visible = false;
        this.wait1right.visible = false;
        this.wait2right.visible = false;
        this.wait3right.visible = false;

        //是否第一次进游戏
        // if (this.isGuide) {

        // } else {

        if (data.tableList) {
            for (let i = 0; i < 3; i++) {
                if (data.tableList[i].status == 2) {
                    this.setColor(this["desk" + data.tableList[i].level + "Group"]);
                    this.clearTap(this["desk" + data.tableList[i].level + "Group"], this["func" + (i + 1)]);
                }
                if (data.tableList[i].status == 3) {
                    this["desk" + data.tableList[i].level + "right"].source = "buyed_png";
                    this["desk" + data.tableList[i].level + "right"].visible = true;
                }
                if (data.tableList[i].status == 4) {
                    this["desk" + data.tableList[i].level + "right"].source = "popright_png";
                    this["desk" + data.tableList[i].level + "right"].visible = true;
                    // this.clearTap(this["desk" + data.tableList[i].level + "Group"], this["func" + (i + 1)]);
                }
                this["deskcoin" + (i + 1)].text = GameConst.tranNumber(data.tableList[i].needGoldCoin);
                this["deskcoin" + (i + 1)].size = 30;
                this["deskcoin" + (i + 1)].y = 210;
            }
        }
        if (data.ovenList) {
            for (let i = 0; i < 3; i++) {
                if (data.ovenList[i].status == 2) {
                    this.setColor(this["oven" + data.ovenList[i].level + "Group"]);
                    this.clearTap(this["oven" + data.ovenList[i].level + "Group"], this["func" + (i + 10)]);
                }
                if (data.ovenList[i].status == 3) {
                    this["oven" + data.ovenList[i].level + "right"].source = "buyed_png";
                    this["oven" + data.ovenList[i].level + "right"].visible = true;
                }
                if (data.ovenList[i].status == 4) {
                    this["oven" + data.ovenList[i].level + "right"].source = "popright_png";
                    this["oven" + data.ovenList[i].level + "right"].visible = true;
                    // this.clearTap(this["oven" + data.ovenList[i].level + "Group"], this["func" + (i + 10)]);
                }
                this["ovencoin" + (i + 1)].text = GameConst.tranNumber(data.ovenList[i].needGoldCoin);
                this["ovencoin" + (i + 1)].size = 30;
                this["ovencoin" + (i + 1)].y = 210;
            }
        }
        if (data.freezerList) {
            for (let i = 0; i < 3; i++) {
                if (data.freezerList[i].status == 2) {
                    this.setColor(this["frige" + data.freezerList[i].level + "Group"]);
                    this.clearTap(this["frige" + data.freezerList[i].level + "Group"], this["func" + (i + 13)]);
                }
                if (data.freezerList[i].status == 3) {
                    this["frige" + data.freezerList[i].level + "right"].source = "buyed_png";
                    this["frige" + data.freezerList[i].level + "right"].visible = true;
                }
                if (data.freezerList[i].status == 4) {
                    this["frige" + data.freezerList[i].level + "right"].source = "popright_png";
                    this["frige" + data.freezerList[i].level + "right"].visible = true;
                    // this.clearTap(this["frige" + data.ovenList[i].level + "Group"], this["func" + (i + 13)]);
                }
                this["frigecoin" + (i + 1)].text = GameConst.tranNumber(data.freezerList[i].needGoldCoin);
                this["frigecoin" + (i + 1)].size = 30;
                this["frigecoin" + (i + 1)].y = 210;
            }
        }
        if (data.coffeeMakerList) {
            for (let i = 0; i < 3; i++) {
                if (data.coffeeMakerList[i].status == 2) {
                    this.setColor(this["coffee" + data.coffeeMakerList[i].level + "Group"]);
                    this.clearTap(this["coffee" + data.coffeeMakerList[i].level + "Group"], this["func" + (i + 4)]);
                }
                if (data.coffeeMakerList[i].status == 3) {
                    this["coffee" + data.coffeeMakerList[i].level + "right"].source = "buyed_png";
                    this["coffee" + data.coffeeMakerList[i].level + "right"].visible = true;
                }
                if (data.coffeeMakerList[i].status == 4) {
                    this["coffee" + data.coffeeMakerList[i].level + "right"].source = "popright_png";
                    this["coffee" + data.coffeeMakerList[i].level + "right"].visible = true;
                }
                this["coffeecoin" + (i + 1)].text = GameConst.tranNumber(data.coffeeMakerList[i].needGoldCoin);
                this["coffeecoin" + (i + 1)].size = 30;
                this["coffeecoin" + (i + 1)].y = 210;
            }
        }
        if (data.checkstandList) {
            for (let i = 0; i < 3; i++) {
                if (data.checkstandList[i].status == 2) {
                    this.setColor(this["cash" + data.checkstandList[i].level + "Group"]);
                    this.clearTap(this["cash" + data.checkstandList[i].level + "Group"], this["func" + (i + 7)]);
                }
                if (data.checkstandList[i].status == 3) {
                    this["cash" + data.checkstandList[i].level + "right"].source = "buyed_png";
                    this["cash" + data.checkstandList[i].level + "right"].visible = true;
                }
                if (data.checkstandList[i].status == 4) {
                    this["cash" + data.checkstandList[i].level + "right"].source = "popright_png";
                    this["cash" + data.checkstandList[i].level + "right"].visible = true;
                }
                this["cashcoin" + (i + 1)].text = GameConst.tranNumber(data.checkstandList[i].needGoldCoin);
                this["cashcoin" + (i + 1)].size = 30;
                this["cashcoin" + (i + 1)].y = 210;
            }
        }
        if (data.waiterList) {
            for (let i = 0; i < 3; i++) {
                if (data.waiterList[i].status == 2) {
                    this.setColor(this["wait" + data.waiterList[i].level + "Group"]);
                    this.clearTap(this["wait" + data.waiterList[i].level + "Group"], this["func" + (i + 16)]);
                }
                if (data.waiterList[i].status == 3) {
                    this["wait" + data.waiterList[i].level + "right"].source = "buyed_png";
                    this["wait" + data.waiterList[i].level + "right"].visible = true;
                }
                if (data.waiterList[i].status == 4) {
                    this["wait" + data.waiterList[i].level + "right"].source = "popright_png";
                    this["wait" + data.waiterList[i].level + "right"].visible = true;
                }
                this["waitcoin" + (i + 1)].text = GameConst.tranNumber(data.waiterList[i].needGoldCoin);
                this["waitcoin" + (i + 1)].size = 30;
                this["waitcoin" + (i + 1)].y = 210;
            }
        }


        // }


    }

    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    onTapGet() {

        this.onTap(this.desk1Group, this.func1);
        if (this.isGuide && this.scene.mainConfig.table.level == 0 && this.scene.guideStep < 2) {

            let finger = new eui.Image();
            finger.source = `finger_png`;
            finger.scaleX = 1;
            finger.scaleY = 1;
            finger.touchEnabled = false;
            finger.x = 145;
            finger.y = 577;
            this.addChild(finger);
            egret.Tween.get(finger, { loop: true })
                .set({ scaleX: 1.5, scaleY: 1.5 })
                .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                .wait(330)
            this.goodsList.scrollPolicyH = "off";
            this.goodsList.scrollPolicyV = "off";
            this.closeBtn.visible = false;
            return
        } else {
            this.closeBtn.visible = true;
        }
        this.onTap(this.closeBtn, this.onTap_closeBtn);

        this.onTap(this.desk1Group, this.func1);
        this.onTap(this.desk2Group, this.func2);
        this.onTap(this.desk3Group, this.func3);

        this.onTap(this.coffee1Group, this.func4);
        this.onTap(this.coffee2Group, this.func5);
        this.onTap(this.coffee3Group, this.func6);

        this.onTap(this.cash1Group, this.func7);
        this.onTap(this.cash2Group, this.func8);
        this.onTap(this.cash3Group, this.func9);

        this.onTap(this.oven1Group, this.func10);
        this.onTap(this.oven2Group, this.func11);
        this.onTap(this.oven3Group, this.func12);

        this.onTap(this.frige1Group, this.func13);
        this.onTap(this.frige2Group, this.func14);
        this.onTap(this.frige3Group, this.func15);

        this.onTap(this.wait1Group, this.func16);
        this.onTap(this.wait2Group, this.func17);
        this.onTap(this.wait3Group, this.func18);
    }

    initEvents() {

    }
    bindData(data) {
        if (data) {                   //type,num,cost,coin,capacity,rewardDiamond
            this.func1 = this.onTap_Message.bind(this, data, data.tableList[0].type, 1, data.tableList[0].needGoldCoin, this.coinnum, data.tableList[0].capacity, data.tableList[0].rewardDiamond, data.tableList[0].status);
            this.func2 = this.onTap_Message.bind(this, data, data.tableList[1].type, 2, data.tableList[1].needGoldCoin, this.coinnum, data.tableList[1].capacity, data.tableList[1].rewardDiamond, data.tableList[1].status);
            this.func3 = this.onTap_Message.bind(this, data, data.tableList[2].type, 3, data.tableList[2].needGoldCoin, this.coinnum, data.tableList[2].capacity, data.tableList[2].rewardDiamond, data.tableList[2].status);
            this.func4 = this.onTap_Message.bind(this, data, data.coffeeMakerList[0].type, 1, data.coffeeMakerList[0].needGoldCoin, this.coinnum, data.coffeeMakerList[0].capacity, data.coffeeMakerList[0].rewardDiamond, data.coffeeMakerList[0].status);
            this.func5 = this.onTap_Message.bind(this, data, data.coffeeMakerList[1].type, 2, data.coffeeMakerList[1].needGoldCoin, this.coinnum, data.coffeeMakerList[1].capacity, data.coffeeMakerList[1].rewardDiamond, data.coffeeMakerList[1].status);
            this.func6 = this.onTap_Message.bind(this, data, data.coffeeMakerList[2].type, 3, data.coffeeMakerList[2].needGoldCoin, this.coinnum, data.coffeeMakerList[2].capacity, data.coffeeMakerList[2].rewardDiamond, data.coffeeMakerList[2].status);
            this.func7 = this.onTap_Message.bind(this, data, data.checkstandList[0].type, 1, data.checkstandList[0].needGoldCoin, this.coinnum, data.checkstandList[0].capacity, data.checkstandList[0].rewardDiamond, data.checkstandList[0].status);
            this.func8 = this.onTap_Message.bind(this, data, data.checkstandList[1].type, 2, data.checkstandList[1].needGoldCoin, this.coinnum, data.checkstandList[1].capacity, data.checkstandList[1].rewardDiamond, data.checkstandList[1].status);
            this.func9 = this.onTap_Message.bind(this, data, data.checkstandList[2].type, 3, data.checkstandList[2].needGoldCoin, this.coinnum, data.checkstandList[2].capacity, data.checkstandList[2].rewardDiamond, data.checkstandList[2].status);
            this.func10 = this.onTap_Message.bind(this, data, data.ovenList[0].type, 1, data.ovenList[0].needGoldCoin, this.coinnum, data.ovenList[0].capacity, data.ovenList[0].rewardDiamond, data.ovenList[0].status);
            this.func11 = this.onTap_Message.bind(this, data, data.ovenList[1].type, 2, data.ovenList[1].needGoldCoin, this.coinnum, data.ovenList[1].capacity, data.ovenList[1].rewardDiamond, data.ovenList[1].status);
            this.func12 = this.onTap_Message.bind(this, data, data.ovenList[2].type, 3, data.ovenList[2].needGoldCoin, this.coinnum, data.ovenList[2].capacity, data.ovenList[2].rewardDiamond, data.ovenList[2].status);
            this.func13 = this.onTap_Message.bind(this, data, data.freezerList[0].type, 1, data.freezerList[0].needGoldCoin, this.coinnum, data.freezerList[0].capacity, data.freezerList[0].rewardDiamond, data.freezerList[0].status);
            this.func14 = this.onTap_Message.bind(this, data, data.freezerList[1].type, 2, data.freezerList[1].needGoldCoin, this.coinnum, data.freezerList[1].capacity, data.freezerList[1].rewardDiamond, data.freezerList[1].status);
            this.func15 = this.onTap_Message.bind(this, data, data.freezerList[2].type, 3, data.freezerList[2].needGoldCoin, this.coinnum, data.freezerList[2].capacity, data.freezerList[2].rewardDiamond, data.freezerList[2].status);
            this.func16 = this.onTap_Message.bind(this, data, data.waiterList[0].type, 1, data.waiterList[0].needGoldCoin, this.coinnum, data.waiterList[0].capacity, data.waiterList[0].rewardDiamond, data.waiterList[0].status);
            this.func17 = this.onTap_Message.bind(this, data, data.waiterList[1].type, 2, data.waiterList[1].needGoldCoin, this.coinnum, data.waiterList[1].capacity, data.waiterList[1].rewardDiamond, data.waiterList[1].status);
            this.func18 = this.onTap_Message.bind(this, data, data.waiterList[2].type, 3, data.waiterList[2].needGoldCoin, this.coinnum, data.waiterList[2].capacity, data.waiterList[2].rewardDiamond, data.waiterList[2].status);
            this.onTapGet();

        }
    }

    onTap_Message(data, type, num, cost, coin, capacity, rewardDiamond, status) {
        //this.hidePanel();
        this.scene.guideStep = 1;
        GDispatcher.dispatchEvent("guideTest")
        // if (status == 1) {
        let _data = { data: data, type: type, level: num, cost: cost, coin: coin, capacity: capacity, rewardDiamond: rewardDiamond, status: status, scene: this.scene, isGuide: this.isGuide, partnerUserId: this.uid };
        PanelCtrl.instance.show(ModuleTypes.GUIDESURE_PANEL, _data);
        // }
    }

    onTap_closeBtn() {
        Waiting.instance.show();
        weidianNet.index((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.scene.updateData();
            this.slideDown()

        }, window['projectxId'])
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.desk1Group, this.func1);
        this.clearTap(this.desk2Group, this.func2);
        this.clearTap(this.desk3Group, this.func3);

        this.clearTap(this.coffee1Group, this.func4);
        this.clearTap(this.coffee2Group, this.func5);
        this.clearTap(this.coffee3Group, this.func6);

        this.clearTap(this.cash1Group, this.func7);
        this.clearTap(this.cash2Group, this.func8);
        this.clearTap(this.cash3Group, this.func9);

        this.clearTap(this.oven1Group, this.func10);
        this.clearTap(this.oven2Group, this.func11);
        this.clearTap(this.oven3Group, this.func12);

        this.clearTap(this.frige1Group, this.func13);
        this.clearTap(this.frige2Group, this.func14);
        this.clearTap(this.frige3Group, this.func15);

        this.clearTap(this.wait1Group, this.func16);
        this.clearTap(this.wait2Group, this.func17);
        this.clearTap(this.wait3Group, this.func18);

        this.clearTap(this.closeBtn, this.onTap_closeBtn);
    }
}