import { DataManager } from './../../libs/tw/manager/DataManager';
import { weidianNet } from './../NetConst';
import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class GiftSuccessPanel extends Panel {
    protected get skinKey() { return 'pop/GiftSuccess' }
    public gsMercImg: eui.Image;
    public gsname: eui.Label;
    public buyBtn: eui.Button;
    public closeBtn: eui.Button;
    private func: any;
    private diamond: any;
    private scene: any;
    private itemId: any;
    private url: any;
    private id:any;
    private refId:any;
    public buyBtnExposure:any;

    constructor(data) {
        super();
        this.url = data.url;
        this.id = data.data.preid;
        this.refId = data.data.prerefId
        this.initUI(data);
        this.initBuired();
    }

    initBuired(){
        let buyBtnDpmOut = Buried.connectDpm(110, 22, 1); // 点击埋点   
        let buyBtnDcmOut = Buried.connectDcm(202, this.refId, this.id); // 曝光埋点
        this.buyBtnExposure = Buried.createExposure(buyBtnDpmOut, buyBtnDcmOut);
        NetManager.ins.showLog(this.buyBtnExposure);
        

    }
    initUI(data) {
        // { predia: data.predia, 
        //     preid: data.preid, 
        //     preicon: data.preicon, 
        //     prename: data.prename, 
        //     diamond: this.diamond, 
        //     scene: this.scene }
        // data: data, 
        // data2: DataManager.ins.getData("exchange").data, 
        // diamond: DataManager.ins.getData("exchange").data.nowDiamonds, 
        // url: DataManager.ins.getData("exchange").data.url,
        //  scene: this.scene
        //let dataitem = {predia:,preflag:,preid:,preurl:};
        this.gsMercImg.source = data.data.preicon;
        this.gsname.text = data.data.prename;
        this.itemId = data.data.preid;
        this.scene = data.scene;
        this.diamond = data.diamond;
        this.onTap(this.buyBtn, this.onTap_buyBtn)
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
    }

    onTap_closeBtn() {
        Waiting.instance.show();
        weidianNet.exchangeList((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络异常，请刷新重试~");
                this.hidePanel();
                return
            }
            weidianNet.getPrize((ss) => {
                if (!ss) {
                    ToastCtrl.instance.show("网络异常，请刷新重试~")
                    this.hidePanel();
                    return
                }
                let data = { data: DataManager.ins.getData("exchangeList").data, data2: DataManager.ins.getData("getPrize").data, diamond: this.diamond, scene: this.scene }
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE, data);
                this.hidePanel();
            }, window["projectxId"])
        }, window['projectxId'])
    }
    onTap_buyBtn() {
        //接口
        // Waiting.instance.show()
        // weidianNet.getJumpUrl((s) => {
        //     Waiting.instance.hide();
        //     if (!s) {
        //         ToastCtrl.instance.show("获取链接失败~");
        //         return
        //     }
        NetManager.ins.clickLog(this.buyBtnExposure);
        window.location.href = "weidianbuyer://wdb/webview?url=" + encodeURIComponent(this.url);
        // }, this.itemId, window['projectxId'])

    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.buyBtn, this.onTap_buyBtn);
    }
}