import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import GameConst from "../GameConst";
import SceneCtrl from "../ctrls/sceneCtrl";
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class FoodReadyPanel extends Panel {
    protected get skinKey() { return 'pop/FoodReady' }

    public frBtn: eui.Button;
    public closeBtn: eui.Button;
    public costLab: eui.Label;

    private func: any;
    private funcclose: any;
    private cost: any = 0;

    public frBtnExposure:any;
    
    constructor(data) {
        super();
        // let _data = data//.data;
        this.initUI(data);
        this.initBuired();
    }
    initBuired(){
        let frBtnDpmOut = Buried.connectDpm(110, 35, 1); // 点击埋点   
        let frBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.frBtnExposure = Buried.createExposure(frBtnDpmOut, frBtnDcmOut);
        NetManager.ins.showLog(this.frBtnExposure);
        
    }

    initUI(data) {
        this.cost = GameConst.tranNumber(data.data.needGold);
        this.costLab.text = "当前参与需要消耗" + this.cost + "金币";
        let tapdata = { cost: data.data.needGold, coin: data.data.storeGoldCoin, scene: data.scene }
        this.func = this.onTap_frBtn.bind(this, tapdata);
        this.onTap(this.frBtn, this.func);
        if (data.data.needGold <= data.data.storeGoldCoin) {

        } else {
            this.setColor(this.frBtn);
        }
        this.funcclose = this.onTap_closeBtn.bind(this, data.scene);
        this.onTap(this.closeBtn, this.funcclose);
    }

    initEvents() {
        super.initEvents();
    }


    onTap_frBtn(data) {
        // this.hidePanel();
        if (data.cost <= data.coin) {
            NetManager.ins.clickLog(this.frBtnExposure);
            Waiting.instance.show()
            weidianNet.getVie((s) => {
                Waiting.instance.hide();
                if (!s) {
                    let code = DataManager.ins.getData("getVie").code;
                if (code == 100401 || code == 100402 || code == 100403) {
                    ToastCtrl.instance.show(DataManager.ins.getData("getVie").message);
                } else {
                    ToastCtrl.instance.show("网络异常，请刷新重试~");
                }
                    return
                }
                SceneCtrl.instance["_currentScene"]["mainConfig"]["coin"] = DataManager.ins.getData("getVie").data.storeGoldCoin;
                SceneCtrl.instance["_currentScene"]["coinNum"]["coinNumTxt"].text = GameConst.tranNumber(DataManager.ins.getData("getVie").data.storeGoldCoin);
                PanelCtrl.instance.show(ModuleTypes.FOODGO_PANEL, data);
            }, window['projectxId'])
        } else {
            ToastCtrl.instance.show("金币不足，继续赚取更多金币吧~");
        }
    }
    onTap_closeBtn(scene) {
        weidianNet.index((s) => {
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            scene.updateData();
            this.hidePanel()
        }, window['projectxId'])
    }

    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.frBtn, this.func);
        this.clearTap(this.closeBtn, this.funcclose);
    }

}