import { weidianNet } from './../NetConst';
import Panel from "../views/Panel";
import ToastCtrl from "../ctrls/toastCtrl";
import SVGACtrl from "../ctrls/svgaCtrl";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import Waiting from "../waiting/Waiting";
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class FoodGoPanel extends Panel {
    protected get skinKey() { return 'pop/FoodGo' }
    public counttime: eui.Label;
    public getnum: eui.Label;
    public fgBtn: eui.Button;
    public closeBtn: eui.Button;
    public costLab: eui.Label

    public datacoin: number = 0;
    public datacost: number = 0;
    public clicks: number = 0;
    private nowtime: number = 0;

    private funcFrame: any;
    private scene: any;

    public fgBtnExposure:any;

    constructor(data) {
        super();
        this.initUI(data);
        this.initBuired();
    }

    initBuired(){
        let fgBtnDpmOut = Buried.connectDpm(110, 34, 1); // 点击埋点   
        let fgBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.fgBtnExposure = Buried.createExposure(fgBtnDpmOut, fgBtnDcmOut);
        NetManager.ins.showLog(this.fgBtnExposure);
        
    }

    initUI(data) {

        this.datacoin = data.coin;
        this.datacost = data.cost;
        this.counttime.text = "00:10:00"
        this.nowtime = new Date().getTime() + 10000;
        this.costLab.text = "每抢到一单，消耗" + this.datacost + "金币";

        this.onTap(this.fgBtn, this.onTap_fgBtn);
        this.funcFrame = this.onEnterFrame.bind(this, data.scene);
        this.addEventListener(egret.Event.ENTER_FRAME, this.funcFrame, this);

        this.scene = data.scene;

    }
    initEvents() {
        super.initEvents();


    }
    public setColor(group) {
        let colorMatrix = [
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0.3, 0.3, 0.3, 0, 0,
            0, 0, 0, 1, 0
        ];
        let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

        group.filters = [colorFilter];

    }
    private isSend: boolean = false;
    onEnterFrame(scene) {

        //倒计时
        let now: number = new Date().getTime();
        let second: any = Math.floor((this.nowtime - now) / 1000);
        let millisecond: any = (this.nowtime - now) % 1000;
        let milli1: any = Math.floor(millisecond / 100);
        let milli2: any = Math.floor((millisecond - milli1 * 100) / 10)
        let milli3: any = (millisecond - milli1 * 100 - milli2 * 10)

        if (milli3 > 5) {
            milli2 += 1;
            if (milli2 == 10) {
                milli1 += 1;
                milli2 = 0;
                if (milli1 == 10) {
                    milli1 = 0;
                    second += 1;
                }
            }
        }

        this.counttime.text = "00:0" + second + ":" + milli1 + milli2;
        if (now >= this.nowtime) {
            this.counttime.text = "00:00:00"
            if (!this.isSend) {
                this.isSend = true;
                weidianNet.postVie(async (s) => {
                    if (!s) {
                        ToastCtrl.instance.show("网络异常，请刷新重试~");
                        weidianNet.index((ss) => {
                            if (ss) {
                                this.scene.updateData();
                                this.scene.updateVie();
                            }

                            this.hidePanel();
                        })
                        return
                    }
                    this.clearTap(this.fgBtn, this.onTap_fgBtn);
                    this.hidePanel()
                    //data:DataManager.ins.getData("postVie").data,
                    let data = { coins: this.datacoin, data: DataManager.ins.getData("postVie").data, clicks: this.clicks, scene: scene };
                    PanelCtrl.instance.show(ModuleTypes.FOODEND_PANEL, data);
                }, this.clicks, window['projectxId'])

            }
        }
    }

    onTap_fgBtn() {
        if(this.clicks == 0){
            NetManager.ins.clickLog(this.fgBtnExposure);
        }
        
        let add = new eui.Image();
        add.source = "add_png";
        add.width = 124;
        add.height = 88;
        add.anchorOffsetX = 62;
        add.anchorOffsetY = 44;
        this.addChild(add);
        // 位置：0s(原位)-0.67s(上移150px)；
        // 旋转：0s(逆时针45度)-0.33s(0度)；
        // 透明度：0s(0%)-0.1s(100%)-0.57s(100%)-0.67s(0%);
        egret.Tween.get(add)
            .set({ x: 375, y: this.fgBtn.y-this.fgBtn.height/2-10, rotation: -45, alpha:0 })
            .to({ y: this.fgBtn.y-this.fgBtn.height/2-33, rotation: -41,alpha:1}, 100)
            .to({ y: this.fgBtn.y-this.fgBtn.height/2-84, rotation: 0},230)
            .to({ y: this.fgBtn.y-this.fgBtn.height/2-138 },240)
            .to({ y: this.fgBtn.y-this.fgBtn.height/2-150, alpha: 0 },100)

        this.clicks += 1;

    }

    onTap_closeBtn() {
        this.hidePanel();
    }
    removeEvents() {
        super.removeEvents()
        this.removeEventListener(egret.Event.ENTER_FRAME, this.funcFrame, this);
    }
}