import { wait } from './../GameConst';
import Panel from "../views/Panel";
import { weidianNet } from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import Waiting from "../waiting/Waiting";
import GameConst from "../GameConst";
import Ani from "../mainScene/Ani";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class FoodEndPanel extends Panel {
    protected get skinKey() { return 'pop/FoodEnd' }
    public getnum: eui.Label;
    public closeBtn: eui.Button;
    public foodendBtn: eui.Button;
    public popdia: eui.Image;
    private funcclose: any;
    private diamond: number;
    private scene: any;

    public foodendBtnExposure: any;

    constructor(data) {
        super();
        this.scene = data.scene;
        this.initUI(data);
        this.initBuired();
    }
    initBuired() {
        let foodendBtnDpmOut = Buried.connectDpm(110, 36, 1); // 点击埋点   
        let foodendBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.foodendBtnExposure = Buried.createExposure(foodendBtnDpmOut, foodendBtnDcmOut);
        NetManager.ins.showLog(this.foodendBtnExposure);

    }
    async initUI(data) {
        this.getnum.text = "共抢到" + data.clicks + "个外卖订单！\n共收获" + data.data.getDiamond + "个     ！\n";  //data.data.getDiamond

        this.diamond = data.data.storeDiamond;
        if (data.data.getDiamond > 10) {
            this.popdia.x = 425;

        } else {
            this.popdia.x = 417;
        }
        if (data.data.getDiamond > 0) {
            await wait(800)
            await Ani.instance.awardDiamondAni(this);
            this.scene.updateDiamond(this.diamond);
        }
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.foodendBtn, this.onTap_closeBtn);
        this.onTap(this.closeBtn, this.onTap_closeBtn);
    }

    onTap_closeBtn() {
        NetManager.ins.clickLog(this.foodendBtnExposure);
        Waiting.instance.show();
        weidianNet.index(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新数据失败，请重试~")
                return
            }
            this.hidePanel()
            this.scene.updateData();
            this.scene.updateVie();
        }, window['projectxId'])
    }


    removeEvents() {
        super.removeEvents();
        this.clearTap(this.foodendBtn, this.funcclose);
        this.clearTap(this.closeBtn, this.funcclose);
    }
}