import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import ToastCtrl from "../ctrls/toastCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { weidianNet } from "../NetConst";
import Waiting from "../waiting/Waiting";
import GameConst from '../GameConst';
import GiftScene from '../Gift/GiftScene';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class ConvertPanel extends Panel {
    protected get skinKey() { return 'pop/Convert' }

    public closeBtn: eui.Button;
    public changeLab: eui.Label;
    public prizeimg: eui.Image;
    public prizeLab: eui.Label;
    public thinkBtn: eui.Button;
    public sureBtn: eui.Button;

    private diamond: any;
    private scene: any;
    public func: any;
    private url: any;
    private id: any;
    private refId:any;

    public sureBtnExposure:any;
    constructor(data) {
        super();
        //let _data = data.data;
        this.diamond = data.diamond;
        this.scene = data.scene;
        this.url = data.url;
        this.id = data.preid;
        this.refId = data.prerefId;
        this.initUI(data)
        this.initBuired();
    }
    initBuired(){
        let sureBtnDpmOut = Buried.connectDpm(110, 21, 1); // 点击埋点   
        let sureBtnDcmOut = Buried.connectDcm(202, this.refId, this.id); // 曝光埋点
        this.sureBtnExposure = Buried.createExposure(sureBtnDpmOut, sureBtnDcmOut);
        NetManager.ins.showLog(this.sureBtnExposure);

    }
    initUI(data) {
        //let dataitem = {predia:,preflag:,preid:,preurl:};
        this.changeLab.text = data.predia + " 进行兑换吗？"
        this.prizeimg.source = data.preicon;
        this.prizeLab.text = data.prename;
        this.func = this.onTap_sureBtn.bind(this, data);
        this.onTap(this.sureBtn, this.func);
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.thinkBtn, this.onTap_closeBtn);


    }

    onTap_closeBtn() {
        this.hidePanel();
    }
    onTap_sureBtn(data) {
        //接口
        NetManager.ins.clickLog(this.sureBtnExposure);
        this.log(SceneCtrl.instance)
        Waiting.instance.show();
        weidianNet.exchange((s) => {
            Waiting.instance.hide();
            if (!s) {
                let code = DataManager.ins.getData("exchange").code;
                if (code == 100113 || code == 100114 || code == 100115 || code == 100201 || code == 999999) {
                    ToastCtrl.instance.show(DataManager.ins.getData("exchange").message);
                } else {
                    ToastCtrl.instance.show("网络异常，请刷新重试~");
                }
                return
            }
            // ToastCtrl.instance.show("兑换成功，可于我的兑换中查看详情")
            this.hidePanel();
            
            console.log(DataManager.ins.getData("exchange").data.nowDiamonds)
            GiftScene.instance.dianum.text = DataManager.ins.getData("exchange").data.nowDiamonds;
            let exchangedata = { data: data, data2: DataManager.ins.getData("exchange").data, diamond: DataManager.ins.getData("exchange").data.nowDiamonds, url: DataManager.ins.getData("exchange").data.url, scene: this.scene }
            PanelCtrl.instance.show(ModuleTypes.GIFTSUCCESS_PANEL, exchangedata);
        }, data.preid, window['projectxId']);

    }
    removeEvents() {
        super.removeEvents();
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.thinkBtn, this.onTap_closeBtn);
        this.clearTap(this.sureBtn, this.func);
    }
}