
import { GCache } from './../../libs/tc/util/GCache';
import { ModuleType } from './../../libs/tc/enum/ModuleType';
import { Buried } from './../../libs/tw/util/Buried';
import { NetManager } from './../../libs/tw/manager/NetManager';

import { GDispatcher } from './../../libs/tc/util/GDispatcher';
import { playBg } from './../ctrls/soundCtrl';
import { weidianNet } from './../NetConst';
import { wait } from './../GameConst';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Scene from "../views/Scene";
import Ani from "./Ani";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import GameConst from "../GameConst";
import SVGACtrl from '../ctrls/svgaCtrl';
import Waiting from '../waiting/Waiting';
import ToastCtrl from '../ctrls/toastCtrl';
import SceneCtrl from '../ctrls/sceneCtrl';
import AddSpeedBtn from './AddSpeed';
// import BuiredCtrl from '../ctrls/BuiredCtrl';
import Panel from '../views/Panel';
import { equipmentConfig } from './EquipmentConfig';


export default class MainScene extends Scene {

    public get skinKey() { return "Main" }
    public bg: eui.Image;
    public diamondNum: eui.Component;
    public coinNum: eui.Component;
    public nickName1: eui.Component;
    public barCounter: eui.Image;
    public refrigerator: eui.Image;
    public vase: eui.Image;
    public table0: eui.Image;
    public table1: eui.Image;
    public waitress0: eui.Group;
    public waitressCapacity: eui.Group;
    public waitressCapacityTxt: eui.Label;
    public waitress1: eui.Group;
    public table2: eui.Image;
    public table3: eui.Image;
    public coffeeMakerGroup: eui.Group;
    public coffeeMaker: eui.Image;
    public coffeeMakerCollectBtn: eui.Component;
    public ovenGroup: eui.Group;
    public oven: eui.Image;
    public ovenCollectBtn: eui.Component;
    public addSpeedTips: eui.Image;
    public barCounterCollectBtn: eui.Component;
    public refrigeratorCollectBtn: eui.Component;
    public tableCollectBtn: eui.Component;
    public decorateBtn: eui.Button;
    public redPacketBtn: eui.Button;
    public exchangeBtn: eui.Button;
    public taskBtn: eui.Button;
    public doVieBtn: eui.Button;
    public payBtn: eui.Button;
    public vieTips: eui.Group;
    public vieTipsBg: eui.Image;
    public vieCountDown: eui.Label;
    public waitress: eui.Image;
    public redPoint: eui.Image;
    public friendsScoller: eui.Scroller;
    public friendsGroup: eui.Group;
    public inviteBtn: eui.Image;
    public goBackBtn: eui.Rect;
    public guideGroup: eui.Group;
    public guide1: eui.Group;
    public guide2: eui.Group;
    public musicOn: eui.Image;
    public musicOff: eui.Image;

    //2.0
    public prizeImgGroup2:eui.Group;
    public changeGroup:eui.Group;
    public clickGoup2:eui.Group;
    public getPrizeBtn2:eui.Button;
    public prizeTipsLb2:eui.Label;
    public djxBtn:eui.Button;
    public addMoneyActLb:eui.Label;


    private addSpeedBtn: AddSpeedBtn;

    public waitress0Base: any;
    public waitress1Base: any;

    private mainConfig = {
        "feeBuff": 1,
        "waiterBuff": 1,
        "partnerUserId": "r22t2",
        "exchangeEnable": false,
        "exchangeNewEnable": false,
        "hasStore": true,
        "username": "",
        "avatar": "",
        "storeLevel": 0,
        "coin": 0,
        "diamond": 0,
        "storeUpgrade": false,
        "hasUpgradeReward": false,
        "upgradeReward": 0,
        "chickenStatus": 0,
        "chickenNewEnable": false,
        "chickenEndTime": 1569825488,
        "hasChickenTime": 0,
        "feeStatus": 0,
        "feeNewEnable": false,
        "feeNextPayTime": 1569080288,
        "grabStatus": 0,
        "grabNewEnable": false,
        "grabNextTime": 1570433437000,
        "waiterExtraGold": false,
        "table": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "barCounter": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "refrigerator": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "oven": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "coffeeMaker": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        },
        "waitress": {
            capacity: 0,
            store: 0,
            level: 0,
            type: 0
        }
    }

    constructor(data?) {
        super();
        this.percentHeight = 100;
        this.percentWidth = 100;


        if (data) {
            this.openStore = true;
            this.isGuide = true;
        } else {
            if (!GCache.readCache("isGuided") && this.mainConfig.table.level < 1) {
                this.isGuide = true;
            }
        }

    }


    updateUI() {
        if (GCache.readCache("isPlayMusic")) {
            if (GCache.readCache("isPlayMusic") == "1") {
                if (GameConst.isIOS()) {
                    GCache.writeCache("isPlayMusic", 0);
                    window['isPlayMusic'] = false;
                    this.musicOn.visible = false;
                    this.musicOff.visible = true;
                } else {
                    this.musicOn.visible = true;
                    this.musicOff.visible = false;

                    window['autoPlayMusic']();
                    window['audioAutoPlay']();

                    window['isPlayMusic'] = true;
                }

            } else {
                this.musicOn.visible = false;
                this.musicOff.visible = true;

                window['isPlayMusic'] = false;
            }
        } else {
            if (GameConst.isIOS()) {
                GCache.writeCache("isPlayMusic", "0")
                this.musicOn.visible = false;
                this.musicOff.visible = true;
                window['isPlayMusic'] = false;
            } else {
                GCache.writeCache("isPlayMusic", "1")
                this.musicOn.visible = true;
                this.musicOff.visible = false;

                window['autoPlayMusic']();
                window['audioAutoPlay']();
                window['isPlayMusic'] = true;
            }

        }


        const { unclaimed } = DataManager.ins.getData("getTaskInfo").data;

        const shopsList = DataManager.ins.getData("getShopsInfo") && DataManager.ins.getData("getShopsInfo").data && DataManager.ins.getData("getShopsInfo").data.shops ? DataManager.ins.getData("getShopsInfo").data.shops : [];
        const friendsList = DataManager.ins.getData("getFriendsInfo") && DataManager.ins.getData("getFriendsInfo").data ? DataManager.ins.getData("getFriendsInfo").data : [];

        if (window["resImg"]) {
            this.redPacketBtn.icon = window['resImg'];
            this.redPacketBtn.width = 100;
            this.redPacketBtn.height = 100;
            this.onTap(this.redPacketBtn, () => {
                NetManager.ins.clickLog(this.redPocketBtnExposure);
                let url = window["resUrl"];
                window.location.href = "weidianbuyer://wdb/webview?url=" + encodeURIComponent(url);
            })
        } else {
            this.redPacketBtn.visible = false;
        }

        if (this.mainConfig.avatar) {
            this['avatar'].source = this.mainConfig.avatar;
        }

        this['avatar'].mask = this['avatarMask'];

        let i = 0;
        if (shopsList && shopsList.length > 0) {
            shopsList.forEach((shopItem, idx) => {
                let shop = new eui.Component();
                shop.skinName = "FriendItemSkin"
                shop.x = i * 120;
                shop.y = 5;
                if (shopItem.shopLogo && shopItem.shopLogo !== "") {
                    shop['avatar'].source = decodeURIComponent(shopItem.shopLogo);
                }
                shop['avatar'].mask = shop['avatarMask'];
                shop['nameTxt'].text = this.fixName(shopItem.shopName, 4, "shop");
                shop['shopId'] = shopItem.shopId;
                shop['idx'] = idx;
                this.friendsGroup.addChild(shop);
                this.onTap(shop, this.onTap_shop);
                // 店铺埋点
                let shopDpm = Buried.connectDpm(110, 10, idx); // 点击埋点   
                let shopDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let shopExposure = Buried.createExposure(shopDpm, shopDcm);
                NetManager.ins.showLog(shopExposure);
                i++;
            });

        }

        if (friendsList && friendsList.length > 0) {
            friendsList.forEach(friendItem => {
                let friend = new eui.Component();
                friend.skinName = "FriendItemSkin"
                friend.x = i * 120;
                friend.y = 5;
                if (friendItem.avatar && friendItem.avatar !== "") {
                    friend['avatar'].source = decodeURIComponent(friendItem.avatar);
                }
                friend['avatar'].mask = friend['avatarMask'];
                friend['nameTxt'].text = this.fixName(friendItem.nickname, 4, "friend");

                friend['friendUserId'] = friendItem.friendUserId;
                this.friendsGroup.addChild(friend);
                this.onTap(friend, this.onTap_friend);
                i++;
            });
        }
        this.inviteBtn.x = i * 120;

        // 红点
        if (unclaimed) {
            this.redPoint.visible = true;
        } else {
            this.redPoint.visible = false;
        }



        if (this.mainConfig.username) {
            this['usernametxt'].text = this.fixName(this.mainConfig.username) + "的咖啡店";
        } else {
            this['usernametxt'].text = "我的咖啡店";
        }
        if (this.mainConfig.storeLevel) {
            this.updateLevel(this.mainConfig.storeLevel);
        } else {
            this.updateLevel(1);
        }

        this.coinNum['coinNumTxt'].text = GameConst.tranNumber(this.mainConfig.coin, 1);
        let zuanshi = GameConst.tranNumber(this.mainConfig.diamond, 1);
        let zuanshiNum = this.mainConfig.diamond;
        this.diamondNum['diamondNumTxt'].text = zuanshi;
        
        let data = DataManager.ins.getData("exchangeList").data;
        if(zuanshiNum >= data[0].diamond){
            this.diamondNum['progress'].value = 100;
        }else{
            if(Number(zuanshiNum) > data[0].diamond * 0.3){
                this.diamondNum['progress'].value = 50 + 50 * (Number(zuanshiNum) - data[0].diamond * 0.3) / (data[0].diamond * 0.7);
            }else{
                console.log('Number(zuanshiNum) / data[0].diamond * 0.3 * 50', Number(zuanshiNum) / (data[0].diamond * 0.3 * 50));
                this.diamondNum['progress'].value = Number(zuanshiNum) / (data[0].diamond * 0.3) * 50;
            }
        }
        

        if (Number(this.mainConfig.table.level) > 0) {
            for (let i = 0; i < 4; i++) {
                this['table' + i].visible = true;
                this['table' + i].scaleX = 1;
                this['table' + i].scaleY = 1;
                this['table' + i].source = `table${i}${this.mainConfig.table.level}_png`;
            }
            if (this.mainConfig.table.store > 0) {
                this.tableCollectBtn.scaleX = 1;
                this.tableCollectBtn.scaleY = 1;
                this.tableCollectBtn[`collectNumTxt`].text = "+" + GameConst.tranNumber(this.mainConfig.table.store, 1);
            }
            if (this.mainConfig.table.capacity > 0) {
                this.updateCapacity("table");
            }
        }

        if (Number(this.mainConfig.oven.level) > 0) {
            this.ovenGroup.visible = true;
            this.ovenGroup.scaleX = 1;
            this.ovenGroup.scaleY = 1;
            this.oven.source = `ovenLv${this.mainConfig.oven.level}_png`;
            if (this.mainConfig.oven.level > 2) {
                this.oven.anchorOffsetX = equipmentConfig.oven[`lv${this.mainConfig.oven.level}`].anchorOffsetX;
                this.oven.anchorOffsetY = equipmentConfig.oven[`lv${this.mainConfig.oven.level}`].anchorOffsetY;
            }
            if (this.mainConfig.oven.store > 0) {
                this.ovenCollectBtn.scaleX = 1;
                this.ovenCollectBtn.scaleY = 1;
                this.ovenCollectBtn[`collectNumTxt`].text = "+" + GameConst.tranNumber(this.mainConfig.oven.store, 1);
            }
            if (this.mainConfig.oven.capacity > 0) {
                this.updateCapacity("oven");
            }
        }

        if (Number(this.mainConfig.refrigerator.level) > 0) {
            this.refrigerator.visible = true;
            this.refrigerator.scaleX = 1;
            this.refrigerator.scaleY = 1;
            this.refrigerator.source = `refrigeratorLv${this.mainConfig.refrigerator.level}_png`
            this.refrigerator.anchorOffsetX = equipmentConfig.refrigerator[`lv${this.mainConfig.refrigerator.level}`].anchorOffsetX;
            this.refrigerator.anchorOffsetY = equipmentConfig.refrigerator[`lv${this.mainConfig.refrigerator.level}`].anchorOffsetY;
            if (this.mainConfig.refrigerator.store > 0) {
                this.refrigeratorCollectBtn.scaleX = 1;
                this.refrigeratorCollectBtn.scaleY = 1;
                this.refrigeratorCollectBtn[`collectNumTxt`].text = "+" + GameConst.tranNumber(this.mainConfig.refrigerator.store, 1);
            }
            if (this.mainConfig.refrigerator.capacity > 0) {
                this.updateCapacity("refrigerator");
            }
        }

        if (Number(this.mainConfig.coffeeMaker.level) > 0) {
            this.coffeeMakerGroup.visible = true;
            this.coffeeMakerGroup.scaleX = 1;
            this.coffeeMakerGroup.scaleY = 1;
            this.coffeeMaker.source = `coffeeMakerLv${this.mainConfig.coffeeMaker.level}_png`;
            this.coffeeMaker.anchorOffsetX = equipmentConfig.coffeeMaker[`lv${this.mainConfig.coffeeMaker.level}`].anchorOffsetX;
            this.coffeeMaker.anchorOffsetY = equipmentConfig.coffeeMaker[`lv${this.mainConfig.coffeeMaker.level}`].anchorOffsetY;
            if (this.mainConfig.coffeeMaker.store > 0) {
                this.coffeeMakerCollectBtn.scaleX = 1;
                this.coffeeMakerCollectBtn.scaleY = 1;
                this.coffeeMakerCollectBtn[`collectNumTxt`].text = "+" + GameConst.tranNumber(this.mainConfig.coffeeMaker.store, 1);
            }
            if (this.mainConfig.coffeeMaker.capacity > 0) {
                this.updateCapacity("coffeeMaker");
            }
        }

        if (Number(this.mainConfig.barCounter.level) > 0) {
            this.barCounter.visible = true;
            this.barCounter.scaleX = 1;
            this.barCounter.scaleY = 1;
            this.barCounter.source = `barCounterLv${this.mainConfig.barCounter.level}_png`
            this.barCounter.anchorOffsetX = equipmentConfig.barCounter[`lv${this.mainConfig.barCounter.level}`].anchorOffsetX;
            this.barCounter.anchorOffsetY = equipmentConfig.barCounter[`lv${this.mainConfig.barCounter.level}`].anchorOffsetY;
            if (this.mainConfig.barCounter.store > 0) {
                this.barCounterCollectBtn.scaleX = 1;
                this.barCounterCollectBtn.scaleY = 1;
                this.barCounterCollectBtn[`collectNumTxt`].text = "+" + GameConst.tranNumber(this.mainConfig.barCounter.store, 1);
            }
            if (this.mainConfig.barCounter.capacity > 0) {
                this.updateCapacity("barCounter");
            }
        }

        if (this.mainConfig.waitress.level > 0) {
            for (let i = 0; i < 2; i++) {
                let waitress = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.SVGAPool[`waitressLv${this.mainConfig.waitress.level}`]);
                waitress.x = 50;
                waitress.y = 180;
                waitress.anchorOffsetX = 50;
                waitress.anchorOffsetY = 180;

                waitress.scaleX = -1 * Math.pow(-1, i);
                this[`waitress${i}Base`] = waitress;
                this['waitress' + i].scaleX = 1;
                this['waitress' + i].scaleY = 1;
                this['waitress' + i].addChild(waitress);
                this['waitress' + i].dir = -1 * Math.pow(-1, i);
            }
            if (this.mainConfig.waitress.capacity > 0) {
                this.updateCapacity("waitress", 3000);
            }
            this.randomMove();
        }

        this.updateExchange();

        this.updateFee();

        this.updateAddSpeed();

        this.updateVie();

        if (this.mainConfig.storeUpgrade && !this.isGuide) {
            // 店铺升级 有奖励
            if (this.mainConfig.hasUpgradeReward) {
                let data = {
                    hasUpgradeReward: this.mainConfig.hasUpgradeReward,
                    upgradeReward: this.mainConfig.upgradeReward,
                    storeLevel: this.mainConfig.storeLevel,
                    scene: this,
                    chickenNewEnable: this.mainConfig.chickenNewEnable,
                    feeNewEnable: this.mainConfig.feeNewEnable,
                    grabNewEnable: this.mainConfig.grabNewEnable,
                    exchangeNewEnable: this.mainConfig.exchangeNewEnable,
                    partnerUserId: this.mainConfig.partnerUserId
                }
                PanelCtrl.instance.show(ModuleTypes.UPLEVEL_PANEL, data)
            }//else{
            //     if (this.mainConfig.grabNewEnable || this.mainConfig.chickenNewEnable || this.mainConfig.feeNewEnable || this.mainConfig.exchangeNewEnable) {
            //         if (this.mainConfig.chickenNewEnable) {
            //             let pumpdata = { storeLevel: this.mainConfig.storeLevel, chickenNewEnable: this.mainConfig.chickenNewEnable, scene: this }
            //             this.updateAddSpeed(pumpdata);
            //         }
            //         if (this.mainConfig.exchangeNewEnable) {
            //             let pumpdata = { storeLevel: this.mainConfig.storeLevel, exchangeNewEnable: this.mainConfig.exchangeNewEnable, scene: this }
            //             this.updateExchange(pumpdata);
            //         }
            //         if (this.mainConfig.grabNewEnable) {
            //             let pumpdata = { storeLevel: this.mainConfig.storeLevel, grabNewEnable: this.mainConfig.grabNewEnable, scene: this }
            //             this.updateVie(pumpdata)
            //         }
            //         if (this.mainConfig.feeNewEnable) {
            //             let pumpdata = { storeLevel: this.mainConfig.storeLevel, feeNewEnable: this.mainConfig.feeNewEnable, scene: this }
            //             this.updateFee(pumpdata);
            //         }
            //     }
            // }

        }

    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad():void{

        this.djxBtn.visible = false;
        this.addMoneyActLb.alpha = 0;
        this.addMoneyActLb.touchEnabled = false;

        // 初始化数据
        this.updateData();

        // 初始化埋点
        this.initBuired();

        // 初始化UI
        this.updateUI()

        // 初始化场景逻辑
        this.initLogic();

        let shap = new egret.Shape();
        shap.graphics.beginFill(0);
        shap.graphics.drawRect(0, 0, 86, 86);
        shap.graphics.endFill();
        this.changeGroup.addChild(shap);

        this.prizeImgGroup2.mask = shap;

        let data = DataManager.ins.getData("exchangeList").data;
        let data2 = DataManager.ins.getData("getPrize").data;
        let imgArr = [];

        if(data && data.length > 0){
            this.prizeTipsLb2.text = data[0].diamond + '钻石可兑奖';
        }
        //初始化奖品
        for(let i = 0; i < data.length; i++){
            for (let n: number = 0; n < data2.length; n++) {
                if (data[i].itemId == data2[n].id) {
                    let idata = data2[n];
                    imgArr.push(idata.icon);
                }
            }
        }

        if(imgArr.length > 0){
            if(imgArr.length > 1){
                //轮播图片
                let imgUIArr = [];
                for(let j = 0; j < 2; j++){
                    let img0 = new eui.Image();
                    img0.width = 80;
                    img0.height = 80;
                    img0.x = 3 + 86 * j;
                    img0.source = imgArr[j];
                    this.prizeImgGroup2.addChild(img0);
        
                    imgUIArr.push(img0);
                }

                let orgIdx = 0;
                egret.Tween.get(this.prizeImgGroup2,{loop:true}).wait(2000).to({x: -86}, 500, egret.Ease.cubicIn).call(()=>{
                    orgIdx ++;
                    if(orgIdx == imgArr.length){
                        orgIdx = 0;
                    }

                    this.prizeImgGroup2.x = 0;

                    for(let i = 0; i < 2; i++){
                        let img = imgUIArr[i];

                        if(orgIdx + i == imgArr.length){
                            img.source = imgArr[0];
                        }else{
                            img.source = imgArr[orgIdx + i];
                        }
                    }
                });
            }else{
                let img0 = new eui.Image();
                img0.width = 80;
                img0.height = 80;
                img0.source = imgArr[0];
                this.prizeImgGroup2.addChild(img0);
            }
        }


            
    }

    updateWaiterExtraGold() {
        if (this.mainConfig.waiterExtraGold) {
            let data = { partnerUserId: this.mainConfig.partnerUserId, coin: this.mainConfig.waitress.store, scene: this }
            PanelCtrl.instance.show(ModuleTypes.REVENUE_PANEL, data)
        }
    }

    updateSign() {
        const { sign } = DataManager.ins.getData("getTaskInfo").data;
        // 是否每日首次访问
        if (!sign && !GCache.readCache(new Date(new Date().toLocaleDateString()).getTime() + DataManager.ins.getData("index").data.partnerUserId + "")) {
            // 每日首次访问
            GCache.writeCache(new Date(new Date().toLocaleDateString()).getTime() + DataManager.ins.getData("index").data.partnerUserId + "", 1)
            // 今日未签到  弹签到弹窗
            let data = { sign: sign, partnerUserId: this.mainConfig.partnerUserId, data: DataManager.ins.getData("getTaskInfo").data, scene: this }
            PanelCtrl.instance.show(ModuleTypes.SIGN_PANEL, data);
        }
    }

    updateExchange(data?) {
        let pumpdata
        if (data) {
            pumpdata = { storeLevel: data.storeLevel, exchangeNewEnable: data.exchangeNewEnable, scene: data.scene }
        } else {
            pumpdata = { storeLevel: this.mainConfig.storeLevel, exchangeNewEnable: this.mainConfig.exchangeNewEnable, scene: this }
        }
        if (pumpdata.exchangeNewEnable) {
            PanelCtrl.instance.show(ModuleTypes.PUMPED_PANEL, pumpdata);
            this.mainConfig.exchangeEnable = true;
        }

        //预留
        // if (!this.mainConfig.exchangeEnable) {
        //     this.exchangeBtn.visible = false;
        //     this.decorateBtn.x = this.exchangeBtn.x;
        // } else {
        //     this.exchangeBtn.visible = true;
        //     this.decorateBtn.x = 340.15;
        // }
    }

    private effArr = [];
    private tidx:number;
    private isAdd:boolean;
    private tapNum:number;
    private onTap_djxBtn():void{
        if(!this.tapNum) this.tapNum = 0;
        this.tapNum ++;

        if(!this.isAdd){
            this.isAdd = true;
            this.startAddSpeed(90000000);

                // // 没有剩余次数
                // this.mainConfig.waiterBuff = 1;
                // this.mainConfig.chickenStatus = 3;
                // this.updateWaitressCapacity();
                // this.randomMove()
        }

        this.addSpeedTips.visible = false;
        
        clearTimeout(this.tidx);
        this.tidx = setTimeout(() => {//2s内没有继续操作，然后发包
            // Waiting.instance.show();
            this.djxBtn.touchEnabled = false;
            weidianNet.addSpeed2(async (sucess:boolean)=>{
                // Waiting.instance.hide();
                if(sucess){
                    let aData = DataManager.ins.getData("addSpeed2").data;
                    this.mainConfig.coin += aData.coins;
    
                    
                    await Ani.instance.collectCoinAni(this.djxBtn.parent.x, this.djxBtn.parent.y, null, this);
                    
                    this.addMoneyActLb.y = 137;
                    this.addMoneyActLb.alpha = 1;
                    this.addMoneyActLb.text = "+" + aData.coins;
                    egret.Tween.get(this.addMoneyActLb).to({alpha:1, y:107}, 500).call(()=>{

                        this.isAdd = false;
                        this.startAddSpeed(0);
                        this.tapNum = 0;
                        this.addMoneyActLb.text = '';
                        this.addMoneyActLb.alpha = 1;
                        this.addSpeedTips.visible = true;
                        this.djxBtn.touchEnabled = true;
                    })
    
                }else{
                    this.djxBtn.touchEnabled = true;
                    this.addSpeedTips.visible = true;

                    this.isAdd = false;
                    this.startAddSpeed(0);
                    this.tapNum = 0;
                    this.addMoneyActLb.text = '';
                    this.addMoneyActLb.alpha = 1;
                    console.log(DataManager.ins.getData("addSpeed2"))
                    if(DataManager.ins.getData("addSpeed2")){
                        if(DataManager.ins.getData("addSpeed2").code == '100501'){
                            ToastCtrl.instance.show("服务员太累了，休息一下稍后再来～")
                        }else if(DataManager.ins.getData("addSpeed2").code == '100502'){
                            ToastCtrl.instance.show("服务员太累了，休息一下稍后再来～")
                        }else{
                            ToastCtrl.instance.show("服务员太累了，休息一下稍后再来～")
                        }
                    }else{
                        ToastCtrl.instance.show("服务员太累了，休息一下稍后再来～")
                    }
                }

            }, this.tapNum, window['projectxId']);
        }, 1000);
        
        let djxEff = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.SVGAPool['djxEff']);
        djxEff.stop();
        djxEff.startAniRange(1, djxEff.totalFrames, 1, ()=>{
            if(this.effArr.length > 0){
                let eff = this.effArr.shift();
                this.djxBtn.parent.removeChild(eff);
                eff.stop();
            }
        });
        if(!this.effArr){
            this.effArr = [];
        }
        this.effArr.push(djxEff);
        djxEff.x = -611;
        djxEff.y = -980;
        this.djxBtn.parent.addChild(djxEff);
        
    }

    // 更新打鸡血按钮状态
    updateAddSpeed(data?) {
        console.log(345345345345345345);
        // 是否新开放打鸡血功能
        let pumpdata
        if (data) {
            pumpdata = { storeLevel: data.storeLevel, chickenNewEnable: data.chickenNewEnable, scene: data.scene }
        } else {
            pumpdata = { storeLevel: this.mainConfig.storeLevel, chickenNewEnable: this.mainConfig.chickenNewEnable, scene: this }
        }
        // debugger
        if (pumpdata.chickenNewEnable) {
            PanelCtrl.instance.show(ModuleTypes.PUMPED_PANEL, pumpdata);
            this.mainConfig.chickenStatus = 1;
        }

        if(this.mainConfig.chickenStatus == 0){
            this.djxBtn.visible = false;
            this.addSpeedTips.visible = false;
        }else{
            this.djxBtn.visible = true;
            this.addSpeedTips.visible = true;
        }

        switch (this.mainConfig.chickenStatus + "") {
            case "0":
                // 没有该功能
                this.mainConfig.waiterBuff = 1;
                break;
            case "1":
                // 可以打鸡血
                // this.addSpeedBtn = new AddSpeedBtn();//打鸡血按钮
                // this.addSpeedBtn.bottom = 162 + 10;
                // this.addSpeedBtn.anchorOffsetX = 98 / 2;
                // this.addSpeedBtn.anchorOffsetY = 98 / 2;
                // this.addSpeedBtn.x = 660;
                // this.addSpeedBtn.width = 98;
                // this.addSpeedBtn.height = 98;
                // this.addChild(this.addSpeedBtn)
                this.addSpeedTips.visible = true;
                this.addChild(this.addSpeedTips);
                this.mainConfig.waiterBuff = 1;
                this.addSpeedTips.touchEnabled = false;
                break;
            case "2":
                // 正在打鸡血
                // this.addSpeedBtn = new AddSpeedBtn();
                // this.addSpeedBtn.bottom = 162 + 10;
                // this.addSpeedBtn.anchorOffsetX = 98 / 2;
                // this.addSpeedBtn.anchorOffsetY = 98 / 2;
                // this.addSpeedBtn.x = 660;
                // this.addSpeedBtn.width = 98;
                // this.addSpeedBtn.height = 98;
                // this.addChild(this.addSpeedBtn)
                this.mainConfig.waiterBuff = 1.5;
                GameConst.setGray(this.addSpeedBtn);
                this.addSpeedBtn.touchEnabled = false;
                this.addSpeedBtn.touchChildren = false;
                // 计时
                // let time = (Date.now() - this.mainConfig.chickenEndTime) > 0 ? Date.now() - this.mainConfig.chickenEndTime + 5000 : 5000;
                this.startAddSpeed(this.mainConfig.chickenEndTime);
                break;
            case "3":
                // 次数已用完 不可打鸡血
                // this.addSpeedBtn = new AddSpeedBtn();
                // this.addSpeedBtn.bottom = 162 + 10;
                // this.addSpeedBtn.anchorOffsetX = 98 / 2;
                // this.addSpeedBtn.anchorOffsetY = 98 / 2;
                // this.addSpeedBtn.x = 660;
                // this.addSpeedBtn.width = 98;
                // this.addSpeedBtn.height = 98;
                // this.addChild(this.addSpeedBtn)
                this.mainConfig.waiterBuff = 1;
                GameConst.setGray(this.addSpeedBtn);
                this.addSpeedBtn.touchEnabled = false;
                this.addSpeedBtn.touchChildren = false;
                break;
        }
    }

    updateFee(data?) {

        if (!window["resImg"]) {
            this.payBtn.right = 30;
        }

        // 是否新开放缴费功能
        // if (this.mainConfig.feeNewEnable) {

        // }
        if (data) {
            this.mainConfig.feeStatus = 1;
        }

        /**
         * 	0没有该功能	1待缴费 2已缴费
         */
        switch (this.mainConfig.feeStatus + "") {
            case "0":
                this.payBtn.visible = false;
                this.mainConfig.feeBuff = 1;
                break;
            case "1":
                this.payBtn.visible = true;
                this.mainConfig.feeBuff = 0.8;
                break;
            case "2":
                this.payBtn.visible = false;
                this.mainConfig.feeBuff = 1;
                break;
        }
    }


    isShowVieCountDown: boolean = false;
    updateVie(data?) {
        // 是否新开放抢单功能   
        let pumpdata
        if (data) {
            pumpdata = { storeLevel: data.storeLevel, grabNewEnable: data.grabNewEnable, scene: data.scene }
        } else {
            pumpdata = { storeLevel: this.mainConfig.storeLevel, grabNewEnable: this.mainConfig.grabNewEnable, scene: this }
        }

        if (pumpdata.grabNewEnable) {
            PanelCtrl.instance.show(ModuleTypes.PUMPED_PANEL, pumpdata);
            this.mainConfig.grabStatus = 1;
        }

        switch (this.mainConfig.grabStatus + "") {
            case "0":
                // 没有该功能
                this.doVieBtn.visible = false;
                this.vieTips.visible = false;
                break;
            case "1":
                // 可抢单
                this.vieTips.visible = false;
                this.doVieBtn.visible = true;
                break;
            case "2":
                // 不可抢单  展示下次抢单时间
                this.vieTips.visible = true;
                this.isShowVieCountDown = true;
                // 按钮置灰
                GameConst.setGray(this.doVieBtn);
                this.doVieBtn.visible = true;
                this.doVieBtn.touchChildren = false;
                this.doVieBtn.touchEnabled = false;
                break;
        }
    }
    /**
     * 更新数据
     */
    updateData() {
        const { hasStore, nickName, avatar, goldCoin, diamond, storeLevel, equipmentList, storeUpgrade, hasUpgradeReward, upgradeReward, partnerUserId, exchangeEnable, exchangeNewEnable,
            grabNewEnable, chickenStatus, chickenNewEnable, hasChickenTime, chickenEndTime, feeStatus, feeNextPayTime, grabStatus, grabNextTime, waiterExtraGold } = DataManager.ins.getData("index").data;

        this.mainConfig.partnerUserId = partnerUserId;
        this.mainConfig.exchangeEnable = exchangeEnable;
        this.mainConfig.exchangeNewEnable = exchangeNewEnable;
        this.mainConfig.hasStore = hasStore;

        if (nickName) {
            this.mainConfig.username = decodeURIComponent(nickName);
        }

        if (avatar) {
            this.mainConfig.avatar = decodeURIComponent(avatar);
        }

        this.mainConfig.storeLevel = storeLevel;
        this.mainConfig.coin = goldCoin;
        this.mainConfig.diamond = diamond;
        this.mainConfig.storeUpgrade = storeUpgrade;
        this.mainConfig.hasUpgradeReward = hasUpgradeReward;
        this.mainConfig.upgradeReward = upgradeReward;
        this.mainConfig.chickenStatus = chickenStatus;
        this.mainConfig.chickenNewEnable = chickenNewEnable;
        this.mainConfig.chickenEndTime = chickenEndTime;
        this.mainConfig.hasChickenTime = hasChickenTime;
        this.mainConfig.feeStatus = feeStatus;
        this.mainConfig.feeNextPayTime = feeNextPayTime;
        this.mainConfig.grabStatus = grabStatus;
        this.mainConfig.grabNewEnable = grabNewEnable;
        this.mainConfig.grabNextTime = grabNextTime;
        this.mainConfig.waiterExtraGold = waiterExtraGold;

        //1桌椅 2烤箱 3冰柜 4咖啡机 5收银台 6服务员
        if (equipmentList && equipmentList.length > 0) {
            equipmentList.forEach(equipment => {
                switch (equipment.type + "") {
                    case "1":
                        // 桌椅
                        this.mainConfig.table.capacity = equipment.capacity;
                        this.mainConfig.table.level = equipment.level;
                        this.mainConfig.table.store = equipment.canReceiveGold;
                        this.mainConfig.table.type = equipment.type;
                        break;
                    case "2":
                        // 烤箱
                        this.mainConfig.oven.capacity = equipment.capacity;
                        this.mainConfig.oven.level = equipment.level;
                        this.mainConfig.oven.store = equipment.canReceiveGold;
                        this.mainConfig.oven.type = equipment.type;
                        break;
                    case "3":
                        // 冰柜
                        this.mainConfig.refrigerator.capacity = equipment.capacity;
                        this.mainConfig.refrigerator.level = equipment.level;
                        this.mainConfig.refrigerator.store = equipment.canReceiveGold;
                        this.mainConfig.refrigerator.type = equipment.type;
                        break;
                    case "4":
                        // 咖啡机
                        this.mainConfig.coffeeMaker.capacity = equipment.capacity;
                        this.mainConfig.coffeeMaker.level = equipment.level;
                        this.mainConfig.coffeeMaker.store = equipment.canReceiveGold;
                        this.mainConfig.coffeeMaker.type = equipment.type;
                        break;
                    case "5":
                        // 收银台
                        this.mainConfig.barCounter.capacity = equipment.capacity;
                        this.mainConfig.barCounter.level = equipment.level;
                        this.mainConfig.barCounter.store = equipment.canReceiveGold;
                        this.mainConfig.barCounter.type = equipment.type;
                        break;
                    case "6":
                        // 服务员
                        this.mainConfig.waitress.capacity = equipment.capacity;
                        this.mainConfig.waitress.level = equipment.level;
                        this.mainConfig.waitress.store = equipment.canReceiveGold;
                        this.mainConfig.waitress.type = equipment.type;
                        break;
                }
            });
        }


        if (this.mainConfig.chickenStatus == 0) {
            this.mainConfig.waiterBuff = 1;
        } else if (this.mainConfig.chickenStatus == 1) {
            this.mainConfig.waiterBuff = 1;
        } else if (this.mainConfig.chickenStatus == 2) {
            this.mainConfig.waiterBuff = 1.5;
        } else if (this.mainConfig.chickenStatus == 3) {
            this.mainConfig.waiterBuff = 1;
        }


        if (this.mainConfig.feeStatus == 0) {
            this.mainConfig.feeBuff = 1;
        } else if (this.mainConfig.feeStatus == 1) {
            this.mainConfig.feeBuff = 0.8;
        } else if (this.mainConfig.feeStatus == 2) {
            this.mainConfig.feeBuff = 1;
        }


        if (this.openStore) {
            // 新开店
            this.updateCoin(0);
        } else {
            this.updateCoin(this.mainConfig.coin);
        }

        this.updateFee();

        this.updateDiamond(this.mainConfig.diamond);
    }

    /**
     * 转换产能  从以天为维度转换为以小时、分钟、秒为维度
     * @param capacity 产能
     * @param type 转换类型
     */
    exchangeCapacity(capacity, type = "s", isFloor = true) {
        let result = 0;
        switch (type) {
            case "h":
                result = isFloor ? Math.floor(capacity / 24) : capacity / 24;
                break;
            case "m":
                result = isFloor ? Math.floor(capacity / 24 / 60) : capacity / 24 / 60;
                break;
            case "s":
                result = isFloor ? Math.floor(capacity / 24 / 60 / 60) : capacity / 24 / 60 / 60;
                break;
        }
        return result;
    }

    updateCoin(goldCoin: number) {
        this.mainConfig.coin = goldCoin;
        this.coinNum['coinNumTxt'].text = GameConst.tranNumber(goldCoin, 1);
    }

    updateDiamond(diamond: number) {
        this.mainConfig.diamond = diamond;
        let zuanshi = GameConst.tranNumber(diamond, 1);
        this.diamondNum['diamondNumTxt'].text = zuanshi;

        let data = DataManager.ins.getData("exchangeList").data;
        if(zuanshi >= data[0].diamond){
            this.diamondNum['progress'].value = 100;
        }else{
            if(Number(zuanshi) > data[0].diamond * 0.3){
                this.diamondNum['progress'].value = 50 + 50 * (Number(zuanshi) - data[0].diamond * 0.3) / (data[0].diamond * 0.7);
            }else{
                this.diamondNum['progress'].value = Number(zuanshi) / (data[0].diamond * 0.3) * 50;
            }
        }
    }

    updateLevel(level: number) {
        if (!level) {
            return
        }
        this.mainConfig.storeLevel = level;
        this['levelTxt'].text = "Lv" + this.mainConfig.storeLevel + "";
    }

    private payBtnExposure: any;
    private redPocketBtnExposure: any;
    private addSpeedBtnExposure: any;
    private doVieBtnExposure: any;
    private decorateBtnExposure: any;
    private exchangeBtnExposure: any;
    private taskBtnExposure: any;
    private inviteBtnExposure: any;
    initBuired() {
        // 3 缴费埋点
        let payBtnDpm = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let payBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.payBtnExposure = Buried.createExposure(payBtnDpm, payBtnDcm);
        if (this.mainConfig.feeStatus == 1) {
            NetManager.ins.showLog(this.payBtnExposure);
        }
        // 4 资源位埋点
        let redPocketBtnDpm = Buried.connectDpm(110, 4, 1); // 点击埋点   
        let redPocketBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.redPocketBtnExposure = Buried.createExposure(redPocketBtnDpm, redPocketBtnDcm);
        if (window["resImg"]) {
            NetManager.ins.showLog(this.redPocketBtnExposure);
        }
        // 5 打鸡血
        let addSpeedBtnDpm = Buried.connectDpm(110, 5, 1); // 点击埋点   
        let addSpeedBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.addSpeedBtnExposure = Buried.createExposure(addSpeedBtnDpm, addSpeedBtnDcm);
        if (this.mainConfig.chickenStatus > 0) {
            NetManager.ins.showLog(this.addSpeedBtnExposure);
        }
        // 6 抢订单
        let doVieBtnDpm = Buried.connectDpm(110, 6, 1); // 点击埋点   
        let doVieBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.doVieBtnExposure = Buried.createExposure(doVieBtnDpm, doVieBtnDcm);
        if (this.mainConfig.grabStatus > 0) {
            NetManager.ins.showLog(this.doVieBtnExposure);
        }
        // 7 装修
        let decorateBtnDpm = Buried.connectDpm(110, 7, 1); // 点击埋点   
        let decorateBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.decorateBtnExposure = Buried.createExposure(decorateBtnDpm, decorateBtnDcm);
        NetManager.ins.showLog(this.decorateBtnExposure);
        // 8 兑换
        let exchangeBtnDpm = Buried.connectDpm(110, 8, 1); // 点击埋点   
        let exchangeBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.exchangeBtnExposure = Buried.createExposure(exchangeBtnDpm, exchangeBtnDcm);
        if (this.mainConfig.exchangeEnable) {
            NetManager.ins.showLog(this.exchangeBtnExposure);
        }
        // 9 任务
        let taskBtnDpm = Buried.connectDpm(110, 9, 1); // 点击埋点   
        let taskBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.taskBtnExposure = Buried.createExposure(taskBtnDpm, taskBtnDcm);
        NetManager.ins.showLog(this.taskBtnExposure);
        // 11 邀请好友
        let inviteBtnDpm = Buried.connectDpm(110, 11, 1); // 点击埋点   
        let inviteBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.inviteBtnExposure = Buried.createExposure(inviteBtnDpm, inviteBtnDcm);
        NetManager.ins.showLog(this.inviteBtnExposure);
    }

    // 是否应该引导
    isGuide = false;
    // 当前引导的步数
    guideStep = 0;
    // 是否开店状态
    openStore = false;
    initLogic() {
        
        if (this.openStore) {
            // 首次访问 首次开店弹窗 然后新手引导
            let inviteCode = GameConst.getQueryString("shareCode")
            let data = { inviteCode: inviteCode, data: DataManager.ins.getData("openStore").data, scene: this }
            PanelCtrl.instance.show(ModuleTypes.GUIDENEW_PANEL, data)
        } else {
            // 非首次访问
            // 是否需要进行引导
            if (this.isGuide && this.mainConfig.table.level == 0) {
                // 进行引导
                GDispatcher.dispatchEvent("guideTest");
            } else {
                // 是否有离线奖励
                if (this.mainConfig.waiterExtraGold) {
                    // 有弹离线奖励弹窗
                    this.updateWaiterExtraGold();
                } else {
                    // 没有弹 签到弹窗
                    this.updateSign();
                }

            }
        }
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.djxBtn, this.onTap_djxBtn);
        this.onTap(this.musicOn, this.onTap_musicOn);
        this.onTap(this.musicOff, this.onTap_musicOff);
        this.onTap(this.taskBtn, this.onTap_taskBtn);
        this.onTap(this.clickGoup2, this.onTap_diamondNum);
        this.onTap(this.getPrizeBtn2, this.onTap_diamondNum);
        this.onTap(this.diamondNum, this.onTap_prizeBtn2);
        this.onTap(this.decorateBtn, this.onTap_decorateBtn);
        this.onTap(this.exchangeBtn, this.onTap_exchangeBtn);
        this.onTap(this.inviteBtn, this.onTap_inviteBtn);
        this.onTap(this.payBtn, this.onTap_payBtn);
        this.onTap(this.doVieBtn, this.onTap_doVieBtn);
        this.onTap(this.goBackBtn, this.onTap_goBackBtn);

        this.onTap(this.refrigeratorCollectBtn, this.onTap_refrigeratorCollectBtn);
        this.onTap(this.barCounterCollectBtn, this.onTap_barCounterCollectBtn);
        this.onTap(this.tableCollectBtn, this.onTap_tableCollectBtn);
        this.onTap(this.ovenCollectBtn, this.onTap_ovenCollectBtn);
        this.onTap(this.coffeeMakerCollectBtn, this.onTap_coffeeMakerCollectBtn);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);

        GDispatcher.addEvent("startAddSpeed", this.startAddSpeed, this);
        GDispatcher.addEvent("onTapAddSpeed", this.onTap_AddSpeed, this);

        GDispatcher.addEvent("guideTest", this.guideTest, this);
        if (GameConst.isIOS()) {
            if (GCache.readCache("isPlayMusic")) {
                if (GCache.readCache("isPlayMusic") == "2") {

                } else {
                    this.onTap(this, this.onTap_musicOff);
                }
            } else {
                this.onTap(this, this.onTap_musicOff);
            }


        }

    }

    onTap_musicOn(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = false;
        window['isPlayMusic'] = false;
        if (GameConst.isIOS()) {
            GCache.writeCache("isPlayMusic", "2");
        } else {
            GCache.writeCache("isPlayMusic", "0");
        }

        this.musicOn.visible = !this.musicOn.visible;
        this.musicOff.visible = !this.musicOff.visible;

        window["playMusic"]("bgMusic", false);
    }

    onTap_musicOff(e) {
        e.stopPropagation();
        GameConst.isPlayMusic = true;
        window['isPlayMusic'] = true;
        GCache.writeCache("isPlayMusic", "1");
        this.musicOn.visible = !this.musicOn.visible;
        this.musicOff.visible = !this.musicOff.visible;

        window["playMusic"]("bgMusic", true);
        this.clearTap(this, this.onTap_musicOff);
    }
    onTap_AddSpeed() {
        this.addSpeedTips.visible = false;
    }

    private addspeedIdx:number;
    startAddSpeed(endTime?) {
        console.log("开始加速")
        // 开始倒计时
        // let timer = new Timer();
        NetManager.ins.clickLog(this.addSpeedBtnExposure)
        const chickenEndTime = DataManager.ins.getData("addSpeed") && DataManager.ins.getData("addSpeed").data ? DataManager.ins.getData("addSpeed").data.chickenEndTime : DataManager.ins.getData("index").data.chickenEndTime;
        const remainChickenTime = DataManager.ins.getData("addSpeed") && DataManager.ins.getData("addSpeed").data ? DataManager.ins.getData("addSpeed").data.remainChickenTime : DataManager.ins.getData("index").data.remainChickenTime;
        this.randomMove(8);
        // this.mainConfig.waiterBuff = 1.5;
        this.mainConfig.chickenStatus = 1;
        this.updateCapacity("waitress", 1500)
        // let _endTime = endTime ? endTime : chickenEndTime;
        // let now = Date.now();
        // let waitTime = Number(_endTime) - Number(now) > 0 ? Number(_endTime) - Number(now) + 1000 : 5000

        if(endTime < 1){
            this.coinNum['coinNumTxt'].text = GameConst.tranNumber(this.mainConfig.coin, 1);
            // weidianNet.index((s) => {
                // if (!s) {
                //     ToastCtrl.instance.show("更新打鸡血失败，请刷新重试~")
                //     return
                // }
                // this.updateData();
                // this.updateAddSpeed();
                this.updateWaitressCapacity();
                this.randomMove()
                // this.log(this.mainConfig.waiterBuff)
            // }, window['projectxId'])
        }
        // setTimeout(() => {
        //     if (remainChickenTime > 0) {
        //         剩余打鸡血次数大于零
        //         weidianNet.index((s) => {
        //             if (!s) {
        //                 ToastCtrl.instance.show("更新打鸡血失败，请刷新重试~")
        //                 return
        //             }
        //             this.updateData();
        //             // this.updateAddSpeed();
        //             this.updateWaitressCapacity();
        //             this.randomMove()
        //             // this.log(this.mainConfig.waiterBuff)
        //         }, window['projectxId'])

        //     } else {
        //         // 没有剩余次数
        //         this.mainConfig.waiterBuff = 1;
        //         this.mainConfig.chickenStatus = 3;
        //         this.updateWaitressCapacity();
        //         this.randomMove()
        //     }
        //     this.log("打鸡血结束")
        // }, endTime);
    }
    // 引导检测
    guideMask: egret.Shape;
    guideTest() {
        if (!this.isGuide || this.guideStep > 5 || this.mainConfig.table.level > 0) {
            return
        }
        // this.log(this.guideStep)
        this.guideGroup.visible = true;
        this.guideGroup.touchEnabled = false;
        this.addChild(this.guideGroup)
        let x, y, r
        switch (this.guideStep + "") {
            case "0":
                this.guide1.visible = true;
                // 引导装修
                x = this.decorateBtn.x;
                y = GameConst.stage.stageHeight - this.decorateBtn.bottom - this.decorateBtn.height / 2;
                r = 70;
                this.guideMask = GameConst.drawCircleMask(x, y, r);
                let tap = GameConst.drawCircle(x, y, r, 0x000000, 0);
                tap.x = x;
                tap.y = y;
                tap.anchorOffsetX = r / 2;
                tap.anchorOffsetY = r / 2;
                this.guide1.addChild(this.guideMask);
                this.guide1.addChild(tap);

                this.onTap(tap, this.onTap_decorateBtn)
                let finger = new eui.Image();
                finger.source = `finger_png`
                egret.Tween.get(finger, { loop: true })
                    .set({ scaleX: 1.5, scaleY: 1.5 })
                    .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                    .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                    .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                    .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                    .wait(330)
                finger.touchEnabled = false;
                finger.x = x + 10;
                finger.y = y + 10;
                this.guide1.addChild(finger);
                let tips = new eui.Label();
                tips.text = "点击装修店铺";
                tips.x = x;
                tips.y = y + 100
                tips.anchorOffsetX = tips.width / 2;
                this.guide1.addChild(tips);
                break;
            case "1":
                break;
            case "2":
                break;
            case "3":
                this.touchEnabled = false;
                this.touchChildren = false;
                wait(2000).then(() => {
                    this.touchChildren = true;
                    this.touchEnabled = true;
                    this.guide2.visible = true;
                    x = this.taskBtn.x;
                    y = GameConst.stage.stageHeight - this.taskBtn.bottom - this.taskBtn.height / 2;
                    r = 70;
                    this.guideMask = GameConst.drawCircleMask(x, y, r);
                    let tap = GameConst.drawCircle(x, y, r, 0x000000, 0);
                    tap.x = x;
                    tap.y = y;
                    tap.anchorOffsetX = r / 2;
                    tap.anchorOffsetY = r / 2;
                    this.guide2.addChild(this.guideMask);
                    this.guide2.addChild(tap);

                    this.onTap(tap, this.onTap_taskBtn)
                    let finger = new eui.Image();
                    finger.source = `finger_png`
                    egret.Tween.get(finger, { loop: true })
                        .set({ scaleX: 1.5, scaleY: 1.5 })
                        .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                        .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                        .to({ scaleX: 1.4, scaleY: 1.4 }, 170)
                        .to({ scaleX: 1.5, scaleY: 1.5 }, 170)
                        .wait(330)
                    finger.touchEnabled = false;
                    finger.x = x + 10;
                    finger.y = y + 10;
                    this.guide2.addChild(finger);
                    let tips = new eui.Label();
                    tips.text = "点击店主任务";
                    tips.x = x;
                    tips.y = y + 100
                    tips.anchorOffsetX = tips.width / 2;
                    this.guide2.addChild(tips);
                })
                break;
            case "4":

                break;
        }
    }

    onTap_friend(e) {
        Waiting.instance.show();
        let friendUserId = e.$target.$parent.friendUserId;
        weidianNet.getFriendDetail((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                return
            }
            SceneCtrl.instance.change(ModuleTypes.MINOR_SCENE, friendUserId);
        }, friendUserId, window['projectxId'])
    }

    onTap_shop(e) {
        Waiting.instance.show();
        let shopId = e.$target.$parent.shopId;
        let idx = e.$target.$parent.idx;
        let shopDpm = Buried.connectDpm(110, 10, idx); // 点击埋点   
        let shopDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let shopExposure = Buried.createExposure(shopDpm, shopDcm);
        NetManager.ins.clickLog(shopExposure);
        weidianNet.getShopDetail((s) => {
            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                return
            }
            weidianNet.getShopStatus((ss) => {
                Waiting.instance.hide();
                SceneCtrl.instance.change(ModuleTypes.SHOP_SCENE);
            }, shopId, window['projectxId'])
        }, shopId, window["projectxId"])
    }

    onTap_payBtn() {
        NetManager.ins.clickLog(this.payBtnExposure);
        Waiting.instance.show();
        weidianNet.getPayCount((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                return
            }
            if (this.mainConfig.waitress.level > 0) {
                weidianNet.waiterGold((ss) => {
                    let data = {
                        data: DataManager.ins.getData("getPayCount").data, goldCoin: DataManager.ins.getData("index").data.goldCoin, scene: this, func: () => {
                            this.payBtn.visible = false;
                        }
                    }
                    if (ss) {
                        this.mainConfig.coin = DataManager.ins.getData("waiterGold").data;
                        data.goldCoin = DataManager.ins.getData("waiterGold").data;
                    }
                    PanelCtrl.instance.show(ModuleTypes.PAY_PANEL, data)
                }, window['projectxId'], false)
            } else {
                let data = {
                    data: DataManager.ins.getData("getPayCount").data, goldCoin: DataManager.ins.getData("index").data.goldCoin, scene: this, func: () => {
                        this.payBtn.visible = false;
                    }
                }
                PanelCtrl.instance.show(ModuleTypes.PAY_PANEL, data)
            }
        }, window['projectxId'])
    }

    onTap_doVieBtn() {
        Waiting.instance.show();
        NetManager.ins.clickLog(this.doVieBtnExposure)
        if (this.mainConfig.waitress.level > 0) {
            weidianNet.waiterGold(() => {
                // 收取服务员金币
                weidianNet.getVieCost((s) => {
                    if (!s) {
                        ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                        return
                    }
                    this.updateData();
                    let data = { data: DataManager.ins.getData("getVieCost").data, scene: this }
                    PanelCtrl.instance.show(ModuleTypes.FOODREADY_PANEL, data);
                }, window["projectxId"])
            })
        } else {
            weidianNet.getVieCost((s) => {
                if (!s) {
                    ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    return
                }
                this.updateData();
                let data = { data: DataManager.ins.getData("getVieCost").data, scene: this }
                PanelCtrl.instance.show(ModuleTypes.FOODREADY_PANEL, data);
            }, window["projectxId"])
        }

    }

    onTap_goBackBtn() {
        // const module = "WDJSBridge";
        // const identifier = "goBack";
        // window['KDJSBridge2'].call(module, identifier);
        PanelCtrl.instance.show(ModuleTypes.LEAVE_PANEL)
    }

    collectWaiterGoldCount: number = 0;

    onEnterFrame() {

        // this.log(this.mainConfig.waiterBuff)
        // 是否计算抢单倒计时
        if (this.isShowVieCountDown) {
            this.startCountDown(this.vieCountDown, this.mainConfig.grabNextTime, () => {
                this.vieTips.visible = false;
                this.doVieBtn.visible = true;
                GameConst.clearFilter(this.doVieBtn);
                this.isShowVieCountDown = false;
                this.doVieBtn.touchEnabled = true;
                this.doVieBtn.touchChildren = true;
            })
        }

        this.collectWaiterGoldCount++;
        if (!this.mainConfig.waiterExtraGold) {
            if (this.collectWaiterGoldCount % (60 * 10) == 0) {
                if (this.mainConfig.waitress.level > 0) {
                    weidianNet.waiterGold((s) => {
                        if (s) {
                            this.mainConfig.coin = DataManager.ins.getData("waiterGold").data;
                        }
                    })
                }
            }
        }
    }

    onTap_refrigeratorCollectBtn() {
        Waiting.instance.show();
        this.refrigeratorCollectBtn.touchEnabled = false;
        this.refrigeratorCollectBtn.touchChildren = false;
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.refrigeratorCollectBtn.touchEnabled = true;
                this.refrigeratorCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(95, 155, this.refrigeratorCollectBtn, this);
            this.refrigeratorCollectBtn.touchEnabled = true;
            this.refrigeratorCollectBtn.touchChildren = true;
            this.mainConfig.refrigerator.store = 0;
            this.updateCapacity("refrigerator");
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.refrigerator.type)
    }

    onTap_barCounterCollectBtn() {
        Waiting.instance.show();
        this.barCounterCollectBtn.touchEnabled = false;
        this.barCounterCollectBtn.touchChildren = false;
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.barCounterCollectBtn.touchEnabled = true;
                this.barCounterCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(538, 200, this.barCounterCollectBtn, this);
            this.barCounterCollectBtn.touchEnabled = true;
            this.barCounterCollectBtn.touchChildren = true;
            this.mainConfig.barCounter.store = 0;
            this.updateCapacity("barCounter");
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.barCounter.type)
    }

    onTap_tableCollectBtn() {
        Waiting.instance.show();
        this.tableCollectBtn.touchEnabled = false;
        this.tableCollectBtn.touchChildren = false;
        let type = ""
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.tableCollectBtn.touchEnabled = true;
                this.tableCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(560, 380, this.tableCollectBtn, this);
            this.tableCollectBtn.touchEnabled = true;
            this.tableCollectBtn.touchChildren = true;
            this.mainConfig.table.store = 0;
            this.updateCapacity("table");
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.table.type)
    }

    onTap_ovenCollectBtn() {
        Waiting.instance.show();
        this.ovenCollectBtn.touchEnabled = false;
        this.ovenCollectBtn.touchChildren = false;
        let type = ""
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.ovenCollectBtn.touchEnabled = true;
                this.ovenCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(480, 750, this.ovenCollectBtn, this);
            this.ovenCollectBtn.touchEnabled = true;
            this.ovenCollectBtn.touchChildren = true;
            this.mainConfig.oven.store = 0;
            this.updateCapacity("oven");
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.oven.type)
    }

    onTap_coffeeMakerCollectBtn() {
        Waiting.instance.show();
        this.coffeeMakerCollectBtn.touchEnabled = false;
        this.coffeeMakerCollectBtn.touchChildren = false;
        let type = ""
        weidianNet.receiveGold(async (s) => {
            Waiting.instance.hide();
            if (!s) {
                this.coffeeMakerCollectBtn.touchEnabled = true;
                this.coffeeMakerCollectBtn.touchChildren = true;
                ToastCtrl.instance.show("收取失败，请稍后重试~")
                return
            }
            await Ani.instance.collectCoinAni(100, 750, this.coffeeMakerCollectBtn, this);
            this.coffeeMakerCollectBtn.touchEnabled = true;
            this.coffeeMakerCollectBtn.touchChildren = true;
            this.mainConfig.coffeeMaker.store = 0;
            this.updateCapacity("coffeeMaker");
            this.updateCoin(DataManager.ins.getData("receiveGold").data)
        }, window["projectxId"], this.mainConfig.coffeeMaker.type)
    }

    // 邀请好友
    onTap_inviteBtn() {
        NetManager.ins.clickLog(this.inviteBtnExposure)
        weidianNet.getInviteCode((s) => {
            if (!s) {
                ToastCtrl.instance.show("获取邀请码失败，请重试~")
                return
            }
            let data = { partnerUserId: this.mainConfig.partnerUserId, scene: this }
            PanelCtrl.instance.show(ModuleTypes.INVITE_PANEL, data)
        })
    }

    private onTap_prizeBtn2(){
        Waiting.instance.show();
        NetManager.ins.clickLog(this.taskBtnExposure)
        weidianNet.getTaskInfo((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新任务失败，请重试~")
                return
            }
            if (this.isGuide) {
                this.guide2.visible = false;
            }
            let data = { 
                data: DataManager.ins.getData("getTaskInfo").data, 
                partnerUserId: DataManager.ins.getData("index").data.partnerUserId, 
                scene: this,
                isend:true 
            }
            PanelCtrl.instance.slideUp(ModuleTypes.TASK_PANEL, GameConst.stage.stageHeight * 1 / 2, data);
        }, window['projectxId'])
    }

    // 店长任务
    async onTap_taskBtn() {
        Waiting.instance.show();
        NetManager.ins.clickLog(this.taskBtnExposure)
        weidianNet.getTaskInfo((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新任务失败，请重试~")
                return
            }
            if (this.isGuide) {
                this.guide2.visible = false;
            }
            let data = { data: DataManager.ins.getData("getTaskInfo").data, partnerUserId: DataManager.ins.getData("index").data.partnerUserId, scene: this }
            PanelCtrl.instance.slideUp(ModuleTypes.TASK_PANEL, GameConst.stage.stageHeight * 1 / 2, data);
        }, window['projectxId'])
        // let pumpdata = { storeLevel: this.mainConfig.storeLevel, grabNewEnable: this.mainConfig.grabNewEnable, scene: this }
        // PanelCtrl.instance.show(ModuleTypes.PUMPED_PANEL, pumpdata);
    }

    // 店铺装修
    async onTap_decorateBtn() {
        Waiting.instance.show();
        NetManager.ins.clickLog(this.decorateBtnExposure);
        weidianNet.getEquipments((s) => {
            Waiting.instance.hide();
            if (!s) {
                ToastCtrl.instance.show("更新列表失败，请重试~")
                return
            }
            if (this.isGuide) {
                this.guide1.visible = false;
            }
            let data = {
                data: DataManager.ins.getData("getEquipments").data,
                isGuide: this.isGuide,
                coin: this.mainConfig.coin,
                partnerUserId: this.mainConfig.partnerUserId,
                scene: this,
                func: () => { }
            }
            if (this.mainConfig.waitress.level > 0) {
                weidianNet.waiterGold((ss) => {
                    if (ss) {
                        this.mainConfig.coin = DataManager.ins.getData("waiterGold").data;
                        data.coin = DataManager.ins.getData("waiterGold").data;
                    }
                    PanelCtrl.instance.slideUp(ModuleTypes.GUIDEBUY_PANEL, GameConst.stage.stageHeight * 2 / 5, data)
                })
            } else {
                PanelCtrl.instance.slideUp(ModuleTypes.GUIDEBUY_PANEL, GameConst.stage.stageHeight * 2 / 5, data)
            }

        })
    }

    // 兑换好礼
    async onTap_exchangeBtn() {
        this.exchangeBtn.touchEnabled = false;
        NetManager.ins.clickLog(this.exchangeBtnExposure);
        Waiting.instance.show();
        weidianNet.exchangeList((s) => {
            Waiting.instance.hide();
            this.exchangeBtn.touchEnabled = true;
            if (!s) {
                ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                return
            }
            weidianNet.getPrize((ss) => {
                if (!ss) {
                    ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    return
                }
                let data = { data: DataManager.ins.getData("exchangeList").data, data2: DataManager.ins.getData("getPrize").data, diamond: this.mainConfig.diamond, scene: this }
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE, data);
            }, window["projectxId"])
        }, window['projectxId'])

    }
    onTap_diamondNum() {
        Waiting.instance.show();
        weidianNet.exchangeList((s) => {
            Waiting.instance.hide();
            this.exchangeBtn.touchEnabled = true;
            if (!s) {
                ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                return
            }
            weidianNet.getPrize((ss) => {
                if (!ss) {
                    ToastCtrl.instance.show("网络开小差了，再试一次吧~")
                    return
                }
                let data = { 
                    data: DataManager.ins.getData("exchangeList").data, 
                    data2: DataManager.ins.getData("getPrize").data, 
                    diamond: this.mainConfig.diamond, 
                    scene: this
                }
                SceneCtrl.instance.change(ModuleTypes.EXCHANGE_SCENE, data);
            }, window["projectxId"])
        }, window['projectxId'])
    }


    removeEvents() {
        super.removeEvents();
        this.clearTap(this.taskBtn, this.onTap_taskBtn);
        this.clearTap(this.djxBtn, this.onTap_djxBtn);
        this.clearTap(this.clickGoup2, this.onTap_diamondNum);
        this.clearTap(this.getPrizeBtn2, this.onTap_diamondNum);
        this.clearTap(this.decorateBtn, this.onTap_decorateBtn);
        this.clearTap(this.exchangeBtn, this.onTap_exchangeBtn);
        this.clearTap(this.diamondNum, this.onTap_prizeBtn2);

        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }


    /**
     * 更新服务员产能，默认3s更新一次
     * @param time 更新间隔
     */
    public waiterTW: any;
    private waiterTimeOut: any;
    updateWaitressCapacity(time = 3000) {
        if (this.waiterTimeOut) {
            clearTimeout(this.waiterTimeOut);
        }
        // debugger
        let capacity = Math.floor(this.mainConfig.feeBuff * this.mainConfig.waiterBuff * this.exchangeCapacity(this.mainConfig["waitress"].capacity, "s", false) * time / 1000);
        // if (time == 1500) {
        //     debugger
        // }
        this.waiterTimeOut = setTimeout(() => {

            this.waitressCapacityTxt.text = "+" + GameConst.tranNumber(Number(capacity));
            let ty = this.waitressCapacity.y;
            egret.Tween.removeTweens(this.waitressCapacity)
            if (this.waitress0Base) {
                Ani.instance.updateCoinWaiterBase(this.waitress0Base)
            }

            egret.Tween.get(this.waitressCapacity)
                .set({ y: 0 })
                .to({ alpha: 1 }, 330 * time / 3000)
                .wait(330 * time / 3000)
                .to({ y: ty - 20 }, 330 * time / 3000)
                .to({ y: ty - 30, alpha: 0 }, 170 * time / 3000)
                .call(() => {
                    this.waitressCapacity.y = ty;
                    this.mainConfig.coin += capacity;
                    this.updateCoin(this.mainConfig.coin);
                    this.updateCapacity("waitress", time);
                })
        }, time);
        // this.log(this.waiterTW)
    }
    /**
     * 更新产能，默认5s更新一次
     * @param name 设备名字
     * @param time 更新间隔
     */
    updateCapacity(name: string, time = 5000) {

        let offlineCapacity = Math.floor(this.mainConfig.feeBuff * this.exchangeCapacity(this.mainConfig[name].capacity, "h", false) * 6)
        if (offlineCapacity <= this.mainConfig[name].store) {
            return
        }

        if (name == "waitress") {
            if (time == 5000) {
                this.updateWaitressCapacity()
            } else {
                this.updateWaitressCapacity(time)
            }

            return
        }
        // 取到目标产值 5秒的产值

        let capacity = Math.floor(this.mainConfig.feeBuff * this.exchangeCapacity(this.mainConfig[name].capacity, "s", false) * time / 1000);

        let collectBtn = this[`${name}CollectBtn`];
        // debugger
        if (collectBtn) {
            if (collectBtn.scaleX == 0 && collectBtn.scaleY == 0) {
                // 如果按钮处于消失状态 展示按钮   
                if (this[`${name}TimeOut`]) {
                    clearTimeout(this[`${name}TimeOut`])
                }
                this[`${name}TimeOut`] = setTimeout(async () => {
                    this.mainConfig[name].store += capacity;
                    collectBtn.collectNumTxt.text = "+" + GameConst.tranNumber(this.mainConfig[name].store);
                    collectBtn.touchEnabled = false;
                    if (name != "barCounter") {
                        if (name == "table") {
                            Ani.instance.updateCoinBase(this[`${name}1`])
                        }
                        Ani.instance.updateCoinBase(this[`${name}`])
                    }
                    await Ani.instance.createCoinTips(collectBtn);
                    collectBtn.touchEnabled = true;
                    this.updateCapacity(name, time);

                }, time);

            } else {
                // 如果按钮未收取 更新数字
                if (this[`${name}TimeOut`]) {
                    clearTimeout(this[`${name}TimeOut`])
                }
                this[`${name}TimeOut`] = setTimeout(async () => {
                    this.mainConfig[name].store += capacity;
                    collectBtn.collectNumTxt.text = "+" + GameConst.tranNumber(this.mainConfig[name].store);
                    collectBtn.touchEnabled = false;
                    if (name != "barCounter") {
                        if (name == "table") {
                            Ani.instance.updateCoinBase(this[`${name}1`])
                        }
                        Ani.instance.updateCoinBase(this[`${name}`])
                    }
                    await Ani.instance.updateCoinTips(collectBtn.collectNumTxt, this.mainConfig[name].store);
                    collectBtn.touchEnabled = true;
                    this.updateCapacity(name, time)
                }, time)
            }
        }
    }

    // 随机走动
    randomMove(rate: number = 40) {
        let scope = this
        if (this.mainConfig.waitress.level > 0) {
            // for (let i = 0; i < 2; i++) {
            //     let x = Math.max(310 + Math.random() * 5, Math.random() * 463)
            //     let y = Math.max(500 + 60, Math.random() * 1000)
            //     let distance = GameConst.distance(this[`waitress${i}`], { x: x, y: y })

            //     if (x > this[`waitress${i}`].x) {
            //         this[`waitress${i}Base`].scaleX = 1
            //     } else if (x < this[`waitress${i}`].x) {
            //         this[`waitress${i}Base`].scaleX = -1
            //     }
            //     egret.Tween.removeTweens(this[`waitress${i}`]);
            //     egret.Tween.get(this[`waitress${i}`], { onChange: this.onMove.bind(this, rate) })
            //         .to({ x: x, y: y }, rate * distance)
            //         .call(() => {
            //             // console.log(this.mainConfig.waitress.level);
            //             this.randomMove(rate)
            //         })
            // }
            randomMove0(rate);
            randomMove1(rate);

        }

        function randomMove0(rate) {
            if (!scope.waitress0) {
                return
            }
            let x = Math.max(310 + Math.random() * 5, Math.random() * 463)
            let y = Math.max(500 + 60, Math.random() * 1000)
            let distance = GameConst.distance(scope[`waitress0`], { x: x, y: y })

            if (x > scope[`waitress0`].x) {
                scope[`waitress0Base`].scaleX = 1
            } else if (x < scope[`waitress0`].x) {
                scope[`waitress0Base`].scaleX = -1
            }
            egret.Tween.removeTweens(scope[`waitress0`]);
            egret.Tween.get(scope[`waitress0`], { onChange: scope.onMove.bind(scope) })
                .to({ x: x, y: y }, rate * distance)
                .call(() => {
                    // console.log(this.mainConfig.waitress.level);
                    randomMove0(rate)
                })
        }

        function randomMove1(rate) {
            let x = Math.max(310 + Math.random() * 5, Math.random() * 463)
            let y = Math.max(500 + 60, Math.random() * 1000)
            let distance = GameConst.distance(scope[`waitress1`], { x: x, y: y })

            if (x > scope[`waitress1`].x) {
                scope[`waitress1Base`].scaleX = 1
            } else if (x < scope[`waitress1`].x) {
                scope[`waitress1Base`].scaleX = -1
            }
            egret.Tween.removeTweens(scope[`waitress1`]);
            egret.Tween.get(scope[`waitress1`], { onChange: scope.onMove.bind(scope) })
                .to({ x: x, y: y }, rate * distance)
                .call(() => {
                    // console.log(this.mainConfig.waitress.level);
                    randomMove1(rate)
                })
        }
    }

    onMove() {

        if (this.waitress1.y > this.waitress0.y) {
            this.addChildAt(this.waitress1, 12)
            this.addChildAt(this.waitress0, 11)
        } else if (this.waitress1.y < this.waitress0.y) {
            this.addChildAt(this.waitress0, 12)
            this.addChildAt(this.waitress1, 11)
        }
    }

    fixName(name: string, num = 4, type?) {
        if (!name || name == "") {
            if (type == "shop") {
                return "微店"
            } else if (type == "friend") {
                return "我的好友"
            }
        }
        try{
            name = decodeURIComponent(name);
        }
        catch{
            name = unescape(name);
        }
        
        let nameArr = name.split("");
        if (nameArr.length <= num) {
            return name;
        } else {
            let _name = ""
            for (let i = 0; i < num; i++) {
                _name += nameArr[i];
            }
            _name += "..."
            return _name;
        }

    }


    /**
     * 开始显示倒计时
     * @param target 显示目标
     * @param endTime 结束时间
     * @param callback 回调函数
     */
    startCountDown(target: eui.Label, endTime: number, callback: Function) {
        let now = new Date().getTime();

        let date: any = GameConst.time.getEndTime(endTime);
        target.text = `${date.h < 10 ? "0" + date.h : date.h}:${date.m < 10 ? "0" + date.m : date.m}:${date.s < 10 ? "0" + date.s : date.s}`
        if (date.h == 0 && date.m == 0 && date.s == 0 || (now > endTime)) {
            target.text = "00:00:00"
            callback()
        }
    }

}



