import { GCache } from './../../libs/tc/util/GCache';
import GameConst, { wait } from './../GameConst';
import { playBg, playSound, SoundType } from './../ctrls/soundCtrl';
import MovieClipCtrl from "../ctrls/MovieClipCtrl";
import SVGACtrl from '../ctrls/svgaCtrl';
import { equipmentConfig } from './EquipmentConfig';

export default class Ani {

    static get instance() {
        return Ani._instance || (Ani._instance = new Ani())
    }

    private static _instance: Ani;

    constructor() {

    }

    /**
     * 设备生成动效
     * @param target 目标物体
     */
    createAni(target) {
        return new Promise((r) => {
            egret.Tween.removeTweens(target);
            let targetY = target.y
            egret.Tween.get(target)
                .set({ scaleX: 0, scaleY: 0 })
                .to({ scaleX: 0.9, scaleY: 1.1, y: targetY - 30 }, 170)
                .to({ scaleX: 1, scaleY: 1, y: targetY }, 170)
                .call(() => {
                    r();
                })
        })
    }

    /**
     * 设备升级动效
     * @param type 设备类型 1桌椅 2烤箱 3冰柜 4咖啡机 5收银台 6服务员
     * @param toLevel 升级的等级 1 2 3
     */
    upgradeAni(type, toLevel, scene) {
        let scope = scene;

        return new Promise((r) => {
            let equipment = "";
            let target;
            switch (type + "") {
                case "1":
                    // 桌椅
                    equipment = "table";
                    let t = 0;
                    for (let i = 0; i < 4; i++) {
                        let target = scope[`table${i}`];
                        if (toLevel > 1) {
                            let upgradeAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['levelUp']);
                            upgradeAni.x = target.x;
                            upgradeAni.y = target.y - 15;
                            upgradeAni.width = target.width;
                            upgradeAni.anchorOffsetX = 210;
                            upgradeAni.anchorOffsetY = 260;
                            scope.addChild(upgradeAni);
                            upgradeAni.play();
                        } else {
                            let createAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['createAni']);
                            createAni.x = target.x;
                            createAni.y = target.y - 15;
                            createAni.width = target.width;
                            createAni.anchorOffsetX = 140;
                            createAni.anchorOffsetY = 184;
                            scope.addChild(createAni);
                            createAni.play();
                        }

                        egret.Tween.removeTweens(target);
                        let targetY = target.y
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                target.source = `${equipment}${i}${toLevel}_png`
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: targetY - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: targetY }, 170)
                            .call(() => {
                                t++;
                                if (t == 3) {
                                    r();
                                }
                            })
                    }
                    break;
                case "2":
                    // 烤箱
                    equipment = "oven"
                    if (toLevel > 1) {
                        target = scope[`oven`]
                        let upgradeAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['levelUp']);
                        upgradeAni.x = 520;
                        upgradeAni.y = 950;
                        upgradeAni.width = target.width;
                        upgradeAni.anchorOffsetX = 150;
                        upgradeAni.anchorOffsetY = 120;
                        scope.addChild(upgradeAni);
                        upgradeAni.play();
                        egret.Tween.removeTweens(target);
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                target.source = `${equipment}Lv${toLevel}_png`
                                target.anchorOffsetX = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetX;
                                target.anchorOffsetY = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetY;
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                            .call(() => {
                                r();
                            })
                    } else {
                        target = scope[`ovenGroup`]
                        let createAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['createAni']);
                        createAni.x = 580;
                        createAni.y = 1000;
                        createAni.width = target.width;
                        createAni.anchorOffsetX = 150;
                        createAni.anchorOffsetY = 120;
                        scope.addChildAt(createAni, 5);
                        createAni.play();
                        egret.Tween.removeTweens(target);
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                target.source = `${equipment}Lv${toLevel}_png`
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                            .call(() => {
                                r();
                            })
                    }

                    break;
                case "3":
                    // 冰柜
                    equipment = "refrigerator"
                    target = scope[`refrigerator`]
                    if (toLevel > 1) {
                        let upgradeAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['levelUp']);
                        upgradeAni.x = 15;
                        upgradeAni.y = 212 - 15;
                        upgradeAni.width = target.width;
                        upgradeAni.anchorOffsetX = 79;
                        upgradeAni.anchorOffsetY = 57;
                        scope.addChild(upgradeAni);
                        upgradeAni.play();
                        egret.Tween.removeTweens(target);
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                target.source = `${equipment}Lv${toLevel}_png`
                                target.anchorOffsetX = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetX;
                                target.anchorOffsetY = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetY;
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                            .call(() => {
                                r();
                            })
                    } else {
                        let createAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['createAni']);
                        createAni.x = 70;
                        createAni.y = 380;
                        createAni.width = target.width;
                        createAni.anchorOffsetX = 79;
                        createAni.anchorOffsetY = 57;
                        scope.addChildAt(createAni, 5);
                        createAni.play();
                        egret.Tween.removeTweens(target);
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                target.source = `${equipment}Lv${toLevel}_png`;
                                // target.anchorOffsetX = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetX;
                                // target.anchorOffsetY = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetY;
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                            .call(() => {
                                r();
                            })
                    }
                    break;
                case "4":
                    // 咖啡机
                    equipment = "coffeeMaker"

                    if (toLevel > 1) {
                        target = scope[`coffeeMaker`]
                        let upgradeAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['levelUp']);
                        upgradeAni.x = 30;
                        upgradeAni.y = 900;
                        upgradeAni.width = target.width;
                        upgradeAni.anchorOffsetX = 90;
                        upgradeAni.anchorOffsetY = 176;
                        scope.addChild(upgradeAni);
                        upgradeAni.play();
                        egret.Tween.removeTweens(target);
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                target.source = `${equipment}Lv${toLevel}_png`
                                target.anchorOffsetX = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetX;
                                target.anchorOffsetY = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetY;
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                            .call(() => {
                                r();
                            })
                    } else {
                        target = scope[`coffeeMakerGroup`]
                        let createAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['createAni']);
                        createAni.x = 115;
                        createAni.y = 1032;
                        createAni.width = target.width;
                        createAni.anchorOffsetX = 90;
                        createAni.anchorOffsetY = 176;
                        scope.addChildAt(createAni, 5);
                        createAni.play();
                        egret.Tween.removeTweens(target);
                        egret.Tween.get(target)
                            .to({ scaleX: 0, scaleY: 0 }, 170)
                            .call(() => {
                                scope[`coffeeMaker`].source = `${equipment}Lv${toLevel}_png`
                                target.anchorOffsetX = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetX;
                                target.anchorOffsetY = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetY;
                                // debugger
                            })
                            .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                            .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                            .call(() => {
                                r();
                            })
                    }
                    break;
                case "5":
                    equipment = "barCounter"
                    target = scope[`barCounter`]
                    if (toLevel > 1) {
                        let upgradeAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['levelUp']);
                        upgradeAni.x = target.x;
                        upgradeAni.y = target.y - 15;
                        upgradeAni.width = target.width;
                        upgradeAni.anchorOffsetX = target.width / 2;
                        upgradeAni.anchorOffsetY = 300;
                        scope.addChild(upgradeAni);
                        upgradeAni.play();
                    } else {
                        let createAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['createAni']);
                        createAni.x = 520;
                        createAni.y = target.y - 15;
                        createAni.width = 500;
                        createAni.anchorOffsetX = 180;
                        createAni.anchorOffsetY = 150;
                        scope.addChildAt(createAni, 5);
                        createAni.play();
                    }

                    egret.Tween.removeTweens(target);
                    egret.Tween.get(target)
                        .to({ scaleX: 0, scaleY: 0 }, 170)
                        .call(() => {
                            target.source = `${equipment}Lv${toLevel}_png`
                            target.anchorOffsetX = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetX;
                            target.anchorOffsetY = equipmentConfig[equipment][`lv${toLevel}`].anchorOffsetY;
                        })
                        .to({ scaleX: 0.9, scaleY: 1.1, y: target.y - 30 }, 170)
                        .to({ scaleX: 1, scaleY: 1, y: target.y }, 170)
                        .call(() => {
                            r();
                        })
                    // 收银台
                    break;
                case "6":
                    equipment = "waitress"
                    // 服务员
                    let tt = 0;
                    for (let i = 0; i < 2; i++) {

                        if (scope[`waitress${i}`]) {
                            egret.Tween.removeTweens(scope[`waitress${i}`]);
                            let target = scope[`waitress${i}`];
                            if (toLevel > 1) {
                                let upgradeAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['levelUp']);
                                upgradeAni.x = target.x;
                                upgradeAni.y = target.y - 15;
                                upgradeAni.width = target.width;
                                upgradeAni.anchorOffsetX = 210;
                                upgradeAni.anchorOffsetY = 180;
                                scope.addChild(upgradeAni);
                                upgradeAni.play();
                            } else {
                                let createAni = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool['createAni']);
                                createAni.x = target.x;
                                createAni.y = target.y - 15;
                                createAni.width = target.width;
                                createAni.anchorOffsetX = 130;
                                createAni.anchorOffsetY = 140;
                                scope.addChild(createAni);
                                createAni.play();

                            }
                            tt++;
                            let targetY = target.y
                            egret.Tween.get(target)
                                .to({ scaleX: 0, scaleY: 0 }, 170)
                                .call(() => {
                                    // for (let i = 0; i < 2; i++) {
                                    let waitress = new window['SVGA'].EgretMovieClip(SVGACtrl.instance.SVGAPool[`waitressLv${toLevel}`]);
                                    waitress.x = 50;
                                    waitress.y = 180;
                                    waitress.anchorOffsetX = 50;
                                    waitress.anchorOffsetY = 180;

                                    waitress.scaleX = scope[`waitress${i}`].scaleX;
                                    if (scope[`waitress${i}Base`]) {
                                        egret.Tween.removeTweens(scope[`waitress${i}Base`]);
                                        target.removeChild(scope[`waitress${i}Base`]);
                                    }

                                    scope[`waitress${i}Base`] = waitress;
                                    target.addChild(scope[`waitress${i}Base`])
                                    // }
                                    // if(){

                                    // }
                                    egret.Tween.get(target)
                                        .to({ scaleX: 0.9, scaleY: 1.1, y: targetY - 30 }, 170)
                                        .to({ scaleX: 1, scaleY: 1, y: targetY }, 170)
                                        .call(() => {
                                            scope.updateCapacity("waitress");
                                            scope.randomMove()
                                            if (tt == 2) {
                                                r();
                                            }
                                        })
                                })
                        }

                    }

                    break;
            }


        })
    }

    /**
     * 产生金币物体的动效
     * @param target 目标物体
     */
    updateCoinBase(target) {
        return new Promise(r => {
            // egret.Tween.removeTweens(target)
            if (target) {
                egret.Tween.get(target)
                    // .set({ scaleX: 0, scaleY: 0 })
                    .to({ scaleX: 0.9, scaleY: 1.1 }, 100)
                    .to({ scaleX: 1, scaleY: 1 }, 100)
                    .call(() => {
                        r()
                    })
            } else {
                r();
            }

        })
    }

    updateCoinWaiterBase(target) {
        return new Promise(r => {
            // egret.Tween.removeTweens(target)
            if (target) {
                egret.Tween.get(target)
                    // .set({ scaleX: 0, scaleY: 0 })
                    .to({ scaleY: 1.05 }, 100)
                    .to({ scaleY: 1 }, 100)
                    .call(() => {
                        r()
                    })
            } else {
                r();
            }

        })
    }

    /**
     * 产生金币提示的动效
     * @param target 目标物体
     */
    createCoinTips(target) {
        return new Promise(r => {
            egret.Tween.removeTweens(target)
            egret.Tween.get(target)
                .set({ scaleX: 0, scaleY: 0 })
                .wait(100)
                .to({ scaleX: 1.1, scaleY: 1.1 }, 300)
                .to({ scaleX: 1, scaleY: 1 }, 30)
                .call(() => {
                    r();
                })
        })

    }

    /**
     * 更新金币动效
     * @param target 目标提示物体
     * @param number 更改的金币数
     */
    updateCoinTips(target: eui.Label, number: number) {
        return new Promise(r => {
            egret.Tween.removeTweens(target)
            egret.Tween.get(target)
                .set({ scaleX: 1, scaleY: 1 })
                .wait(100)
                .to({ scaleX: 1.3, scaleY: 1.3 }, 170)
                .call(() => { target.text = "+" + GameConst.tranNumber(number) + "" })
                .to({ scaleX: 1, scaleY: 1 }, 160)
                .call(() => {
                    r();
                })
        })
    }

    /**
     * 更新服务员金币动效
     * @param target 服务员头上的金币提示
     */
    updateCoinWaitress(target) {
        egret.Tween.removeTweens(target)
        let targetY = target.y;
        egret.Tween.get(target, { loop: true })
            .set({ scaleX: 0, scaleY: 0, y: targetY, alpha: 1 })
            .wait(100)
            .to({ scaleX: 1.1, scaleY: 1.1 }, 300)
            .to({ scaleX: 1, scaleY: 1 }, 30)
            .to({ y: targetY - 39 }, 500)
            .to({ y: targetY - 40, alpha: 0 }, 30)
    }

    /**
     * 收集金币动效
     * @param x 起始位置x
     * @param y 起始位置y
     * @param scene 当前场景
     */
    collectCoinAni(x, y, target, scene) {
        return new Promise(r => {
            let i = 0;
            if(target){
                let ty = target.y
                egret.Tween.get(target)
                    .to({ y: ty - 10, alpha: 0 }, 330)
                    .call(() => {
                        target.y = ty;
                        target.alpha = 1;
                        target.scaleX = 0;
                        target.scaleY = 0;
                    })

            }
            if (GCache.readCache("isPlayMusic") == "1") {
                if (GameConst.isIOS()) {
                    console.log("url");
                    window['playMusic']("collectCoins", true, false)
                } else {
                    playSound(SoundType.collectCoins)
                }
            }
            for (let i = 0; i < 10; i++) {
                let coin: egret.MovieClip = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool["coinAni"]);
                coin.scaleX = 0.5;
                coin.scaleY = 0.5;
                coin.x = x;
                coin.y = y;
                scene.addChild(coin)
                coin.play(-1);
                egret.Tween.removeTweens(coin)
                wait(60 * i).then(() => {
                    let data = { a: 0 }
                    egret.Tween.get(data, {
                        onChange: () => {
                            coin.x = GameConst.bezier(data.a, x + Math.pow(-1, i) * 20, 120 + Math.pow(-1, i) * 20, 50)
                            coin.y = GameConst.bezier(data.a, y, 150 + 50, 70 + 50)
                        }
                    })
                        .to({ a: 1 }, 500)
                        .call(() => {
                            i++
                            scene.removeChild(coin)
                            if (i == 9) {
                                r()
                            }
                        })

                })
            }
        })
    }

    collectDiamondAni(x, y, scene) {
        return new Promise(r => {
            let i = 0;
            for (let i = 0; i < 10; i++) {
                let diamond: eui.Image = new eui.Image();
                diamond.scaleX = 0.5;
                diamond.scaleY = 0.5;
                diamond.source = "popdia_png";
                diamond.x = x;
                diamond.y = GameConst.stage.stageHeight / 2 - 100;;
                scene.addChild(diamond)
                egret.Tween.removeTweens(diamond)
                wait(60 * i).then(() => {
                    let data = { a: 0 }
                    egret.Tween.get(data, {
                        onChange: () => {
                            diamond.x = GameConst.bezier(data.a, x + Math.pow(-1, i) * 20, 375 + Math.pow(-1, i) * 30, 230)
                            diamond.y = GameConst.bezier(data.a, y, 150 + 50, 110 + 50)
                        }
                    })
                        .to({ a: 1 }, 500)
                        .call(() => {
                            i++
                            scene.removeChild(diamond)
                            if (i == 9) {
                                r()
                            }
                        })
                })
            }
        })
    }


    /**
     * 奖励金币动效
     * @param scene 当前场景
     */
    awardCoinAni(scene) {
        return new Promise(r => {
            let coinLight = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool["coinLightAni"]);
            coinLight.x = 375;
            coinLight.y = GameConst.stage.stageHeight / 2;
            coinLight.anchorOffsetX = 200;
            coinLight.anchorOffsetY = 200;
            scene.addChild(coinLight);
            coinLight.gotoAndPlay(0)
            if (GCache.readCache("isPlayMusic") == "1") {
                if (GameConst.isIOS()) {
                    console.log("url");
                    window['playMusic']("createCoins", true, false)
                } else {
                    playSound(SoundType.createCoins)
                }
            }
            for (let i = 0; i < 10; i++) {
                let coin = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool["coinAni"]);
                coin.x = 375 - 83;
                coin.y = GameConst.stage.stageHeight / 2 - 100;
                coin.scaleX = 1;
                coin.scaleY = 1;
                coin.anchorOffsetX = 83 / 2;
                coin.anchorOffsetY = 86 / 2;
                console.log(coin);

                scene.addChild(coin)
                coin.play(-1);
                egret.Tween.removeTweens(coin)

                wait(60 * i).then(() => {
                    let data = { a: 0 }
                    egret.Tween.get(data, {
                        onChange: () => {
                            coin.x = GameConst.bezier(data.a, 300 + Math.pow(-1, i) * 30, 375 + Math.pow(-1, i) * 30, 70)
                            coin.y = GameConst.bezier(data.a, GameConst.stage.stageHeight / 2 - 100, 400 + 50, 88 + 50 - scene.y + scene.anchorOffsetY)
                            coin.scaleX = Math.max(1 - data.a, 0.4);
                            coin.scaleY = Math.max(1 - data.a, 0.4);
                        }
                    })
                        .to({ a: 1 }, 670)
                        .call(() => {
                            i++
                            scene.removeChild(coin)
                            if (i == 9) {
                                scene.removeChild(coinLight)
                                r()
                            }
                        })

                })
            }
        })
    }


    awardDiamondAni(scene) {
        return new Promise(r => {
            let coinLight = new egret.MovieClip(MovieClipCtrl.instance.movieClipNamePool["coinLightAni"]);
            coinLight.x = 375;
            coinLight.y = GameConst.stage.stageHeight / 2;
            coinLight.anchorOffsetX = 200;
            coinLight.anchorOffsetY = 200;
            scene.addChild(coinLight);
            coinLight.gotoAndPlay(0)
            if (GCache.readCache("isPlayMusic") == "1") {
                if (GameConst.isIOS()) {
                    console.log("url");
                    window['playMusic']("createCoins", true, false)
                } else {
                    playSound(SoundType.createCoins)
                }
            }
            for (let i = 0; i < 10; i++) {
                let diamond = new eui.Image();
                diamond.source = `popdia_png`
                diamond.x = 375 + 15;
                diamond.y = GameConst.stage.stageHeight / 2 - 100;
                diamond.scaleX = 1.5;
                diamond.scaleY = 1.5;
                diamond.anchorOffsetX = 83 / 2;
                diamond.anchorOffsetY = 86 / 2;
                console.log(diamond);

                scene.addChild(diamond)
                egret.Tween.removeTweens(diamond)

                wait(60 * i).then(() => {
                    let data = { a: 0 }
                    egret.Tween.get(data, {
                        onChange: () => {
                            diamond.x = GameConst.bezier(data.a, 390, 375 + Math.pow(-1, i) * 30, 245)
                            diamond.y = GameConst.bezier(data.a, GameConst.stage.stageHeight / 2 - 100, 400 + 50, 173 - scene.y + scene.anchorOffsetY)
                            diamond.scaleX = Math.max(1.5 - data.a, 0.4);
                            diamond.scaleY = Math.max(1.5 - data.a, 0.4);
                        }
                    })
                        .to({ a: 1 }, 670)
                        .call(() => {
                            i++
                            scene.removeChild(diamond)
                            if (i == 9) {
                                scene.removeChild(coinLight)
                                r()
                            }
                        })

                })
            }
        })
    }

}