import { NetManager } from './../../libs/tw/manager/NetManager';
import { Buried } from './../../libs/tw/util/Buried';
import { weidianNet } from './../NetConst';
import { ModuleTypes } from './../types/sceneTypes';
import Scene from "../views/Scene";
import SceneCtrl from "../ctrls/sceneCtrl";
import PanelCtrl from '../ctrls/panelCtrl';
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import GameConst from '../GameConst';

export default class BeginScene extends Scene {
    public get skinKey() { return "Begin" }

    public dog: eui.Image;
    public openStoreBtn: eui.Button;
    public words0: eui.Image;
    public words1: eui.Image;
    public words2: eui.Image;

    private openStoreBtnExposure: any;

    constructor() {
        super();

        // this.percentHeight = 100;
        // this.percentWidth = 100;

        this.initBuired();
        this.initUI();
        this.initAni();

    }

    initBuired() {
        let openStoreBtnDpm = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let openStoreBtnDcm = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.openStoreBtnExposure = Buried.createExposure(openStoreBtnDpm, openStoreBtnDcm);
        NetManager.ins.showLog(this.openStoreBtnExposure);

    }

    initUI() {

    }

    async initAni() {
        this.dogAni();
        this.showBtn();
        await this.words0Ani();
        this.hideWords0();
        await this.words1Ani();
        this.hideWords1();
        await this.words2Ani();
        this.hideWords2();
    }

    dogAni() {
        egret.Tween.get(this.dog, { loop: true })
            .to({ scaleY: 0.98 }, 500)
            .to({ scaleY: 1 }, 500)
    }

    words0Ani() {
        return new Promise(r => {
            egret.Tween.get(this.words0)
                .set({ alpha: 0, y: 90 })
                .to({ alpha: 1, y: 80 }, 500)
                .wait(1500)
                .call(() => {
                    r();
                })
        })
    }

    hideWords0() {
        egret.Tween.get(this.words0)
            .to({ alpha: 0, y: 15 }, 300)
    }

    words1Ani() {
        return new Promise(r => {
            egret.Tween.get(this.words1)
                .set({ alpha: 0, y: 90 })
                .to({ alpha: 1, y: 80 }, 500)
                .wait(1500)
                .call(() => {
                    r();
                })
        })
    }

    hideWords1() {
        egret.Tween.get(this.words1)
            .to({ alpha: 0, y: 15 }, 300)
    }

    words2Ani() {
        return new Promise(r => {
            egret.Tween.get(this.words2)
                .set({ alpha: 0, y: 90 })
                .to({ alpha: 1, y: 80 }, 500)
                .wait(1500)
                .call(() => {
                    r();
                })
        })
    }

    hideWords2() {
        egret.Tween.get(this.words2)
            .to({ alpha: 0, y: 15 }, 300)
    }

    showBtn() {
        egret.Tween.get(this.openStoreBtn)
            .to({ alpha: 1 }, 300)
            .call(() => {

                egret.Tween.get(this.openStoreBtn, { loop: true })
                    .set({ scaleX: 1, scaleY: 1 })
                    .to({ scaleX: 0.95, scaleY: 1.05 }, 160)
                    .to({ scaleX: 1, scaleY: 1 }, 160)
                    .to({ scaleX: 0.95, scaleY: 1.05 }, 160)
                    .to({ scaleX: 1, scaleY: 1 }, 160)
                    .wait(600)
            })
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.openStoreBtn, this.onTap_openStoreBtn)
    }

    onTap_openStoreBtn() {
        // 接口 第一次进
        NetManager.ins.clickLog(this.openStoreBtnExposure);
        Waiting.instance.show();
        if (GameConst.getQueryString("shareCode")) {
            weidianNet.openStore((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    ToastCtrl.instance.show("开店失败，请重试~")
                    return
                }
                weidianNet.help(() => {
                    weidianNet.index((ss) => {
                        if (!ss) {
                            Waiting.instance.hide();
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络开小差了，再试一次吧~", type: "reload" })
                            return
                        }
                        Waiting.instance.hide();
                        weidianNet.getShopsInfo(() => {
                            weidianNet.getFriendsInfo(() => {
                                SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE, true);
                            }, window['projectxId'])
                        }, window["projectxId"])
                    }, window['projectxId'])
                }, GameConst.getQueryString("shareCode"),true)
            }, window["projectxId"])
        } else {
            weidianNet.openStore((s) => {
                if (!s) {
                    Waiting.instance.hide();
                    ToastCtrl.instance.show("开店失败，请重试~")
                    return
                }
                weidianNet.index((ss) => {
                    if (!ss) {
                        Waiting.instance.hide();
                        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, { msg: "网络开小差了，再试一次吧~", type: "reload" })
                        return
                    }
                    Waiting.instance.hide();
                    weidianNet.getShopsInfo(() => {
                        weidianNet.getFriendsInfo(() => {
                            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE, true);
                        }, window['projectxId'])
                    }, window["projectxId"])
                }, window['projectxId'])
            }, window["projectxId"])
        }
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.openStoreBtn, this.onTap_openStoreBtn)
    }
}