import { DataManager } from './../libs/tw/manager/DataManager';
import { NetManager } from './../libs/tw/manager/NetManager';
import { INetData } from './../libs/tc/interface/INetData';
/**
 * 游戏常量
 */
export default class GameConst {
	// 场景
	public static stage: egret.Stage;
	// 用于控制全局音乐是否播放和音乐按钮状态
	public static isPlayMusic: boolean = true;

	// 数组类方法
	public static arr = {
		/**
		 * 从数组里移除指定元素
		 * @param e 要移除的元素
		 * @param arr 目标数组
		 */
		removeEle(e, arr) {
			let index = arr.indexOf(e);
			if (index >= 0) {
				arr.splice(index, 1)
			}
		},

		/**
		 * 数组去重
		 * @param arr 数组
		 */
		unique(arr) {
			if (!arr.length) return arr
			let hash = [];
			hash.push(arr[0]);
			for (var i = 1; i < arr.length; i++) {
				let ele = arr[i];
				if (hash.indexOf(ele) == -1) {
					hash.push(ele)
				}
			}
			return hash
		},

		/**
		 * 数组随机排序
		 * @param arr 数组
		 */
		shuffle(arr): any {
			let i = arr.length;

			while (i) {

				let j = Math.floor(Math.random() * i--);  //5555

				[arr[j], arr[i]] = [arr[i], arr[j]];

			}

			return arr;
		},

		/**
		 * 从数组里取出第一个
		 *  @param arr 目标数组
		 */
		getOne(arr) {
			if (arr && arr.length) {
				return arr.shift();
			}
			return false;
		},
		/**
		 * 从两个数组中取出不同元素
		 * @param arr1 
		 * @param arr2 
		 */
		getDifference(arr1, arr2) {
			return arr1.concat(arr2).filter(function (v, i, arr) {
				return arr.indexOf(v) === arr.lastIndexOf(v);
			});
		},
		/**
		 * 从两个数组中取出相同元素
		 * @param arr1 
		 * @param arr2 
		 */
		getEqual(arr1, arr2) {
			let newArr = [];
			for (let i = 0; i < arr2.length; i++) {
				for (let j = 0; j < arr1.length; j++) {
					if (arr1[j] === arr2[i]) {
						newArr.push(arr1[j]);
					}
				}
			}
			return newArr;
		},

		/**
		 * 从数组里随机取出一个元素
		 * @param e 目标数组
		 * @param n 
		 */
		getRandomOne(e, n?) {
			return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e))
		}

	}

	// 时间类方法
	public static time = {
		/**
		 * 获取今天零点时间戳
		 */
		getTodayMark() {
			return new Date(new Date().setHours(0, 0, 0, 0)).getTime();
		},

		/**
		* 倒计时（默认开始时间为当前时间）
		* @param endTime 结束时间 时间戳
		* @returns 例：剩余时间 {d:1, h:16, m:45, s:41} 代表：1天 16小时 45 分钟41 秒
		*/
		getEndTime(endTime: number): object {
			var startDate = new Date(); //开始时间，当前时间
			var endDate = new Date(endTime); //结束时间，需传入时间参数
			var t = endDate.getTime() - startDate.getTime(); //时间差的毫秒数
			var d = 0, h = 0, m = 0, s = 0;
			if (t >= 0) {
				d = Math.floor(t / 1000 / 3600 / 24);
				h = Math.floor(t / 1000 / 60 / 60 % 24);
				m = Math.floor(t / 1000 / 60 % 60);
				s = Math.floor(t / 1000 % 60);
			}
			return { d: d, h: h, m: m, s: s };
		}

	}

	public static object = {
		/**
		 * 查找对象的相对应的值
		 * @param object 查找对象
		 * @param val 属性
		 */
		inFn(object, val) {
			var array = Object.keys(object);			//此处是查找对象所有的属性值
			var listArray = [];
			var list = new Object();
			for (var item in array) {
				if (array[item].indexOf(val) == -1) {		//没有出现就返回-1
					/*console.log(object[array[item]])
					console.log(array[item])*/
				} else {
					if (object[array[item]] != "" && object[array[item]] != null && object[array[item]] != 0) {
						console.log(array[item])
						console.log(object[array[item]])				//这样就出来了
						//如果想拼接出来相对应的就得这样
						list[array[item]] = object[array[item]];
					}
				}
			}
			console.log(list)				//之前用的object. 死活不行  最后还是得要积累经验！！
		}
	}

	/**
	 * 截取字符串  超出部分显示...
	 * @param str 字符串
	 * @param number 截取长度
	 */
	public static fixString(str: string, number: number = 4) {
		if (!str || str == "") {
			return ""
		}
		let strArr = str.split("");
		if (strArr.length <= number) {
			return str;
		} else {
			let _name = ""
			for (let i = 0; i < number; i++) {
				_name += strArr[i];
			}
			_name += "..."
			return _name;
		}

	}

	/**
	 * 设置颜色滤镜
	 * @param target 目标
	 * @param color 颜色值 16进制 0xffffff
	 */
	public static setFilter(target: eui.Image | eui.Group | eui.Component, color: number) {
		// 将16进制颜色分割成rgb值
		let spliceColor = (color) => {
			let result = { r: -1, g: -1, b: -1 };
			result.b = color % 256;
			result.g = Math.floor((color / 256)) % 256;
			result.r = Math.floor((color / 256) / 256);
			return result;
		}
		let result = spliceColor(color);
		let colorMatrix = [
			1, 0, 0, 0, 0,
			0, 1, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 1, 0
		];
		colorMatrix[0] = result.r / 255;
		colorMatrix[6] = result.g / 255;
		colorMatrix[12] = result.b / 255;
		let colorFilter = new egret.ColorMatrixFilter(colorMatrix);

		target.filters = [colorFilter];
	}

	/**
	 * 设置置灰滤镜
	 * @param target 目标
	 * @param color 颜色值 16进制 0xffffff
	 */
	public static setGray(target: eui.Image | eui.Group | eui.Component) {
		let colorGrayMatrix = [
			0.3, 0.6, 0, 0, 0,
			0.3, 0.6, 0, 0, 0,
			0.3, 0.6, 0, 0, 0,
			0, 0, 0, 1, 0
		];
		let colorFilter = new egret.ColorMatrixFilter(colorGrayMatrix);

		target.filters = [colorFilter];
	}


	/**
	 * 清除颜色滤镜
	 * @param target 目标
	 */
	public static clearFilter(target: eui.Image | eui.Group | eui.Component) {
		target.filters = null;
	}

	/**
	 * 数字转整数文字 如 100000 转为10万
	 * @param num 需要转化的数
	 * @param point 需要保留的小数位数
	 */
	public static tranNumber(num: number, point: number = 1) {
		if (!num && num != 0) {
			console.log("tranNumber格式错误")
			return
		}
		let numStr = num.toString()
		// 一万以内直接返回 
		if (numStr.length < 5) {
			return numStr;
		}
		//大于8位数是亿
		else if (numStr.length > 8) {
			let decimal = numStr.substring(numStr.length - 8, numStr.length - 8 + point);
			return parseFloat(Math.floor(num / 100000000) + '.' + decimal) + '亿';
		}
		//大于4位数是万 
		else if (numStr.length > 4) {
			let decimal = numStr.substring(numStr.length - 4, numStr.length - 4 + point)
			return parseFloat(Math.floor(num / 10000) + '.' + decimal) + '万';
		}
	}

	// 二次贝塞尔,用于做曲线运动
	public static bezier(t: number, p0: number, p1: number, p2: number) {
		// (1-t)^2 P0 + 2(1-t)tP1+ t^2P2
		return Math.pow(1 - t, 2) * p0 + 2 * (1 - t) * t * p1 + Math.pow(t, 2) * p2;
	}

	// 计算距离
	public static distance(obj1: any, obj2: any) {
		let distance = Math.sqrt(Math.pow(obj1.x - obj2.x, 2) + Math.pow(obj1.y - obj2.y, 2));
		return distance;
	}

	// 重新随机排序
	public static randomsort(a, b) {
		return Math.random() > .5 ? -1 : 1;
	}

	/**
	 * 随机数字区间里的一个数
	 * @param n1 开始区间
	 * @param n2 结束区间
	 */
	public static randomNum(n1, n2) {
		if (arguments.length === 2) {
			return Math.round(n1 + Math.random() * (n2 - n1));
		}

		else if (arguments.length === 1) {
			return Math.round(Math.random() * n1)
		}

		else {
			return Math.round(Math.random() * 255)
		}
	}



	// 是否是IOS系统
	public static isIOS() {
		const u = navigator.userAgent;
		let isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
		return isiOS;
	}

	// 是否招行app端内
	public static isMPBank() {
		let ua = navigator.userAgent;
		if (ua.indexOf('MPBank') > -1)
			return true;
		else
			return false;
	}

	// 从url里取字段
	public static getQueryString(name) {
		var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
		var r = window.location.search.substr(1).match(reg);
		if (r != null) return unescape(r[2]); return null;
	}

	/**
	 * 画挖洞引导蒙层
	 * @param centerX 圆心x
	 * @param centerY 圆心y
	 * @param radius 半径
	 */
	public static drawCircleMask(centerX, centerY, radius) {
		let circleMask: egret.Shape = new egret.Shape();

		// 画方形
		circleMask.graphics.beginFill(0x000000, 0.7);
		circleMask.graphics.moveTo(0, 0);
		circleMask.graphics.lineTo(750, 0);
		circleMask.graphics.lineTo(750, GameConst.stage.stageHeight);
		circleMask.graphics.lineTo(0, GameConst.stage.stageHeight);
		circleMask.graphics.lineTo(0, 0);
		// 画圆
		circleMask.graphics.drawArc(centerX, centerY, radius, 0, Math.PI * 2, true)
		circleMask.graphics.endFill();
		circleMask.touchEnabled = true;
		return circleMask
	}


	/**
	 * 画圆
	 * @param x 
	 * @param y 
	 * @param radius 
	 * @param color 
	 * @param alpha 
	 */
	public static drawCircle(x, y, radius, color = 0x000000, alpha = 0.7) {
		let circle = new egret.Shape();
		circle.graphics.beginFill(color, alpha);
		circle.graphics.drawArc(x, y, radius, 0, Math.PI * 2, true)
		circle.graphics.endFill();
		return circle
	}

	/**
	 * 画方
	 * @param x 
	 * @param y 
	 * @param w 
	 * @param h 
	 * @param color 
	 * @param alpha 
	 */
	public static drawRect(x, y, w, h, color = 0x000000, alpha = 0.7) {
		let rect = new egret.Shape();
		rect.graphics.beginFill(color, alpha);
		rect.graphics.drawRect(x, y, w, h);
		rect.graphics.endFill();
		return rect
	}

	/**
	 * 画方
	 * @param obj 
	 * @param color 
	 * @param alpha 
	 */
	public static drawRectByObj(obj, color = 0x000000, alpha = 0.7) {
		let rect = new egret.Shape();
		rect.graphics.beginFill(color, alpha);
		rect.graphics.drawRect(obj.x, obj.y, obj.width, obj.height);
		rect.graphics.endFill();
		return rect
	}

	/**
	 * 判断两个物体是否发生碰撞
	 * @param obj0 检测目标1 {x,y,width,height}
	 * @param obj1 检测目标2 {x,y,width,height}
	 * @param gap 增加判断发生碰撞的间隔距离 
	 */
	public static collisionDetection(obj0: any, obj1: any, gap: number = 0): boolean {
		const l1 = obj0.x - gap;
		const t1 = obj0.y - gap;
		const r1 = obj0.x + obj0.width + gap;
		const b1 = obj0.y + obj0.height + gap;

		const l2 = obj1.x;
		const t2 = obj1.y;
		const r2 = obj1.x + obj1.width;
		const b2 = obj1.y + obj1.height;

		return !(b1 < t2 || l1 > r2 || t1 > b2 || r1 < l2)
	}

	/**
	 * 判断物体是否在区域内 (注意：锚点在左上角)
	 * @param obj1 区域物体 {x,y,width,height}
	 * @param obj2 被检测物体 {x,y,width,height}
	 */
	public static contain(obj1: any, obj2: any): boolean {
		const condition: boolean = obj2.x >= obj1.x && obj2.y >= obj1.y && obj2.x + obj2.width <= obj1.x + obj1.width && obj2.y + obj2.height <= obj1.y + obj1.height;
		return condition;
	}

	/**
	 * 设置cookie
	 * @param name cookie的名称
	 * @param value cookie的值
	 * @param day cookie的过期时间
	 */
	public static setCookie(name, value, day) {
		if (day !== 0) {     //当设置的时间等于0时，不设置expires属性，cookie在浏览器关闭后删除
			var expires = day * 24 * 60 * 60 * 1000;
			var date = new Date(+new Date() + expires);
			document.cookie = name + "=" + escape(value) + ";expires=" + date.toUTCString();
		} else {
			document.cookie = name + "=" + escape(value);
		}
	};

	/**
     * 获取对应名称的cookie
	 * @param name cookie的名称
     * @returns {null} 不存在时，返回null
     */
	public static getCookie(name) {
		let arr;
		let reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
		if (arr = document.cookie.match(reg))
			return unescape(arr[2]);
		else
			return null;
	};

	/**
	* 删除cookie
	* @param name cookie名称
	*/
	public static removeCookie(name) {
		this.setCookie(name, 1, -1);
	}
}



export const wait = (time: number = 500) => {
	return new Promise((resolve) => {
		setTimeout(() => {
			resolve()
		}, time);
	})
}