import { NetName } from './../../libs/tw/enum/NetName';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export default class SignSucPanel extends Panel {
    public get skinKey() { return "SignSuc" }
    public get groupName() { return "signSuc_Panel" }

    public closeBtn: eui.Button;
    public statusTitle: eui.Label;
    public acceptBtn: eui.Button;
    public prizeTips: eui.Label;
    public prizeImg: eui.Image;
    public prizeNum: eui.Label;
    public prizeNum1: eui.Label;
    public prizeNum0: eui.Label;

    data
    callback
    constructor(data) {
        super()
        this.callback = data.callback
        this.data = data
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    initEvents(){
        super.initEvents()
        this.acceptBtn.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTouchTap,this)
    }

    onTouchTap() {
        super.onTouchTap();
        this.callback();
    }

    removeEvents(){
        super.removeEvents()
        this.acceptBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTouchTap,this)
    }


    onLoad() {
      //  const num = DataManager.ins.getData(NetName.SING_SUCCESS).data;
        const num = this.data.signPetCount;
        if (!num) {
            return
        }

        this.prizeNum0.text = `${num}`;
        this.prizeNum1.text = `${num}`;
    }
}