import { NetName } from './../../libs/tw/enum/NetName';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export default class HelpStatusPanel extends Panel {
    public get skinKey() { return "HelpStatus" }
    public get groupName() { return "helpStatus_Panel" }

    public closeBtn: eui.Button;
    public statusTitle: eui.Label;
    public joinBtn: eui.Button;
    public statusTxt: eui.Label;

    private callback: Function = () => { }

    constructor(data) {
        super()
        this.callback = data.callback
    }


    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onLoad() {

    }

    initEvents() {
        super.initEvents();
        this.joinBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_joinBtn, this);
    }

    onTap_joinBtn() {
        this.onTouchTap();
    }

    onTouchTap() {
        super.onTouchTap();
        this.callback();
    }

    removeEvents() {
        super.removeEvents();
        this.joinBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_joinBtn, this);
    }
}