import { NetName } from './../../../.history/egret/libs/tw/enum/NetName_20190815190554';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export default class FirstPrizePanel extends Panel {

    public get skinKey() { return "FirstPrize" }
    public get groupName() { return "firstPrize_Panel" }

    public light: eui.Image;
    public bg: eui.Image;
    public closeBtn: eui.Button;
    public title: eui.Image;
    public minBg: eui.Image;
    public titleBg: eui.Image;
    public acceptBtn: eui.Button;
    public prizeImg: eui.Image;
    public prizeNum: eui.Label;
    public prizeNum1: eui.Label;
    public prizeNum0: eui.Label;
    public prizeTips: eui.Label;

    private callback: Function = () => { }
    private accessRewardCnt: any;

    constructor(data) {
        super();
        this.accessRewardCnt = data.accessRewardCnt;
        this.callback = data.callback;
    }


    initEvents() {
        super.initEvents();
        this.acceptBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    onSkinComplete() {
        super.onSkinComplete();

        this.prizeNum0.text = `${this.accessRewardCnt}`
        this.prizeNum1.text = `${this.accessRewardCnt}`
        this.prizeTips.text = `系统免费赠送${this.accessRewardCnt}只萌宠`;

        egret.Tween.get(this.light, { loop: true })
            .to({ rotation: 360 }, 10000)
    }

    onTouchTap() {
        super.onTouchTap();

        this.callback();
    }

    removeEvents() {
        super.removeEvents();
        this.acceptBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }
}