import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import Loading from "../loading/Loading";
export default class PanelCtrl {
    private _parent: eui.UILayer;
    private _mask: egret.Shape;

    static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    show(type: ModuleTypes, data?, hasMask: boolean = true, time: number = 2500) {
        const cls = this._panelClassMap[type];

        Loading.instace.show();
        const panel: Panel = new cls(data, hasMask, time);
        this._current = panel;
        // panel.setSkinName();
        // panel.setMask();
        // panel.setShowAct();
        // panel.start(data);


        this.add(panel);

        this._parent.visible = true;
    }

    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    public btnDelay(targe: any, dtime: number = 500) {
        targe.touchEnabled = false;
        setTimeout(() => {
            targe.touchEnabled = true;
        }, dtime);
    }

    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    }

    private remove(panel: Panel) {
        this._parent.removeChild(panel);
    }

    private onPanelHide(e: egret.Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);

        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    }

    private onCreditsOut(e: egret.Event) {
        if (!window['CFG'] || !window['CFG'].appInfo) return;
        window.location.href = window['CFG'].appInfo.earnCreditsUrl;
    }

    private _panelClassMap: any;
    registerPanelClass(name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    }


    private _current: Panel;

    closeCurrent() {
        if (this._current)
            this.remove(this._current);
    }
}