import { Data } from './../../Data';
import { ICollectGoodData } from '../getCollectRule/ICollectGoodData';

/**
 *Created by ck on 2018/10/29
 * 集卡详情
 */
export class GetCollectGoodsInfoData extends Data {
    /**
     * 集卡列表
     */
    public collectGoods: ICollectGoodData[];

    /**
     * 奖品等级（几等奖）
     */
    public prizeLevel: number;

    /**
     * 是否可以开奖
     */
    public clickFlag: boolean;

    public update(data: any): void {
        if (!data) {
            return;
        }
        super.update(data);
        this.collectGoods = data.collectGoods;
        this.prizeLevel = data.prizeLeve;
        this.clickFlag = data.clickFlag;
    }

    /**
     * 根据集卡id获取详情
     * @param id 
     */
    public getCollectInfoByID(id: number): ICollectGoodData{
        for (const info of this.collectGoods) {
            if(info.id == id){
                return info;
            }
        }
        return null;
    }
}