"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataManager_1 = require("./../manager/DataManager");
// import { IExposureData } from '..';
var Buried = (function () {
    function Buried() {
    }
    /**
     * 初始化
     */
    Buried.init = function () {
        if (DataManager_1.DataManager.ins.gameCfgData) {
            this.appId = DataManager_1.DataManager.ins.gameCfgData.appInfo.appId;
            this.consumerId = DataManager_1.DataManager.ins.getInfoData.consumerId;
            this.oaId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
        }
        else if (DataManager_1.DataManager.ins.customCfgData) {
            this.appId = DataManager_1.DataManager.ins.customCfgData.appId;
            this.consumerId = DataManager_1.DataManager.ins.customCfgData.consumerId;
            this.oaId = DataManager_1.DataManager.ins.customCfgData.oaId;
        }
        else if (DataManager_1.DataManager.ins.petIndexData && DataManager_1.DataManager.ins.petIndexData.appId && DataManager_1.DataManager.ins.petIndexData.activityId) {
            this.appId = DataManager_1.DataManager.ins.petIndexData.appId;
            this.consumerId = DataManager_1.DataManager.ins.petIndexData.consumerId;
            this.oaId = DataManager_1.DataManager.ins.petIndexData.activityId;
        }
        else if (DataManager_1.DataManager.ins.petsIndexData && DataManager_1.DataManager.ins.petsIndexData.appId && DataManager_1.DataManager.ins.petsIndexData.activityId) {
            this.appId = DataManager_1.DataManager.ins.petsIndexData.appId;
            this.consumerId = DataManager_1.DataManager.ins.petsIndexData.consumerId;
            this.oaId = DataManager_1.DataManager.ins.petsIndexData.activityId;
        }
    };
    /**
     * 创建dpm埋点数据
     * @param {string} dpm 点击埋点
     * @param {string} dcm 曝光埋点
     * @param {string} embedDomain 埋点域名
     * @returns {{dpm: string; consumerId: number; domain: string; appId: number}}
     */
    Buried.createExposure = function (dpm, dcm, embedDomain) {
        if (embedDomain === void 0) { embedDomain = '//embedlog.duiba.com.cn'; }
        var exposure = {
            dpm: dpm,
            dcm: dcm,
            consumerId: Buried.consumerId,
            appId: Buried.appId,
            domain: embedDomain
        };
        return exposure;
    };
    /**
     * dpm拼接
     * @param pageId 页面ID
     * @param area 区域
     * @param dpm 埋点号
     * @returns {string}
     */
    Buried.connectDpm = function (pageId, area, dpm) {
        return Buried.appId + '.' + pageId + '.' + area + '.' + dpm;
    };
    /**
     * dcm拼接
     * @param typeId 类型ID
     * @param contentInfo 内容信息
     * @param dcm 埋点号
     * @returns {string}
     */
    Buried.connectDcm = function (typeId, contentInfo, dcm) {
        return typeId + '.' + Buried.oaId + '.' + contentInfo + '.' + dcm;
    };
    /**
     * 插件dcm拼接
     * @param plugId 插件ID
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    Buried.connectPlugDcm = function (plugId, type) {
        return 212 + '.' + plugId + '.' + type + '.' + Buried.oaId;
    };
    /**
     * 活动dcm拼接
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    Buried.connectActivityDcm = function (type) {
        return 202 + '.' + Buried.oaId + '.' + type + '.' + Buried.oaId;
    };
    return Buried;
}());
exports.Buried = Buried;
__reflect(Buried.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/gameegret20181011/db-game-template/egret/libs/tw/util/Buried\".Buried");
//# sourceMappingURL=Buried.js.map