import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { GCache } from '../../libs/tc/util/GCache';
import { FriendItemComponent } from '../components/FriendItemComponent';
import { NetName } from '../../libs/tw/enum/NetName';
import DataConversion from '../mainScene/DataConversion';
export default class TeamScene extends Scene {

    public topCention:eui.Group;
    public frendCountText:eui.Label;
    public extraRateText:eui.Label;
    public backBtn:eui.Button;
    public addFrendBtn:eui.Button;
    public showListGroup:eui.Group;
    

    public mainbg:eui.Image;

    public get skinKey() { return 'TeamScene' }
    public get groupName() { return 'team_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    Events=[]

    initEvents() {
        super.initEvents();
        this.addFrendBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
    }

    removeEvents() {
        super.removeEvents();
        this.addFrendBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addFrendBtn, this);
        this.backBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_backBtn, this);
        
         //删除子项事件
        this.clearList()
    }

    clearList(){
        clearInterval(this.Events["setTimes"])
        this.dItems.forEach((data,i)=>{
            this.showListGroup.removeChild(this.dItems[i])
        })
    }

    onTap_addFrendBtn(){

    }

    onTap_backBtn(){

    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('team_bg_jpg');
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        this.initUI();
    }

    private datas
    dItems=[]

    private initUI():void{
       
        this.datas = DataManager.ins.getData(NetName.GET_TEAMINFO).data;
        console.log(this.datas)
        this.clearList()
        this.resetList()
    }

    resetList(){
        let orgX = 41;
        let space = 10;
        this.datas.member.forEach((data,i)=>{
            this.dItems[i] = new FriendItemComponent(data.avatar,data.nickName,DataConversion.doConversion(data.remainingTime/this.datas.member.length)+"/秒",this.secondToDate(data.remainingTime));
            this.overTimes[i]=data.remainingTime*1000+Date.now();
            this.showListGroup.addChild(this.dItems[i]);
            this.dItems[i].y = i * (132 + space);
        })
        this.setTimes()
        this.Events["setTimes"]=setInterval(()=>{
            this.setTimes()
        },1000)
    }

    overTimes=[]

    setTimes(){
        this.datas.member.forEach((data,i)=>{
            this.clearList()
            if(this.overTimes[i]-Date.now()<=0){
                NetManager.ins.getTeamInfo((succuss)=>{
                    if (!succuss) {
                        return;
                    }
                    this.resetList()
                })
            }else{
                this.dItems[i].setTime(this.secondToDate((this.overTimes[i]-Date.now())/1000))
            }
        })
    }

    // 输出03:05:59  时分秒
    secondToDate(result) {
        var h = Math.floor(result / 3600) < 10 ? '0'+Math.floor(result / 3600) : Math.floor(result / 3600);
        var m = Math.floor((result / 60 % 60)) < 10 ? '0' + Math.floor((result / 60 % 60)) : Math.floor((result / 60 % 60));
        var s = Math.floor((result % 60)) < 10 ? '0' + Math.floor((result % 60)) : Math.floor((result % 60));
        return result = h + ":" + m + ":" + s;
    }

}
