import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { GCache } from '../../libs/tc/util/GCache';
export default class StartScene1 extends Scene {
    public startBtn:eui.Button;
    public musicBtn:eui.Button;

    public titleGroup:eui.Group;

    public titleAct:egret.MovieClip;

    public dog1:eui.Image;
    public dog2:eui.Image;
    public dog3:eui.Image;
    

    // 用于控制全局音乐是否播放和音乐按钮状态
    public static isPlayMusic: boolean = true;

    public mainbg:eui.Image;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        // this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        // this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        // this.musicBtn.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTap_musicBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        // this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        // this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        // this.musicBtn.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTap_musicBtn, this);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('startBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

        var mcJson = await RES.getResAsync('titleMc_json');
        var mcImg = await RES.getResAsync('titleMc_png');
        var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        this.titleAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        
        this.initUI();
    }

    private initUI():void{
        // egret.Tween.get(this.startBtn, {loop:true})
        //     .to({scaleX:1.05, scaleY:1.05}, 150)
        //     .to({scaleX:0.9, scaleY:0.9}, 150)
        //     .to({scaleX:1.05, scaleY:1.05}, 150)
        //     .to({scaleX:0.9, scaleY:0.9}, 150).wait(500);

        egret.Tween.get(this.startBtn, {loop:true})
        .to({scaleX:0.9, scaleY:1.1}, 170)
        .to({scaleX:1, scaleY:1}, 160)
        .to({scaleX:0.95, scaleY:1.05}, 170)
        .to({scaleX:1, scaleY:1}, 170).wait(500);
        
        // egret.Tween.get(this.musicBtn, {loop:true}).to({rotation:360}, 2000);

        let d1x = this.dog1.x;
        let d1y = this.dog1.y;
        egret.Tween.get(this.dog1, {loop:true}).to({x:d1x + 5, y:d1y - 5}, 1000).to({x:d1x, y:d1y}, 1000);

        let d2x = this.dog2.x;
        let d2y = this.dog2.y;
        egret.Tween.get(this.dog2, {loop:true}).to({x:d2x - 5, y:d2y - 5}, 1000).to({x:d2x, y:d2y}, 1000);

        let d3x = this.dog3.x;
        let d3y = this.dog3.y;
        egret.Tween.get(this.dog3, {loop:true}).to({y:d3y - 5}, 1000).to({y:d3y}, 1000);

        this.titleGroup.addChild(this.titleAct);
        setTimeout(() => {
            this.titleAct.gotoAndPlay(0);
        }, 200);
    }

    private onTap_ruleBtn():void{
        console.log('点击rule');
        // PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL); 
    }

    private onTap_startBtn():void{
        PanelCtrl.instance.btnDelay(this.startBtn);
        NetManager.ins.getHome((succuss) => {
			if (!succuss) {
				return;
			}
            SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
		}, this.getQueryString("dailyMark"), window["CFG"].activityId)
    }

    getQueryString(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) return unescape(r[2]);
        return null;
    };

    private onTap_musicBtn():void{
        console.log('点击musicBtn');
        PanelCtrl.instance.btnDelay(this.musicBtn);

        StartScene1.isPlayMusic = !StartScene1.isPlayMusic;
        if(StartScene1.isPlayMusic){
            this.musicBtn.currentState = 'up';
            this.setMusicBtnAct(true);
            window['musicPlay'](true);
        }else{
            this.musicBtn.currentState = 'disabled';
            window['musicPlay'](false);
            this.setMusicBtnAct(false);
        }
    }

    private setMusicBtnAct(isStop:boolean):void{
        if(isStop){
            egret.Tween.resumeTweens(this.musicBtn);
        }else{
            egret.Tween.pauseTweens(this.musicBtn);
        }
    }

    private onTap_prizeBtn():void{
        console.log('点击prizeBtn'); 
        // PanelCtrl.instance.btnDelay(this.prizeBtn);
        window.location.href = this.gotoRecord();//window["recordUrl"];
    }

    //获取我的奖品
    private gotoRecord():string{
        let recordUrl: string;
        let oaId: number;
        if (DataManager.ins.customCfgData) {
            oaId = DataManager.ins.customCfgData.oaId;
            recordUrl = DataManager.ins.customCfgData.recordUrl;
        } else {
            oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
            recordUrl = window['recordUrl'];
        }

        if(recordUrl.indexOf('?') != -1){
            recordUrl += '&origins=' + oaId + '00';
        }else{
            recordUrl += '?origins=' + oaId + '00';
        } 
        // recordUrl += ',' + (window['plugId'] ? window['plugId'] : 4500) + '01';

        // for(let i = 0; i < window['plugIdArr'].length; i++){
        //     recordUrl += ',' + window['plugIdArr'][i] + '01';
        // }

        return recordUrl;
    }

    //循环播放动画
	private playAnimation(target: egret.tween.TweenGroup, isLoop: boolean = true): void {
		if (isLoop) {
			for (var key in target.items) {
				target.items[key].props = { loop: true };
			}
		}
		target.play();
    }
    

}
