import { NetName } from './../../libs/tw/enum/NetName';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export default class SignSucPanel extends Panel {
    public get skinKey() { return "SignSuc" }
    public get groupName() { return "signSuc_Panel" }

    public closeBtn: eui.Button;
    public statusTitle: eui.Label;
    public acceptBtn: eui.Button;
    public prizeTips: eui.Label;
    public prizeImg: eui.Image;
    public prizeNum: eui.Label;
    public prizeNum1: eui.Label;
    public prizeNum0: eui.Label;



    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onLoad() {
        const num = DataManager.ins.getData(NetName.SING_SUCCESS).data;

        if (!num) {
            return
        }

        this.prizeNum0.text = `${num}`;
        this.prizeNum1.text = `${num}`;
    }
}