import Panel from "../views/Panel";
import { DogShopItemComponent } from "../components/DogShopItemComponent";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import DogData from "../startScene/DogData";
import DataConversion from "../mainScene/DataConversion";
import NetConst from "../NetConst";
export default class ShopPanel extends Panel {

    public closeBtn: eui.Image;
    public petsList: eui.Group;


    public get skinKey() { return 'ShopPanel' }
    public get groupName() { return 'shop_panel' }

    private callback: Function;
    constructor(data) {
        super(data);
        this.percentHeight = 100;
    }


    protected onSkinComplete(): void {
        super.onSkinComplete();

        console.log('this.height', this.height)

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onLoad() {
        this.initUI();
    }

    initUI() {

        if (!DataManager.ins.getData("callPetsList")) {
            NetConst.callPetsList((s) => {
                if (!s) {
                    return
                }
                const heightArr = [84, 93, 125, 142, 148, 126, 123, 141, 150, 156]
                let list = DataManager.ins.getData("callPetsList").data
                for (let i = 1; i <= list.length; i++) {
                    let item = new eui.Component();
                    let x, y;
                    item.skinName = `CPItemSkin`;

                    item['petInfo']['petName'].text = DataConversion.dogLvIndex[list[i - 1].level - 1] + DataConversion.dogLvLists[list[i - 1].level - 1] + "";
                    item['petInfo']['petImg'].source = `dog_lv_${list[i - 1].level}_png`;
                    item['petInfo']['petNum'].text = `${list[i - 1].cnt}`
                    item.name = "CallLv" + list[i - 1].level;

                    item['callBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_callBtn, this);
                    x = 50 + (i - 1) % 3 * 200;
                    y = 34 + Math.floor((i - 1) / 3) * 224;
                    item.x = x;
                    item.y = y;
                    item['petInfo']['petImg'].scaleX = 0.8;
                    item['petInfo']['petImg'].scaleY = 0.8;
                    item['petInfo']['petImg'].anchorOffsetY = heightArr[list[i - 1].level - 1];
                    this.petsList.addChild(item);


                }

            }, window['CFG'].activityId)
        } else {
            const heightArr = [84, 93, 125, 142, 148, 126, 123, 141, 150, 156]
            let list = DataManager.ins.getData("callPetsList").data
            for (let i = 1; i <= list.length; i++) {
                let item = new eui.Component();
                let x, y;
                item.skinName = `CPItemSkin`;

                item['petInfo']['petName'].text = DataConversion.dogLvIndex[list[i - 1].level - 1] + DataConversion.dogLvLists[list[i - 1].level - 1] + "";
                item['petInfo']['petImg'].source = `dog_lv_${list[i - 1].level}_png`;
                item['petInfo']['petNum'].text = `${list[i - 1].cnt}`
                item.name = "CallLv" + list[i - 1].level;

                item['callBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_callBtn, this);
                x = 50 + (i - 1) % 3 * 200;
                y = 34 + Math.floor((i - 1) / 3) * 230;
                item.x = x;
                item.y = y;
                item['petInfo']['petImg'].scaleX = 0.8;
                item['petInfo']['petImg'].scaleY = 0.8;
                item['petInfo'].maskRect.scaleY = 0.8;
                if(item['petInfo'].maskRect){
                    item['petInfo'].maskRect.alpha=0;
                }
                item['petInfo']['petImg'].anchorOffsetY = heightArr[list[i - 1].level - 1];
                this.petsList.addChild(item);


            }
        }
    }


    onTap_callBtn(e) {
        if (e.target.$parent.$name && e.target.$parent.$name.indexOf("CallLv") >= 0) {
            this.hidePanel();
            GDispatcher.dispatchEvent("doSummon", Number(e.target.$parent.$name.split("CallLv")[1]));
        }
    }
    // public initEvents():void{
    //     super.initEvents();
    // }

    // private onTap():void{
    //     if(this.callback){
    //         this.callback();
    //     }
    //     this.hidePanel();
    // }

    // public removeEvents():void{
    //     super.removeEvents();
    //     //删除子项事件
    //     for(let i = 0; i < 30; i++){
    //         var item:any = this.showListGroup.getChildAt(i);
    //         item.removeEvent();
    //     }
    // }

    // private onLoad(): void {
    //     this.initData();
    //     this.initUI();
    // }

    // private initUI():void{//6b4838   515151
    //     let orgX = 41;
    //     let space = 10;
    //     let dataArr = DataManager.ins.shopYunjiData.data;
    //     for(let i = 0; i < 30; i++){
    //         let dname;
    //         let lock;
    //         if(!dataArr[i].lock){
    //             dname = 'dog_lv_' + (i + 1) + '_png';
    //             lock = false;
    //         }else{
    //             dname = 'dog' + i + '_png';
    //             lock = true;
    //         }
    //         let dItem = new DogShopItemComponent(i + 1, DogData.getNameData[i], dname, DogData.getSizeData[i], dataArr[i], this.buyBack.bind(this));
    //         this.showListGroup.addChild(dItem);

    //         dItem.x = orgX;
    //         dItem.y = i * (162 + space);

    //     }

    //     this.foodNumLb.text = DataConversion.doConversion(this.foodStocks);
    // }

    // //商店购买回调
    // private buyBack(lv:number):void{
    //     GDispatcher.dispatchEvent("doSummon", lv);
    // }

    // private initData():void{}

}