// import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { HtmlTextParser } from "../../libs/tc/util/HtmlTextParser";
export default class RulePanel extends Panel {
    public ruleGroup:eui.Group;
    public ruleLb:eui.Label;
    public okBtn:eui.Button;

    public get skinKey() { return 'Rule' }
    public get groupName() { return 'rule_panel' }

    constructor(data: any) {
        super(data);
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        // this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents(): void {
        super.removeEvents();
        // this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }


    rule=`
一、玩家通过移动合并同等级萌宠，召唤高一等级的萌宠；
二、从第5等级萌宠开始，每召唤到新一级萌宠，都有对应奖励下发：
五级猫猫：10豆券
六级猫猫：20豆券
七级猫猫：30豆券
八级猫猫：40豆券
九级猫猫：50豆券
十级猫猫：免费阅读会员卡一张

三、除召唤新等级萌宠得奖外，排行榜前十名用户还可领取超值开学大礼包，礼包如下：
第一名：联想电脑thinkpad
第二名：华为手机p20
第三名：switch游戏机
第四名：索尼耳机
第五名：ps4游戏机
第六名：X-box游戏手柄
第七名：拍立得
第八名：小米手环+dior口红
第九名：小米移动电源+dior口红
第十名：罗技鼠标+dior口红

四、如何召唤萌宠：每人每日可免费领取5只免费1级萌宠萌宠，想获得更多萌宠，玩家可通过签到兑换，阅读时长兑换，或邀请好友兑换，具体如下：
签到1次：1只1级萌宠
邀请好友：邀请成功1次兑换1只2级萌宠(每天最多邀请10位好友助力）
阅读时长：时长越多，兑换萌宠越多，每日从点击去阅读按钮开始，
①累计阅读30分钟内，每5分钟，可兑换一只1级萌宠；
②累计阅读30分钟至1小时，每5分钟，可兑换两只1级萌宠；
③累计阅读1小时以上，每5分钟，可兑换三只1级萌宠；
。。。。。。
每日通过阅读兑换的1级萌宠，最多88只。

五、本活动最终解释权归书旗小说所有`

    private onLoad():void{
        this.ruleLb.textColor = 0x2c2a29;
        this.ruleLb.stroke = 0;
       // this.ruleLb.textFlow = new HtmlTextParser().parse(DataManager.ins.ajaxElementData.rule);
        this.ruleLb.textFlow = new HtmlTextParser().parse(this.rule);
       // this.ruleLb.text = '活动主题：感恩母亲节 献花赢好礼\n\n活动玩法：\n\n从3种鲜花中选择其中一种给母亲献花，每次献花扣除9积分，点击选择花束后，小女孩手捧鲜花走向母亲，献花成功后直接抽奖，概率出奖，奖品有限，快来参与吧~\n\n活动奖品：\n18积分        概率：30%\n28积分        概率：10%\n38积分        概率：3%\n88积分        概率：2%\n188积分      概率：1%\n\n活动细则：\n\n1.每个会员可使用9积分参与1次游戏，参与后积分不予退回，次数不限。\n\n2.优惠券可在全国屈臣氏实体门店，消费购物结账时，出示相关的中奖奖品券码进行核销兑换。\n\n3.结果以“活动首页-我的奖励”或在屈臣氏“会员中心-积分乐园-兑换记录”中的中奖记录为准。\n\n4.券类奖品的使用规则详见每个优惠券的介绍页。\n\n5.实物类商品请凭券码到屈臣氏门店领取。\n\n6.在本次活动期间，如用户存在任何违反法律、法规、屈臣氏活动规则的行为，包括但不限于作弊得奖、恶意套现等行为，屈臣氏有权取消用户的中奖资格，收回所发奖品，要求用户将已享受的奖品退还屈臣氏，如奖品为实体奖品且用户已拆除外包装无法进行二次销售的，屈臣氏有权按照奖品的市场价格向用户追讨。\n\n7.本次活动规则如有调整，相关变动或调整将即时公布在本活动规则页面。\n\n8.活动期内，如遇兑换异常等不确定情况出现，请在活动结束后10个工作日内致电会员服务热钱：400 830 1310（自付市内话费）。\n\n9.此活动奖品数量有限，概率出奖，先到先得，祝好运～';
    }

    
}