import { DataManager } from './../../libs/tw/manager/DataManager';
import RankItem from "./RankItem";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import NetConst from '../NetConst';
import GameConst from '../GameConst';

export default class RankPanel extends Panel {
    public bg: eui.Image;
    public closeBtn: eui.Button;
    public scroller: eui.Scroller;
    public itemGroup: eui.Group;
    public list: eui.List;
    public prizeTime: eui.Label;
    public userRank: eui.Label;
    public userNickName: eui.Label;
    public userScore: eui.Label;
    public userPetImg: eui.Image;
    public num3: eui.Image;
    public num2: eui.Image;
    public num1: eui.Image;

    onSkinComplete() {
        super.onSkinComplete();
        if (!DataManager.ins.getData("rankList") || !DataManager.ins.getData("rankList").data)
            NetConst.getRankList((success: boolean) => {
                if (success) {
                    this.updatePanel();
                } else {
                    return
                }
            }, window["CFG"].activityId);

        else
            this.updatePanel();
    }

    updatePanel() {
        if (DataManager.ins.getData("rankList") && DataManager.ins.getData("rankList").data && DataManager.ins.getData("rankList").data.self) {
            const self = DataManager.ins.getData("rankList").data.self;
            this.userNickName.text = self.nickName;
            this.userRank.text = self.rank;
            if (self.rank < 3) {
                this[`num${self.rank}`].visible = true;
            }
            this.userScore.text = "x" + self.maxLevelCnt;
            let userPetsImgName = "dog_lv_1_png";
            if (self.maxLevel <= 10) {
                userPetsImgName = `dog_lv_${self.maxLevel}_png`;
            }
            this.userPetImg.source = userPetsImgName;


            if (DataManager.ins.getData("rankList").data.rankList) {
                this.list.useVirtualLayout = false;
                this.list.itemRenderer = RankItem;
                const ac = new eui.ArrayCollection(DataManager.ins.getData("rankList").data.rankList);
                this.list.dataProvider = ac;
            }


        } else {

            const self = DataManager.ins.getData("rankList").data.self;
            this.userNickName.text = self.nickName;
            this.userRank.text = self.rank;
            if (self.rank < 3) {
                this[`num${self.rank}`].visible = true;
            }
            this.userScore.text = "x" + self.maxLevelCnt;
            let userPetsImgName = "dog_lv_1_png";
            if (self.maxLevel <= 10) {
                userPetsImgName = `dog_lv_${self.maxLevel}_png`;
            }
            this.userPetImg.source = userPetsImgName;


            if (DataManager.ins.getData("rankList").data.rankList) {
                this.list.useVirtualLayout = false;
                this.list.itemRenderer = RankItem;
                const ac = new eui.ArrayCollection(DataManager.ins.getData("rankList").data.rankList);
                this.list.dataProvider = ac;
            }
        }

        setTimeout(() => {
            this.list.$children.forEach((rankItem) => {
                if (rankItem['userRankNum'].text == 1) {
                    rankItem['num1'].visible = true;
                } else if (rankItem['userRankNum'].text == 2) {
                    rankItem['num2'].visible = true;
                } else if (rankItem['userRankNum'].text == 3) {
                    rankItem['num3'].visible = true;
                }
            })
        }, 50)

        const time = new Date(DataManager.ins.getData("rankList").data.openPrizeTimestamp);
        this.prizeTime.text = `活动截止${GameConst.time.getMonth(time, false)}月${GameConst.time.getDay(time)}日${GameConst.time.getHour(time)}点开奖`;

    }

    // initEvents() {
    //     super.initEvents();
    //     this.acceptBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_acceptBtn, this);
    // }

    // onTap_acceptBtn() {
    //     // 领取大礼
    //     PanelCtrl.instance.show(ModuleTypes.BIGPRIZE_PANEL);
    // }

    // removeEvents() {
    //     super.removeEvents();
    //     this.acceptBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_acceptBtn, this)
    // }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn'], this['backBtn'], this['backBtn2']]
    }


    get skinKey() { return 'Rank' }

    public get groupName() { return "rank_Panel" }
}