
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetName } from '../../libs/tw/enum/NetName';
import Panel from "../views/Panel";
import Scene from '../views/Scene';

export default class OverPrizeScene extends Scene {
    public get skinKey() { return "Prize" }
    public get groupName() { return "prize_Scene" }

    public noPrizeGroup:eui.Group;
public noPrizeText:eui.Label;
public prizeGroup:eui.Group;
public takePrizeBtn:eui.Button;
public lastRankTxt:eui.Label;
public prizeImg:eui.Image;
public prizeTitle:eui.Label;



    private prize: any;
    private lastRank: any;
    private text: any;

    constructor(data) {
        super();
        const { lastRank, prize, callback,text} = data
        this.lastRank = lastRank;
        this.prize = prize;
        this.text = text;
    }

    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onLoad() {
        if (this.prize) {
            this.noPrizeGroup.visible = false;
            this.prizeGroup.visible = true;

            this.updatePrize();
        } else {
            this.prizeGroup.visible = false;
            this.noPrizeGroup.visible = true;
            this.noPrizeText.text=
        }
    }

    updatePrize() {
        this.prizeImg.source = this.prize.prizeImgUrl;
        this.prizeTitle.text = this.prize.prizeTitle;
        this.takePrizeBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_takePrizeBtn, this);

        this.lastRankTxt.text = "TOP " + this.lastRank;
    }

    onTap_takePrizeBtn() {
        window.location.href = `${this.prize.prizeLink}`
    }



}