import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { ABNetManager } from "../../libs/tc/manager/ABNetManager";
import FriendItem from "./FriendItem";
import { NetName } from "../../libs/tw/enum/NetName";
import DogItem from "./DogItem";
import DataConversion from "./DataConversion";
import SceneCtrl from "../ctrls/sceneCtrl";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
export default class MainScene extends Scene {

	public bg: eui.Image;
	public topGroup: eui.Group;
	public lvText: eui.Label;
	public recordBtn: eui.Button;
	public ruleBtn: eui.Button;
	public shareBtn: eui.Button;
	public rankBtn: eui.Button;
	public doglist_0: eui.Group;
	public doglist_1: eui.Group;
	public doglist_2: eui.Group;
	public doglist_3: eui.Group;
	public doglist_4: eui.Group;
	public doglist_5: eui.Group;
	public doglist_6: eui.Group;
	public doglist_7: eui.Group;
	public doglist_8: eui.Group;
	public doglist_9: eui.Group;
	public doglist_10: eui.Group;
	public doglist_11: eui.Group;
	public bottomGroup: eui.Group;
	public recycleBtn: eui.Button;
	public mapBtn: eui.Button;
	public shopBtn: eui.Button;
	public recycleText: eui.Label;
	public taskbtn_1: eui.Button;
	public taskbtn_2: eui.Button;
	public taskbtn_3: eui.Button;







	public starAn: egret.MovieClip;



	/* private dogLvLists=[

	]
 */


	public get skinKey() { return 'MainScene' }
	public get groupName() { return 'main_scene' }

	private teams = [];
	private doglists = [];
	constructor(data?) {
		super(data);
		if (data) {

		}
		this.percentHeight = 100;
	}

	dogPositions = []


	Events = []

	initEvents() {
		GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);
		this.mapBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_mapBtn, this);
		this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
		this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
		this.shopBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shopBtn, this);
		//this.teamBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_teamBtn, this);

		GDispatcher.addEvent("doSummon", this.Events["doSummon"] = this.doSummon1, this)
		GDispatcher.addEvent("doRecycle", this.Events["doRecycle"] = this.doRecycle, this)
		GDispatcher.addEvent("cancelRecycle", this.Events["cancelRecycle"] = this.cancelRecycle, this)
		GDispatcher.addEvent("mapBtnAn", this.Events["mapBtnSAn"] = this.mapBtnSAn, this)
		GDispatcher.addEvent("mapBtnAn", this.Events["mapBtnSAn"] = this.mapBtnSAn, this)

		for (let i = 0; i < 12; i++) {
			this.doglists[i] = new DogItem()
			this.doglists[i].x = -8;
			this.doglists[i].y = -40;
			this["doglist_" + i].addChild(this.doglists[i])
		}
		this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.touchBegin, this)
		this.addEventListener(egret.TouchEvent.TOUCH_END, this.touchEnd, this)
		this.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.touchMove, this)
		this.TouchScrollInit()
		//this.Events["updateIncome"] = setInterval(this.updateIncome.bind(this), 3000)
	}

	removeEvents() {
		GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);
		this.recordBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
		this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
		this.mapBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_mapBtn, this);
		this.shopBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shopBtn, this);
		//this.teamBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_teamBtn, this);

		GDispatcher.removeEvent("doSummon", this.Events["doSummon"], this)
		GDispatcher.removeEvent("doRecycle", this.Events["doRecycle"], this)
		GDispatcher.removeEvent("cancelRecycle", this.Events["cancelRecycle"], this)
		GDispatcher.removeEvent("mapBtnAn", this.Events["mapBtnSAn"], this)
		this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.touchBegin, this)
		this.removeEventListener(egret.TouchEvent.TOUCH_END, this.touchEnd, this)
		this.removeEventListener(egret.TouchEvent.TOUCH_MOVE, this.touchMove, this)
		clearInterval(this.Events["updateIncome"])
	}


	onTap_teamBtn() {
		console.log("ce")
		this.enabled = false;
		NetManager.ins.getTeamInfo((succuss) => {
			this.enabled = true;
			if (!succuss) {
				return;
			}
			SceneCtrl.instance.change(ModuleTypes.TEAM_SCENE)
		}, window["CFG"].activityId)
	}


	mapBtnSAn() {
		this.enabled = true;
		this["mapBtnS"].play(0)
	}


	private targetDog;
	private targetCatch;

	private from;
	private to;

	private fromId;
	private toId;

	private catchIndex

	private touchBegin(e) {
		/* if (!this.isCanMove()) {
			return false;
		} */
		this.targetDog = null;
		for (let i = 0; i < 12; i++) {
			let target = this["doglist_" + i]
			if (target.canMove) {
				if (
					e.stageX >= target.x && e.stageX <= (target.x + target.width) &&
					e.stageY >= target.y + this.y && e.stageY <= (target.y + this.y + target.height)
				) {
					this.from = i
					this.setFromId(i)
					this.targetCatch = {
						x: target.x,
						y: target.y,
					}
					this.targetDog = target
					this.catchIndex = this.getChildIndex(this.targetDog);
					this.setChildIndex(this.targetDog, 40);
				}
			}
		}
		if (this.targetDog == null) {
			this.this_TouchBegin(e)
		}

	}

	setFromId(index) {
		for (let i = 0; i < this.petData.length; i++) {
			if (index == this.petData[i].holeIndex) {
				this.fromId = this.petData[i].id
			}
		}
	}

	setToId(index) {
		for (let i = 0; i < this.petData.length; i++) {
			if (index == this.petData[i].holeIndex) {
				this.toId = this.petData[i].id
			}
		}
	}

	private bgtexture: egret.Texture;
	private music_add_dog: egret.Sound
	private music_recycle: egret.Sound
	private music_food: egret.Sound
	private music_newdog: egret.Sound

	protected async preLoadRes() {
		//加载背景并设置背景图片
		this.bgtexture = await RES.getResAsync('main_Bg_jpg');
		// console.log('载背景并设置背景图片mainscene');

		var mcJson = await RES.getResAsync('main_star_an_json');
		var mcImg = await RES.getResAsync('main_star_an_png');
		var mcImg = await RES.getResAsync('main_star_an_png');

		this.music_add_dog = await RES.getResAsync("music_add_dog_mp3");
		this.music_recycle = await RES.getResAsync("music_recycle_mp3");
		this.music_food = await RES.getResAsync("music_food_mp3");
		this.music_newdog = await RES.getResAsync("music_newdog_mp3");

		//sound.play(0,1);

		var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

		this.starAn = new egret.MovieClip(mcFactory.generateMovieClipData());

		return new Promise(function (resolve, reject) {
			resolve();
		});
	}

	private isHover = false

	private touchMove(e) {

		/* 	if (!this.isCanMove()) {
				return false;
			} */
		if (this.targetDog == null) {
			this.this_TouchMove(e)
		} else if (this.targetDog) {
			this.targetDog.x = e.stageX - (80)
			this.targetDog.y = e.stageY - (60) - this.y
			var _x = this.bottomGroup.x + this.recycleBtn.x - this.bottomGroup.width / 2
			var _y = this.bottomGroup.y + this.y + this.recycleBtn.y - this.bottomGroup.height / 2
			if (
				e.stageX >= _x &&
				e.stageX <= _x + this.bottomGroup.width &&
				e.stageY >= _y &&
				e.stageY <= _y + this.bottomGroup.height
			) {
				console.log("进入回收区域")
				if (!this.isHover) {
					this.isHover = true;
					this["recycleHover"].play(0)
				}

			} else {
				if (this.isHover) {
					this.isHover = false;
					this["recycleOut"].play(0)
				}
			}

		}
	}

	//执行销毁
	doRecycle(holeIndex) {
		this.music_recycle.play(0, 1)
		NetManager.ins.getRecycle((succuss) => {
			if (!succuss) {
				this.enabled = true;
				this.updateDogList(false)
				return;
			}
			this.resetData(() => {
				this.enabled = true;
				this.updateIndex()
			})

		}, this.fromId, window["CFG"].activityId)
	}

	//刷新阅读邀请任务
	doRefreshReward(){
		
		NetManager.ins.refreshReward((succuss) => {
			if (!succuss) {
				this.enabled = true;
				return;
			}
			NetManager.ins.getRewardStatus((succuss) => {
				this.enabled = true;
				if (!succuss) {
					return;
				}

			},window["CFG"].activityId,DataManager.ins.getData(NetName.REFRESH_REWARD).data,()=>{
				return DataManager.ins.getData(NetName.GET_REWARD).data.result == 0;
			})

		},window["CFG"].activityId)
	}

	cancelRecycle() {
		this.updateDogList(false)
	}


	private touchEnd(e) {

		/* if (!this.isCanMove()) {
			return false;
		} */



		if (this.targetDog == null) {
			this.this_TouchEnd(e)
		} else if (this.isHover) {
			this.isHover = false;
			this["recycleOut"].play(0)
			console.log("执行回收")

			if (this.gameData.petList.length <= 5) {
				this.showToast("场上狗狗低于6只，不能再回收了")
				//this.updateDogList(false)
				egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(() => {
					this.enabled = true;
				});
			} else {
				this.openRecyclePanel(this.from)
			}

			this.addChild(this.bottomGroup)

			this.enabled = true;
			this.targetDog = null;
			return false;
		}


		for (let i = 0; i < this.dogPositions.length; i++) {
			let target = this.dogPositions[i]
			if (
				e.stageX >= target.x && e.stageX <= (target.x + target.width) &&
				e.stageY >= target.y + this.y && e.stageY <= (target.y + this.y + target.height)
			) {
				if (this.targetDog) {
					this.setChildIndex(this.targetDog, this.catchIndex);
					this.enabled = false;
					this.to = i
					this.setToId(i)
					if (this.locationData.indexOf(this.to) == -1) {
						egret.Tween.get(this.targetDog).to({ x: this.dogPositions[i].x, y: this.dogPositions[i].y }, 500).call(() => {
							//移动位置
							this.doLocation()
						})
						this.targetDog = null;
						this.addChild(this.bottomGroup)
					} else {
						var lvFrom;
						var lvTo;
						for (let j = 0; j < this.petData.length; j++) {
							if (this.from == this.petData[j].holeIndex) {
								lvFrom = this.petData[j].level;
							}
							if (this.to == this.petData[j].holeIndex) {
								lvTo = this.petData[j].level;
							}
						}
						if (lvFrom == lvTo && this.from != this.to) {
							if (lvFrom < 10 || lvTo < 10) {
								egret.Tween.get(this.targetDog).to({ x: this.dogPositions[i].x, y: this.dogPositions[i].y }, 100).call(() => {
									//合并
									console.log(lvFrom)
									console.log(lvTo)

									var x = this["doglist_" + this.from].x
									egret.Tween.get(this["doglist_" + this.to]).to({ x: x - 50 }, 150).to({ x: x }, 150).call(() => {
									})
									egret.Tween.get(this["doglist_" + this.from]).to({ x: x + 50 }, 150).to({ x: x }, 150).call(() => {
										this.doMerge(lvFrom)
									})
								})
							} else {
								this.showToast("已达到最高等级！")
								egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(() => {
									this.enabled = true;
								});
							}
							this.targetDog = null;
							this.addChild(this.bottomGroup)
						} else {
							egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(() => {
								this.enabled = true;
							});
							this.targetDog = null;
							this.addChild(this.bottomGroup)
						}
					}
				}
				return
			}
		}
		if (this.targetDog) {
			this.enabled = false;
			egret.Tween.get(this.targetDog).to({ x: this.targetCatch.x, y: this.targetCatch.y }, 500, egret.Ease.quartOut).call(() => {
				this.enabled = true;
			})
			this.targetDog = null;
			this.addChild(this.bottomGroup)
		}
	}

	stageYBegin = 0
	stageYBegin2 = 0
	stageYMove = 0
	stageYEnd = 0

	moveHeight = 0
	rHeight = 0

	TouchScrollInit() {
		var scaleN = this.width / window.innerWidth;
		var stageHeight = window.innerHeight * scaleN
		this.rHeight = this.height - stageHeight
		console.log(this.rHeight)
	}

	this_TouchBegin(e) {
		//this.rHeight
		console.log("this_TouchBegin")
		console.log(e.stageY)
		this.stageYBegin = e.stageY - this.y
		this.stageYBegin2 = e.stageY
		this.moveHeight = 0;
	}

	this_TouchMove(e) {
		//this.rHeight
		console.log("this_TouchMove")
		console.log(e.stageY)
		this.stageYMove = e.stageY
		this.y = this.stageYMove - this.stageYBegin
	}

	this_TouchEnd(e) {
		//this.rHeight
		console.log("this_TouchEnd")
		console.log(e.stageY)
		this.stageYEnd = e.stageY
		if (this.y > 0) {
			// this.y = 0
			var tw = egret.Tween.get(this, { onChange: this.enterFrame.bind(this) });
			tw.to({ y: 0 }, 200, egret.Ease.circOut);
		} else if (this.y < -this.rHeight) {
			//this.y=-this.rHeight
			var tw = egret.Tween.get(this, { onChange: this.enterFrame.bind(this) });
			tw.to({ y: -this.rHeight }, 200, egret.Ease.circOut);
		}

		this.moveHeight = this.stageYBegin2 - this.stageYEnd
		console.log("this.moveHeight")
		console.log(this.moveHeight)
	}

	enterFrame() {
		/*  this.jk_box.bottom=this.y+10
		 this.shareBox.bottom=this.y */
	}

	showToast(val) {
		//console.log(val)
		TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: val });
	}


	//更新收入+增加积分
	/* updateIncome() {
		this.dogRate()
		this.foodStocks += (this.yieldRate * 3);
		this.updateAllTextFromLocalCount()
		this["foodUpdate"].play(0)
	} */



	private addLocation

	locationData = []

	onTap_addDogBtn() {

		this.music_add_dog.play(0, 1)
		this.enabled = false;
		this.doSummonCount = 0
		if (this.gameData.petList.length >= 12) {
			this.enabled = true;
			this.showToast("空间不足，请合成或拖到右下角回收")
			return
		}
		//this.doSummon(this.homeData.summonLevel)
		this.doSummon(this.indexData.summonLevel)
	}


	doSummonCount = 0





	doSummon1(level) {
		this.doSummonCount = 0
		this.doSummon(level)
	}

	//召唤狗狗
	doSummon(level) {

		if (this.gameData.petList.length >= 12) {
			this.enabled = true;
			this.showToast("空间不足，请合成或拖到右下角回收")
			return
		}

		//if (this.homeData.summonConsume <= this.foodStocks) {
		for (let i = 0; i < 12; i++) {
			if (this.locationData.indexOf(i) == -1) {
				this.addLocation = i
				break;
			}
		}
		console.log(this.addLocation)
		this.enabled = false;
		NetManager.ins.getSummon((succuss) => {
			if (!succuss) {
				this.doSummonCount++
				if (this.doSummonCount == 1) {
					this.doSummonBeforeHome(level)
				}
				if (this.doSummonCount >= 2) {
					this.enabled = true;
				}
				return;
			}

			this.doSummonCount = 0
			setTimeout(() => {
				this.resetData(() => {
					console.log(DataManager.ins.getData(NetName.GET_SUMMON).data)
					this.enabled = true;
					this.updateIndex(true)
				})
				console.log("召唤成功")
			}, 50)

		}, level, window["CFG"].activityId, this.addLocation)
		/* } else {
			this.enabled = true;
			this.openNoCreditsPanel()
		} */
	}


	private doSummonBeforeHome(level) {
		NetManager.ins.getIndex((succuss) => {
			if (!succuss) {
				return;
			}
			this.enabled = true;
			this.doSummon(level)
			this.updateIndex(true)
		}, this.getQueryString("dailyMark"), window["CFG"].activityId)
	}

	private onError(net: any, desc: any, result): void {
		console.log(desc);
		console.log(result);
		var msg: string;
		var msgArr: any = window['errorMessage'];
		if (!isNaN(desc)) {
			msg = msgArr[desc] ? msgArr[desc] : '额哦，一个未知的错误';
		} else {
			msg = desc;
		}
		var code = result.code;
		if (code == "0800108") {
			this.showToast("场上狗狗低于6只，不能再回收了");
		} else if (code == "0800101") {
			this.showToast("网络异常");
		} else if (code == "0800104") {
			this.showToast("该位置没有狗狗,请刷新页面");
		} else if (code == "0800105") {
			this.showToast("召唤位置已有狗狗,请刷新页面");
		} else if (code == "0800106") {
			//this.showToast("狗粮不足，请晚会再来");

			if (this.doSummonCount == 2) {
				this.enabled = true;
				console.log("狗粮不足，请晚会再来")
				this.openNoCreditsPanel()
				this.updateDogList(false)
			}
		} else if (code == "0800108") {
			this.showToast("场上狗狗低于6只，不能再回收了");
		} else if (code == "0800107") {
			//this.showToast("合并6级以上狗狗，请先关注公众号");
			this.openHowToGetPrizePanel()
		} else if (code == "0800103") {
			this.showToast("狗狗等级位置不符，不能合并");
		} else if (code == "0800102") {
			this.showToast("狗狗已是最高等级，不能合并");
		} else if (code == "0800101") {
			this.showToast("活动太火爆了，请稍后再来～");
		} else if (code == "0300007") {
			this.showToast("操作过于频繁");
		} else if (code == "300302") {
			this.showToast("好友成员已满,请稍后再来吧");
		} else if (code == "300301") {
			this.showToast("活动期间仅可助力一次");
		} else {
			this.showToast(desc);
		}
	}

	firstTipsCoun = 0

	protected onSkinComplete(): void {


		//最大等级
		this.maxLevel = 0
		//生产速率
		this.yieldRate = 0
		//粮食库存
		this.foodStocks = 0

		this.recycleIncome = 0

		this.firstTipsCoun = 0

		super.onSkinComplete();
		this.updateIndex()
		this.openWinFrist(0)

		this.bg.texture = this.bgtexture;


		//setTimeout(() => {
		this.addChild(this.starAn);
		this.starAn.touchEnabled = false;
		this.starAn.gotoAndPlay(0);
		this.starAn.visible = false;

		this.isHover = false;


		//}, 2000);
	}

	openWinFrist(index) {
		if (this.indexData.subscribe == false && index == 4) {
			this.openHowToGetPrizePanel()
		} else if (index == 4) {
			this.openWinFrist(5)
		}

		if (this.indexData.dailyBonus && index == 0) {
			this.openPrizePanel(this.indexData.dailyBonus)
		} else if (index == 0) {
			this.openWinFrist(2)
		}

		if (this.indexData.hasNewMember && index == 3) {
			this.openOfflineFriendPanel(this.indexData.length)
		} else if (index == 3) {
			this.openWinFrist(4)
		}

		if (this.indexData.offlineDuration && index == 5) {
			this.openOfflinePanel(this.indexData.offlineProfit, this.indexData.offlineDuration, this.indexData.maxValidOffLineSecond)
		} else if (index == 5) {
			this.openWinFrist(6)
		}

		if (index == 7) {
			//this.updateYdTips()
		}

		if (this.indexData.newBonus && index == 2) {
			this.openNewUserPrizePanel(this.indexData.newBonus)
		} else if (index == 2) {
			this.openWinFrist(3)
		}

		if (this.getQueryString("shareCode") && index == 6) {
			NetManager.ins.joinTeam((success) => {
				if (!success) {
					return
				}
				NetManager.ins.getIndex((succuss) => {
					if (!succuss) {
						return;
					}
					this.updateIndex2()
				}, this.getQueryString("dailyMark"), window["CFG"].activityId)
				this.openJoinSuccessPanel(DataConversion.doConversion(DataManager.ins.getData(NetName.JOINTEAM).data))
			}, this.getQueryString("shareCode"), window["CFG"].activityId)
		} else if (index == 6) {
			this.openWinFrist(7)
		}
	}

	getQueryString(name) {
		var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
		var r = window.location.search.substr(1).match(reg);
		if (r != null) return unescape(r[2]);
		return null;
	};

	showStarAn(position) {
		this.starAn.visible = true;
		this.starAn.x = position.x - 130;
		this.starAn.y = position.y - 120;
		this.starAn.gotoAndPlay(0);
	}

	//home数据
	indexData
	//game数据
	gameData
	//狗狗列表输数据
	petData
	//回收收益
	recycleIncome

	updateIndex(state?) {
		this.indexData = DataManager.ins.getData(NetName.GET_INDEX).data;
		this.gameData = DataManager.ins.getData(NetName.GET_GAMEZONE).data;


		if (this.indexData) {
			if (this.indexData.signFlag) {
				this.taskbtn_1.enabled = false;
			} else {
				this.taskbtn_1.enabled = true;
			}
		}

		if (this.gameData) {
			this.petData = this.gameData.petList
			if (state) {
				//如果state是真，则对最后一名效果添加入场动画
				this.updateDogList(true)
			} else {
				this.updateDogList(false)
			}

			this.updateAllTextFromHome()

			this.firstTipsCoun = 2;
		}

	}

	updateIndex2(state?) {
		this.gameData = DataManager.ins.getData(NetName.GET_GAMEZONE).data;
		if (this.gameData) {

			this.petData = this.gameData.petList

			if (state) {
				//如果state是真，则对最后一名效果添加入场动画
				this.updateDogList(true)
			} else {
				this.updateDogList(false)
			}
			this.updateAllTextFromHome()
		}
	}

	isCanMove() {
		let state = true;
		if (this.petData.length == 1) {
			if (this.petData[0].level == 1) {
				state = false;
			}
		}
		return state
	}

	//合并
	doMerge(currentLevel) {
		this.enabled = false;
		NetManager.ins.getMerge((succuss) => {
			if (!succuss) {
				this.enabled = true;
				this.updateIndex()
				return;
			}
			this.resetData(() => {
				setTimeout(() => {
					this.enabled = true;
					this.updateIndex()
					this.showStarAn({ x: this.dogPositions[this.to].x, y: this.dogPositions[this.to].y })
					this.maxLevel = this.gameData.maxLevel;
					if (!localStorage.maxLevel) {
						console.log("获得一直新狗")
						console.log(this.maxLevel)
						this.openNewDogShowPanel(this.maxLevel, this.gameData.petList.length)
					} else {
						if (this.maxLevel > parseInt(localStorage.maxLevel)) {
							console.log("获得一直新狗")
							this.openNewDogShowPanel(this.maxLevel, this.gameData.petList.length)
						}
					}
					localStorage.maxLevel = this.maxLevel
				}, 50)
			})
		}, this.fromId, this.toId, window["CFG"].activityId)
	}

	private resetData(callBack) {
		NetManager.ins.getGameZone((success) => {
			if (!success) {
				this.enabled = true;
				return
			}
			this.gameData = DataManager.ins.getData(NetName.GET_GAMEZONE).data;
			callBack()
		}, window["CFG"].activityId)
	}

	//修改位置
	doLocation() {
		this.enabled = false;
		if (this.from == this.to) {
			this.enabled = true;
			this.updateIndex()
			return;
		}

		NetManager.ins.getLocation((succuss) => {
			if (!succuss) {
				this.enabled = true;
				this.updateIndex()
				return;
			}
			this.resetData(() => {
				setTimeout(() => {
					this.enabled = true;
					this.updateIndex()
				}, 50)
			})
		}, this.fromId, this.to, window["CFG"].activityId)
	}



	//最大等级
	maxLevel = 0
	//生产速率
	yieldRate = 0
	//粮食库存
	foodStocks = 0

	updateAllTextFromHome() {
		if (this.gameData.maxLevel) {
			this.maxLevel = this.gameData.maxLevel;
			if (this.maxLevel === 0) {
				this.lvText.text = `LV.0`
			} else {
				this.lvText.text = `LV.${this.maxLevel}${DataConversion.dogLvLists[this.maxLevel - 1]}`
			}
		}
	}

	updateAllTextFromLocalCount() {
		if (this.maxLevel === 0) {
			this.lvText.text = `LV.0`
		} else {
			this.lvText.text = `LV.${this.maxLevel}${DataConversion.dogLvLists[this.maxLevel - 1]}`
		}
	}




	updateDogList(state) {


		//将位置添加到缓存数据
		this.locationData = [];
		for (let i = 0; i < this.petData.length; i++) {
			this.locationData.push(this.petData[i].holeIndex)
		}

		//
		if (this.dogPositions.length == 12) {
			for (let i = 0; i < 12; i++) {
				this["doglist_" + i].x = this.dogPositions[i].x;
				this["doglist_" + i].y = this.dogPositions[i].y;
				this["doglist_" + i].canMove = false;
			}
		} else {
			for (let i = 0; i < 12; i++) {
				this.dogPositions.push({ x: this["doglist_" + i].x, y: this["doglist_" + i].y, width: this["doglist_" + i].width, height: this["doglist_" + i].height })
			}
		}

		for (let i = 0; i < 12; i++) {
			this.doglists[i].visible = false
		}
		for (let i = 0; i < this.petData.length; i++) {
			this["doglist_" + this.petData[i].holeIndex].canMove = true;
			this.doglists[this.petData[i].holeIndex].visible = true;
			this.doglists[this.petData[i].holeIndex].setLv(this.petData[i].level)
			this.doglists[this.petData[i].holeIndex].setRate(`${DataConversion.doConversion(this.petData[i].rate * 3)}`)
		}

		if (state) {
			this.doglists[this.addLocation].firstAn()
		}


	}

	//狗狗产量气泡
	dogRate() {
		for (let i = 0; i < 12; i++) {
			this.addGold(i)
		}
	}

	addGold(i) {
		setTimeout(() => {
			if (this.doglists[i].visible) {
				this.music_food.play(0, 1)
			}
			this.doglists[i].addGold()
		}, 1400 * Math.random())
	}

	start(data?) {

	}

	protected onLoad(): void {
		this.initUI();
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}


	private onEnterFrame(): void {

	}


	//---------------------------------------------------分隔线-----------------------------------------------------
	//图鉴
	private onTap_mapBtn(): void {
		PanelCtrl.instance.btnDelay(this.mapBtn);
		PanelCtrl.instance.show(ModuleTypes.DOG_SHOW_PANEL);
	}
	//商店
	private onTap_shopBtn(): void {
		console.log(this.indexData.foodStocks)
		console.log(this.foodStocks)
		PanelCtrl.instance.btnDelay(this.shopBtn);
		NetManager.ins.shopYuji((success) => {
			if (success) {

				PanelCtrl.instance.show(ModuleTypes.SHOP_PANEL, this.foodStocks);
			} else {

			}
		}, window["CFG"].activityId);
	}

	//我的奖品记录
	private onTap_recordBtn(): void {
		PanelCtrl.instance.btnDelay(this.recordBtn);
		window.location.href = this.gotoRecord();
	}

	//规则按钮
	private onTap_ruleBtn(): void {
		PanelCtrl.instance.btnDelay(this.ruleBtn);
		PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
	}

	winStates = []
	wins = []

	/**
	 * 打开新人奖励狗粮
	 * @param newBonus 新人奖励（狗粮）
	 */
	openNewUserPrizePanel(newBonus) {
		console.log("新人奖励（狗粮）:" + newBonus)
		this.wins[2] = PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 0, type: 0, val1: newBonus, callBack: () => {
				this.openWinFrist(3)
			}
		});
		this.winStates[2] = true;
	}

	/**
	 * 产生了新的狗狗弹窗
	 * @param level 等级
	 * @param dogCount 舞台上的狗狗数量
	 */
	openNewDogShowPanel(level, dogCount) {

		//音效
		this.music_newdog.play(0, 1)

		let doMargeData = DataManager.ins.getData(NetName.GET_MERGE)
		if (doMargeData.data.prize) {
			console.log(doMargeData.data.prize.imgUrl)
		}

		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 2, type: 7, val1: level, actData: { x: 80, y: this.height - 80 }, callBack: (iscancel: boolean) => {
				if (iscancel) {
					//点击关闭按钮，图鉴按钮放大动画
					GDispatcher.dispatchEvent("mapBtnAn");
				} else {
					PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL, { level: level, dNum: dogCount });
				}
			}
		});

	}

	/**
	 * 打开离线收益弹窗
	 * @param offlineProfit 离线收益
	 * @param offlineDuration 离线时间
	 * @param maxValidOffLineSecond 最大离线时间(秒)
	 */
	openOfflinePanel(offlineProfit, offlineDuration, maxValidOffLineSecond) {
		console.log("离线收益:" + offlineProfit)
		console.log("最大离线时间:" + offlineDuration)
		this.wins[5] = PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 3, type: 8, val1: offlineDuration, val2: offlineProfit, val3: maxValidOffLineSecond, callBack: () => {
				this.openWinFrist(6)
			}
		});
		this.winStates[5] = true;
	}

	/**
	 * 打开离线后新增好友界面
	 * @param teamLength 队伍数量
	 */
	openOfflineFriendPanel(teamLength: number) {
		console.log("队伍数量:" + teamLength)
		this.wins[3] = PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 1, type: 3, val1: teamLength, callBack: (iscancel: boolean) => {
				if (!iscancel) {
					//打开队伍界面
					this.onTap_teamBtn();
				}
				this.openWinFrist(4)
			}
		});
		this.winStates[3] = true;
	}

	/**
	 * 打开公众号每日福利【获得狗粮】弹窗
	 * @param dailyBonus 每日福利狗粮
	 */
	openPrizePanel(dailyBonus: number) {
		console.log("每日福利狗粮:" + dailyBonus)
		this.wins[0] = PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 2, type: 6, val1: dailyBonus, callBack: () => {
				this.openWinFrist(2)
			}
		});
		this.winStates[0] = true;
	}

	/**
	 * 打开公众号每日福利提示弹窗
	 */
	openHowToGetPrizePanel() {

		console.log("打开公众号每日福利提示弹窗:")
		DataConversion
		if (!localStorage.HowToGetDate) {
			console.log("首次打开")
			localStorage.HowToGetDate = Date.now()
		} else {
			var isSameDay = new DataConversion().formatTime(new Date(Date.now()), parseInt(localStorage.HowToGetDate))
			if (isSameDay) {
				console.log("今天已经打开过一次")
				this.openWinFrist(5)
				return
			} else {
				console.log("现在可以打开了")
				localStorage.HowToGetDate = Date.now()
			}
		}

		this.wins[4] = PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 0, type: 2, callBack: () => {
				this.openWinFrist(5)
			}
		});
		this.winStates[4] = true;
	}

	/**
	 * 打开狗粮不足弹窗
	 */
	openNoCreditsPanel() {
		console.log("狗粮不足")
		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 0, type: 1, callBack: (iscancel: boolean) => {
				if (!iscancel) {
					//调用邀请好友方法
					PanelCtrl.instance.show(ModuleTypes.SHARE2_PANEL)
				}
			}
		});
	}

	/**
	 * 打开确定回收弹窗
	 * @param holeIndex 位置
	 */
	openRecyclePanel(holeIndex) {
		console.log(6666666)
		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {
			bgType: 1, type: 4, callBack: (iscancel: boolean) => {
				if (iscancel) {//点击了closeBtn
					GDispatcher.dispatchEvent("cancelRecycle");
				} else {
					//点击确认按钮
					GDispatcher.dispatchEvent("doRecycle", holeIndex);
				}
			}
		});
	}

	/**
	 * 助力成功
	 * @param data 
	 */
	openJoinSuccessPanel(data) {
		var text = `汪星卫队又扩充力量啦\n送你${data}狗粮作为感谢`;
		this.wins[1] = PanelCtrl.instance.show(ModuleTypes.JOIN_PANEL, {
			text: text, callBack: () => {
				this.openWinFrist(7)
			}
		});
		this.winStates[1] = true;
	}



	//获取我的奖品
	private gotoRecord(): string {
		let recordUrl: string;
		let oaId: number;
		if (DataManager.ins.customCfgData) {
			oaId = DataManager.ins.customCfgData.oaId;
			recordUrl = DataManager.ins.customCfgData.recordUrl;
		} else {
			oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
			recordUrl = window['recordUrl'];
		}

		if (recordUrl.indexOf('?') != -1) {
			recordUrl += '&origins=' + oaId + '00';
		} else {
			recordUrl += '?origins=' + oaId + '00';
		}
		// recordUrl += ',' + (window['plugId'] ? window['plugId'] : 4500) + '01';

		// for(let i = 0; i < window['plugIdArr'].length; i++){
		//     recordUrl += ',' + window['plugIdArr'][i] + '01';
		// }

		return recordUrl;
	}
}