import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import SceneCtrl from "../ctrls/sceneCtrl";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Data } from "../../libs/tw/data/Data";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import Loading from "../loading/Loading";

export default class LoadingScene extends Scene {
	public pBar:eui.ProgressBar;
	public pIconImg:eui.Image;
	public percentLb:eui.Label;
	public mainbg:eui.Image;
	private iconAct:egret.MovieClip;

	private lastVal:number;

	public get skinKey() { return 'LoadingScene' }
	public get groupName() { return 'loading_scene' }
	constructor(data?) {
		super(data);
		if (data) {
		
		}
		this.percentHeight = 100;

		this.lastVal = 0;
	}

	initEvents() {
		
		GDispatcher.addEvent('progress', this.setProgress, this);//626 117
	}

	removeEvents() {
		
		GDispatcher.removeEvent('progress', this.setProgress, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();
		Loading.instace.show()
	//	this.mainbg.texture = this.bgtexture;
		
		/* this.iconAct.anchorOffsetX = 165;
		this.iconAct.x = 115;
		this.addChild(this.iconAct);

		this.iconAct.gotoAndPlay(0, -1); */
	}

	start(data?) {

	}

	protected onLoad(): void {
		this.initUI();
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}

	private setProgress(data):void{
		let v = data[0];
		let time = 450;
		//this.pBar.value = v;

		// egret.Tween.get(this.iconAct).to({x:115 + 509 * v * 0.01}, time * (v - this.lastVal) * 0.01).wait(500).call(()=>{
		// 	if(v >= 100){
		// 		SceneCtrl.instance.change(ModuleTypes.START_SCENE);
		// 	}
		// });

		//this.iconAct.x = 115 + 509 * v * 0.01;
		
		setTimeout(() => {
			if(v >= 100){
				Loading.instace.hide()
				if(this.getQueryString("shareCode")){
					NetManager.ins.getIndex((success)=>{
						if(!success){
							return
						}
						this.goLastScene()
					},window["CFG"].activityId,true,this.getQueryString("shareCode"))
				}else{
					NetManager.ins.getIndex((success)=>{
						if(!success){
							return
						}
						this.goLastScene()
					},window["CFG"].activityId,true)
				}
			}
		}, 500);
		this.lastVal = v;

		this.percentLb.text = v + '%';
	}

	indexData
	goLastScene(){
		this.indexData = DataManager.ins.getData(NetName.GET_INDEX).data;
		if(this.indexData.winFlag==null){
			if(this.indexData.nickName){
				NetManager.ins.getGameZone((success)=>{
					if(!success){
						return
					}
					SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE);
				},window["CFG"].activityId)
			}else{
				SceneCtrl.instance.change(ModuleTypes.START_SCENE);
			}
		}else{
			if(this.indexData.winFlag==true){
				this.openPrizePanel(this.indexData.lastRank,this.indexData.prize)
			}else{
				this.openLosePanel(this.indexData.lastRank)
			}
		}
	}


/**
 * 排名开奖中奖
 * @param lastRank 排名
 * @param prize 奖品
 */
openPrizePanel(lastRank,prize) {
	console.log("排名开奖中奖")
}

/**
 * 排名开奖未中奖
 * @param lastRank 排名
 */
openLosePanel(lastRank) {
	console.log("排名开奖未中奖")
}

getQueryString(name) {
	var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
	var r = window.location.search.substr(1).match(reg);
	if (r != null) return unescape(r[2]);
	return null;
};

	private bgtexture: egret.Texture;
	protected async preLoadRes() {
        //加载背景并设置背景图片
       // this.bgtexture = await RES.getResAsync('lodingBg_jpg');
        // console.log('载背景并设置背景图片mainscene');

       // var mcJson = await RES.getResAsync('loadingIconMc_json');
       // var mcImg = await RES.getResAsync('loadingIconMc_png');
       // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

		//this.iconAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
	}

	//循环播放动画
	private playAnimation(target: egret.tween.TweenGroup, isLoop: boolean = true): void {
		if (isLoop) {
			for (var key in target.items) {
				target.items[key].props = { loop: true };
			}
		}
		target.play();
    }
}