import { NetName } from './../../libs/tw/enum/NetName';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";

export default class HelpPrizePanel extends Panel {
    public get skinKey() { return "HelpPrize" }
    public get groupName() { return "helpPrize_Panel" }

    public closeBtn: eui.Button;
    public statusTitle: eui.Label;
    public goLevelUpBtn: eui.Button;
    public prizeTips: eui.Label;
    public prizeImg: eui.Image;
    public prizeNum: eui.Label;
    public prizeNum1: eui.Label;
    public prizeNum0: eui.Label;

    private callback: Function = () => { };
    data
    constructor(data) {
        super()
        this.callback = data.callback
        this.data = data
    }


    onSkinComplete() {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onLoad() {
       // const data = DataManager.ins.getData(NetName.GET_REWARD).data;
        if (!this.data) {
            return
        }
        this.prizeTips.text = `已有${this..newInviteSuccessCnt}人助力，成功召唤萌宠`;
        this.prizeNum0.text = `${this..newInviteSuccessCnt}`;
        this.prizeNum1.text = `${this..newInviteSuccessCnt}`;
    }

    initEvents() {
        super.initEvents();
        this.goLevelUpBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_goLevelUpBtn, this);
    }

    onTap_goLevelUpBtn() {
        this.onTouchTap();
    }

    onTouchTap() {
        super.onTouchTap();
        this.callback();
    }

    removeEvents() {
        super.removeEvents();
        this.goLevelUpBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_goLevelUpBtn, this);
    }
}