
import Panel from "../views/Panel";
// import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from "../../libs/tw/manager/DataManager";
import { DogShowItemComponent } from "../components/DogShowItemComponent";
import { NetName } from "../../libs/tw/enum/NetName";
import DataConversion from "../mainScene/DataConversion";
import NetConst from "../NetConst";
export default class DogShowPanel extends Panel {

    public closeBtn: eui.Image;
    public petsList: eui.Scroller;
    public Lv1: eui.Component;
    public Lv2: eui.Component;
    public Lv3: eui.Component;
    public Lv4: eui.Component;
    public Lv5: eui.Component;
    public Lv6: eui.Component;
    public Lv7: eui.Component;
    public Lv8: eui.Component;
    public Lv9: eui.Component;
    public Lv10: eui.Component;

    public get skinKey() { return 'DogShowPanel' }
    public get groupName() { return 'dogShow_panel' }

    private callback: Function;
    constructor(data) {
        super(data);
        this.callback = data;
        this.percentHeight = 100;

        // this.maxLv = DataManager.ins.getData(NetName.GET_HOME).data.maxLevel;
    }


    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    onLoad() {
        this.initUI()
    }

    initUI() {
        const heightArr = [84, 89, 111, 117, 109, 105, 97, 98, 102, 112]
        for (let i = 1; i < 11; i++) {
            this[`Lv${i}`]['petName'].text = DataConversion.dogLvIndex[i - 1] + "?";
            this[`Lv${i}`]['petNumGroup'].visible = false;
            this[`Lv${i}`]['petImg'].source = `shadow_${i}_png`;
            if(this[`Lv${i}`].maskRect){
                this[`Lv${i}`].maskRect.alpha=1;
            }
            this[`Lv${i}`]['petImg'].mask= this[`Lv${i}`].maskRect;
            this[`Lv${i}`]['petImg'].anchorOffsetY = heightArr[i - 1];
            /* if(i>3){
                this[`Lv${i}`]['petImg'].y=110;
            } */
        }

        this.updateUI();

    }

    updateUI() {
        if (!DataManager.ins.getData("myPetsList")) {
            NetConst.myPetsList((s) => {
                if (!s) {
                    return
                }
                const list = DataManager.ins.getData("myPetsList").data;
                let maxLevel = 1;
                list.forEach((item, idx) => {
                    if (item.cnt > 0 && item.level > maxLevel) {
                        maxLevel = item.level;
                    }
                });
                const heightArr = [84, 93, 125, 142, 148, 126, 123, 141, 150, 156]

                for (let i = 1; i <= maxLevel; i++) {
                    let item = list[i - 1];
                    this[`Lv${i}`]['petName'].text = DataConversion.dogLvIndex[i - 1] + DataConversion.dogLvLists[i - 1] + "";
                    this[`Lv${i}`]['petImg'].source = `dog_lv_${i}_png`;
                    this[`Lv${i}`]['petImg'].scaleX = 0.8;
                    this[`Lv${i}`]['petImg'].scaleY = 0.8;
                    this[`Lv${i}`]['petImg'].anchorOffsetY = heightArr[i - 1];
                    this[`Lv${i}`]['petImg'].mask= null;
                    if(i>3){
                        this[`Lv${i}`]['petImg'].y=110;
                    }
                    if(this[`Lv${i}`].maskRect){
                        this[`Lv${i}`].maskRect.alpha=0;
                    }                    
                    if (item.cnt >= 0) {
                        this[`Lv${i}`]['petNumGroup'].visible = true;
                        this[`Lv${i}`]['petNum'].text = `${item.cnt}`;
                    }
                }
            }, window['CFG'].activityId)
        } else {
            const list = DataManager.ins.getData("myPetsList").data;
            let maxLevel = 1;
            list.forEach((item, idx) => {
                if (item.cnt > 0 && item.level > maxLevel) {
                    maxLevel = item.level;
                }
            });
            const heightArr = [84, 93, 125, 142, 148, 126, 123, 141, 150, 156]

            for (let i = 1; i <= maxLevel; i++) {
                let item = list[i - 1];
                this[`Lv${i}`]['petName'].text = DataConversion.dogLvIndex[i - 1] + DataConversion.dogLvLists[i - 1] + "";
                this[`Lv${i}`]['petImg'].source = `dog_lv_${i}_png`;
                this[`Lv${i}`]['petImg'].scaleX = 0.8;
                this[`Lv${i}`]['petImg'].scaleY = 0.8;
                this[`Lv${i}`]['petImg'].anchorOffsetY = heightArr[i - 1];
                this[`Lv${i}`]['petImg'].mask= null;
                if(i>3){
                    this[`Lv${i}`]['petImg'].y=110;
                }
                if(this[`Lv${i}`].maskRect){
                    this[`Lv${i}`].maskRect.alpha=0;
                }
                
                if (item.cnt >= 0) {
                    this[`Lv${i}`]['petNumGroup'].visible = true;
                    this[`Lv${i}`]['petNum'].text = `${item.cnt}`;
                }
            }
        }
    }

}