export class DogShopItemComponent extends eui.Component{
    public dogImgGroup:eui.Group;
    public disGroup:eui.Group;
    public dNameLb:eui.Label;
    public buyBtn:eui.Button;
    public dogImg:eui.Image;
    public lockLb:eui.Label;
    public lvLb:eui.Label;

    private dData:any;
    private lv:number;
    private dName:string;
    private size:number[];
    private iconName:string;

    //点击收取回调
    private clickCallBack:Function;
    
    /**
     * 
     * @param lv 等级
     * @param name 狗名
     * @param iconName 资源名
     * @param callBack 
     */
    constructor(lv:number,name:string,iconName:string,size:number[],dData:boolean, callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/component/DogShopItemComponent.exml';
        this.clickCallBack  = callBack;

        this.lv = lv;
        this.size = size;
        this.dName = name;
        this.dData = dData;
        this.iconName = iconName;
        this.buyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.lvLb.text = 'lv.' + this.lv;
        this.dNameLb.text = this.dName;
        this.dogImg.source = this.iconName;

        this.buyBtn.visible = !this.dData.lock;
        this.disGroup.visible = this.dData.lock;

        if(this.dData.lock){
            this.lockLb.text = 'LV.' + this.dData.unlockLevel + "解锁";
        }else{
            var lb:any = this.buyBtn['labelDisplay'];
            lb.stroke = 3.9;
            lb.strokeColor = 0x6b4838;
            lb.text = this.dData.summonConsume;
        }

        let h = this.size[1];
        let w = this.size[0];

        if(h > 100){
            w = Math.floor(w / h * 100);

            h = 100;
        }
        this.dogImg.width = w;
        this.dogImg.height = h;

        this.dogImg.anchorOffsetX = w * 0.5;
        this.dogImg.anchorOffsetY = h * 0.5;

        this.dogImg.x = this.dogImgGroup.width * 0.5;
        this.dogImg.y = this.dogImgGroup.height * 0.5;

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);

    }

    public removeEvent():void{
        this.buyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_buyBtn, this);
    }

    private onTap_buyBtn():void{
        if(this.clickCallBack){
            this.clickCallBack(this.lv);
        }
    }
    
    public playAct(start:number = 0):void{
        
    }

    public stopAct():void{
        // this.act.stop();
    }
}