import Panel from "../views/Panel";
import { ButtonType } from "../types/sceneTypes";
import SceneCtrl from '../ctrls/sceneCtrl';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from '../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import PanelCtrl from "../ctrls/panelCtrl";

export default class ToastPanel extends Panel {
   
    public title:eui.Label;
    public content:eui.Label;
    public btnLabel:eui.Label;
    public closeBtn:eui.Button;

    private mdata:any;
    public get skinKey() { return 'ToastPanel' }
    public get groupName() { return 'prize_panel'}

  
    start(data) {
        this.mdata = data;
        this.percentHeight = 100;

    }

    onSkinComplete() {
        super.onSkinComplete();
        this.pMask.visible = false;
        this.showAct();
        
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    initEvents() {
        super.initEvents();
        // this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_this, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.colseBtnClick, this);
       
    }

    removeEvents() {
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.colseBtnClick, this);
    }

    private ontap_this():void{
        super.onTouchTap();
        if(this.mdata.btnType == ButtonType.TRY_BTN)
        {
            NetManager.ins.ajaxElementNew(function(success){
                if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                }else{
                    this.show(ModuleTypes.TOAST_PANEL, {title:'获取失败',content:'请刷新重试',btnType:ButtonType.KNOW_BTN});
                }
            }.bind(this));
        }
        else
        {
            if(this.mdata.btnType != ButtonType.SHATE_BTN)
            {
                if(this.mdata && this.mdata.callBack){
                    this.mdata.callBack();
                }
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }
        }
    }

    private colseBtnClick(){
        super.onTouchTap();
        PanelCtrl.instance.btnDelay(this.closeBtn);
        if(this.mdata){
            if(this.mdata.type == 0){
                if(DataManager.ins.customCfgData.isNotLoginUser){
                    
                    window['requirelogin']&&window['requirelogin']();
                }
            }else if(this.mdata.type == 1){
                let url = DataManager.ins.customCfgData.getCreditsLink;
                if(url != null && url != ''){
                    window.location.href = url;
                }
            }
        }
        this.hidePanel();
    }
    private onLoad():void{
        if(this.mdata){
            this.title.text = this.mdata.title;
            this.content.text = this.mdata.content;
            this.btnLabel.text = this.mdata.btnLabel;
        }
    }

}
export interface IMsgData{
    title:string,
    content:string,
    btnType:number,
    callBack?:Function,
    closeCallBack?:Function
}