import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
export default class TipsPanel extends Panel {
    public sureBtn:eui.Button;
    public timesLb:eui.Label;

    private mdata:any;

    public get skinKey() { return 'TipsPanel' }
    public get groupName() { return 'tips_panel'}
    
    constructor(data){
        super(data);

        this.mdata = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();

        // let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.showLog(exposure);

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        

        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();

        this.sureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_sureBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.sureBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap_sureBtn, this);
    }

    private onLoad():void{

        for(let i = 0; i < 3; i++){
            if(this.mdata){
                if(this.mdata.idx == (i + '')){
                    this['flower' + i].visible = true;
                }else{
                    this['flower' + i].visible = false;
                }
            }else{
                this['flower' + 0].visible = false;
                this['flower' + 1].visible = false;
            }
        }

        const times = DataManager.ins.ajaxElementDataNew.element.freeLimit;
        if(times > 0){
            this.timesLb.text = '今日剩余免费次数:' + times + '次';
        }else{
            this.timesLb.text = DataManager.ins.ajaxElementDataNew.element.needCredits + DataManager.ins.customCfgData.unitName + '/次';
        }

        
        
    }

    private ontap_sureBtn():void{

        PanelCtrl.instance.btnDelay(this.sureBtn);
        if(this.mdata && this.mdata.callBack){
            this.mdata.callBack();
        }
        // let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.clickLog(exposure);


        this.onTouchTap();
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

    }
}