import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import SVGACtrl from '../ctrls/svgaCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { GCache } from '../../libs/tc/util/GCache';
import { ButtonType } from "../types/sceneTypes";


export default class StartScene1 extends Scene {
    public startBtn:eui.Button;
    public ruleBtn:eui.Button;
    //public myPrizeBtn:eui.Button;

    public costLb:eui.Label;
    public freeTimeLb:eui.Label;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickRule, this);
        //this.myPrizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    }

    removeEvents() {
        super.removeEvents();
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickRule, this);
        //this.myPrizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;

    }

    protected async preLoadRes() {

        return new Promise(function (resolve, reject) {
            resolve();
        });
        
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        if(DataManager.ins.ajaxElementDataNew.element.freeLimit < 1){
            this.freeTimeLb.visible = false;
            this.costLb.visible = true;
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"次数提示",content:"今日次数已用完,需要消耗积分参与",btnLabel:"确定"});
        }else{
            this.freeTimeLb.visible = true;
            this.costLb.visible = false;
        }
        this.costLb.text = DataManager.ins.ajaxElementDataNew.element.needCredits + DataManager.ins.customCfgData.unitName + '/次'
        this.freeTimeLb.text = '今日剩余免费次数:' + DataManager.ins.ajaxElementDataNew.element.freeLimit;
    }
    private resetState(){
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        return;
    }
    private onTap_startBtn():void{
        PanelCtrl.instance.btnDelay(this.startBtn);
        this.dostart();
    }
    private dostart(): void {
        NetManager.ins.doJoinNew(function(success: boolean,result){
            if(!result)
            {
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"网络错误",content:"请检查网络情况",btnLabel:"确定"});
                return;
            }
            if(success && DataManager.ins.doJoinData.code == '0000000000'){
                this.goGame();
            }else{
                if(DataManager.ins.doJoinData){
                    console.log('errorCode:' + DataManager.ins.doJoinData.code);
                }
                if (DataManager.ins.doJoinData.code == 'E100202007' || DataManager.ins.doJoinData.code == 'E100202008' || DataManager.ins.doJoinData.code == 'E100202009' || DataManager.ins.doJoinData.code == 'E100202010'){  
                    //次数已用完
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"次数提示",content:"今日次数已用完",btnLabel:"确定"});
                }else if(DataManager.ins.doJoinData.code == 'E100201001' || DataManager.ins.doJoinData.code == 'E100201002'){//未登录
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"登录提示",content:"您还未登录，请先登录",btnLabel:"去登陆",type:0});
                }else if(DataManager.ins.doJoinData.code == 'E100201007'){//积分不足
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"积分不足",content:"抱歉！您当前积分不足",btnLabel:"赚积分",type:1});
                }else{//未中奖
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:"网络错误",content:"请检查网络情况",btnLabel:"确定"});
                }
            }
        }.bind(this));

      
    }
    //开始游戏
    private goGame():void{
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
    }
    //规则
    private onClickRule(){
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL); 
    }
    private onTap_prizeBtn():void{
        console.log('点击prizeBtn'); 
        return;
        //PanelCtrl.instance.btnDelay(this.myPrizeBtn);
        //window.location.href = this.gotoRecord();//window["recordUrl"];
    }
        //获取我的奖品
        private gotoRecord():string{
            let recordUrl: string;
            let oaId: number;
            if (DataManager.ins.customCfgData) {
                oaId = DataManager.ins.customCfgData.oaId;
                recordUrl = DataManager.ins.customCfgData.recordUrl;
            } else {
                oaId = DataManager.ins.gameCfgData.gameInfo.oaId;
                recordUrl = window['recordUrl'];
            }
    
            if(recordUrl.indexOf('?') != -1){
                recordUrl += '&origins=' + oaId + '00';
            }else{
                recordUrl += '?origins=' + oaId + '00';
            } 
            return recordUrl;
        }
}