
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes,ButtonType} from '../types/sceneTypes';
import PanelCtrl from "../ctrls/panelCtrl";

export default class SharePanel extends Panel {

    public closeBtn:eui.Button;
    public panelGroup:eui.Group;
    public icon:eui.Image;
    private mData:any;
  //语文老师 13>=   <=15
    private chinese:egret.Texture;
  //英语老师 11>=   <13
     private english:egret.Texture;
  //数学老师 8>=   <11
    private mathematics:egret.Texture;
  //体育老师 5>=   <8
    private sports:egret.Texture;
    public get skinKey() { return 'Share' }
	public get groupName() { return 'share_panel'}
    constructor(data?){
        super(data);
        this.mData = data;
    }

    start(data?):void{
        this.percentHeight = 100;
    }

    initEvents():void{
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickClose, this);
    }

    removeEvents():void{
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickClose, this);
    }
    protected async preLoadRes() {
        this.chinese = await RES.getResAsync("chinese_png");
        this.english = await RES.getResAsync("english_png");
        this.mathematics = await RES.getResAsync("mathematics_png");
        this.sports = await RES.getResAsync("sports_png");
        return new Promise(function (resolve, reject) {
            resolve();
        });
    }
    onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad():void{
        if(5 <= this.mData.score && this.mData.score < 8)
        {
            this.setTexture(this.icon,this.sports);
        }
        else if(8 <= this.mData.score && this.mData.score < 11)
        {
            this.setTexture(this.icon,this.mathematics);
        }
        else if(11 <= this.mData.score && this.mData.score < 13)
        {
            this.setTexture(this.icon,this.chinese);
        }
        else if(13 <= this.mData.score && this.mData.score <= 15)
        {
            this.setTexture(this.icon,this.english);
        }
        else
        {
            console.log('分数出错');
        }

        setTimeout(() => {
            this.scanImg();
        }, 500);

        //img.style.display = 'none';//block
    }
    private setTexture(tmpNode,tmpTexture){
        tmpNode.texture =  tmpTexture;
        tmpNode.width = tmpTexture.width;
        tmpNode.height = tmpTexture.height;
    }


    private scanImg():void{
        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(this.panelGroup, new egret.Rectangle(0, 0, 750, 1206));
        let imageData = renderTexture.toDataURL("image/png");
        var img = document.getElementById('shareImg');
        img.style.position = 'absolute';
        img['src'] = imageData;
        
        img.style.width = "100%";//`${widthP}%`;
        img.style.left  = "0%";//`${leftP}%`;
        img.style.top   = "0%";//`${topP}%`;
        img.style.display           = 'block';
        img.style.opacity ='0';
        // var sCloseBtn = document.getElementById('sCloseBtn');
        // sCloseBtn.style.width       = '50px';
        // sCloseBtn.style.height      = '50px';
        // sCloseBtn.style.position    = 'absolute';
        // sCloseBtn.style.top         = '40px';
        // sCloseBtn.style.left        = '40px';

        
        // sCloseBtn.style.display     = 'block';

        // sCloseBtn.onclick = ()=>{
        //     img.style.display = 'none';
        //     sCloseBtn.style.display = 'none';
        //     this.hidePanel();
        // }
    }
    private onClickClose(){
        PanelCtrl.instance.btnDelay(this.closeBtn);
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}