import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { ButtonType } from "../types/sceneTypes";

export default class PrizePanel extends Panel {
    private mdata: any;
    public titleLb:eui.Label;


    public prizeImg: eui.Image;
    public prizeBtn: eui.Button;
    public prizeNameLb: eui.Label;
    public closeBtn:eui.Button;
    private isplug:boolean;
    private lottery:any;
    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;

        if(this.mdata){
            this.isplug = this.mdata.isplug;
            if(this.isplug){
                this.lottery = DataManager.ins.getPlugOrderStatusData.lottery;
            }else{
                this.lottery = DataManager.ins.getCustomOrderStatusData.lottery;
            }
        }
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function(){
            
        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        //this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        
        
    }

    removeEvents(): void {
        super.removeEvents();
        if(this.prizeBtn){
            this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        // if(this.prizeImg){
        //     this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        // }
    }

    private onLoad() {
        //this.prizeBtn['nameLb'].stroke = 5;
        //this.prizeBtn['nameLb'].strokeColor = 0xf05a35;

        if(this.mdata){
            if(this.mdata){
                this.titleLb.text = '恭喜你';
            }
        }

        if(this.mdata && this.lottery){
            
            var url: string;

            url = this.lottery.img;
            this.prizeImg.name = 'img'

            this.prizeNameLb.text = this.lottery.name;//511 239
            this.prizeImg.source = url;
            
            switch(this.lottery.type){
                //小图
                case LotteryType.VIRTUAL:
                case LotteryType.OBJECT:
                case LotteryType.ALIPAY:
                case LotteryType.PHONEBILL:
                case LotteryType.QB:

                    this.prizeImg.x = 304;
                    this.prizeImg.y = 397;

                    this.prizeImg.width = 147;
                    this.prizeImg.height = 150;
                break;
                case LotteryType.THANKS:
                break;
                //大图
                default:
                    this.prizeImg.x = 171;
                    this.prizeImg.y = 397;

                    this.prizeImg.width = 413;
                    this.prizeImg.height = 150;
                break;
            }
        }
    }

    private onTap(): void {
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        this.hidePanel();
       SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }


    onUse() {
        if(this.mdata){
            const lottery = this.lottery;
            // if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            if (lottery.type == LotteryType.LUCKY) {

                window["downloadAppConfig"] =
                    {
                        openUrl: lottery.openUrl,
                        iosDownloadUrl: lottery.iosDownloadUrl,
                        androidDownloadUrl: lottery.androidDownloadUrl,
                        confirm: lottery.confirm ? lottery.confirm : false
                    };
                window["downloadApp"]();
                if (lottery.type == "lucky") {
                    if(this.isplug){
                        NetManager.ins.spmclick(DataManager.ins.getPlugOrderStatusData.exposure);
                    }else{
                        NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
                    }
                }
            } else {
                console.log(`领奖链接：${lottery.link}`)
                window.location.href = lottery.link;
            }
        }else{
            // this.onTouchTap();
        }
    }

    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        // Loading.instace.show();
        // NetManager.ins.ajaxElementNew(function(success){
        //     console.log(DataManager.ins.ajaxElementDataNew);
        //     if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
        //         Loading.instace.hide();
        //     
        //         SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        //     }else{
        //         //PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试', line: 1});
        //         PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {title:'提示',content:'请刷新重试',btnType:ButtonType.KNOW_BTN});
        //         Loading.instace.hide();
        //     }
        // }.bind(this));
        this.onTap();
    }

    private onTap_ok(e:egret.TouchEvent):void{
        if (this['prizeBtn']) {
            PanelCtrl.instance.btnDelay(this['prizeBtn']);
        }
        this.onUse();
        // window.location.href = window['prizeUrl'] ? window['prizeUrl'] : 'http://www.baidu.com';
        //this.onTouchTap();
    }

}