import Scene from "../views/Scene";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";

export default class OverPageScene extends Scene {
    private wordTimeSpace:number;
    private changeWordIntervalIdx:number;

    private wordArr:string[];
    private wordOrderArr:number[];

    public get skinKey() { return 'OverPageScene' }
    // public get groupName() { return 'overpage_scene' }

    constructor(data?) {
        super(data);
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('gameBg_jpg');
        // console.log('载背景并设置背景图片mainscene');


        // var mcJson = await RES.getResAsync('lightGameEff_json');
        // var mcImg = await RES.getResAsync('lightGameEff_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        this.initData();
        this.initUI();
    }

    private initData():void{
        this.wordArr = ['正义', '豁达', '天真', '睿智', '性感'];

        if(!this.wordOrderArr){
            this.wordOrderArr = [];
        }

        for(let i = 0; i < 17; i++){
            this.wordOrderArr.push(i);
        }

        this.wordOrderArr = this.shuffleArray(this.wordOrderArr);
    }

    private initUI():void{

        this.refreshWord();
        this.showTLbAct();
        this.showCharAct();

        setTimeout(() => {
            console.log('进入结果页');
            SceneCtrl.instance.change(ModuleTypes.RESULT_SCENE);
            this.removeAllAct();
        }, 3500);
    }

    private resetWord():void{
        this.wordTimeSpace -= 150;
        this.wordTimeSpace += 1000;

        setTimeout(() => {
            this.changeWordIntervalIdx = setInterval(function(){
                for(let i = 0; i < 17; i++){
                    this.randomWord(i);
                }
            }.bind(this), 500);
        }, this.wordTimeSpace);
    }

    private refreshWord():void{

        for(let i = 0; i < 17; i++){
            this['wordLb' + i].alpha = 0;
            this['wordLb' + i].scaleX = 3;
            this['wordLb' + i].scaleY = 3;

            this['wordLb' + i].anchorOffsetX = 30;
            this['wordLb' + i].anchorOffsetY = 15;
            this['wordLb' + i].x += 30;
            this['wordLb' + i].y += 15;

        }

        let allLen = this.wordOrderArr.length;

        let intervalIdx = setInterval(function(){
            if(allLen){
                let len = 1 + Math.floor(Math.random() * 2);
                if(len < allLen){
                    allLen -= len;
                    for(let i = 0; i < len; i++){
                        this.setWordAct();
                    }
                }else{
                    for(let i = 0; i < allLen; i++){
                        this.setWordAct();
                    }

                    allLen = 0;
                }
            }else{

                this.resetWord();
                clearInterval(intervalIdx);
            }

            this.wordTimeSpace += 150;
        }.bind(this), 150);
    }

    private setWordAct():void{
        const idx = this.wordOrderArr.pop();
        this.randomWord(idx);

        let timeSpace = 1000;
        egret.Tween.get(this['wordLb' + idx]).to({scaleX:1, scaleY:1, alpha:1}, timeSpace); 
    }
    //随机文字内容
    private randomWord(i:number):void{
        const idx = Math.floor(Math.random() * 5);
        this['wordLb' + i].text = this.wordArr[idx];
    }

    //正在解析。。。 动画
    private showTLbAct():void{
        let timeSpace = 100;
        for(let i = 0; i < 9; i++){
            this['tLb' + i].anchorOffsetX = 25;
            this['tLb' + i].anchorOffsetY = 25;
            this['tLb' + i].x += 25;
            this['tLb' + i].y += 25;

            egret.Tween.get(this['tLb' + i], {loop:true}).wait(timeSpace * i).
            to({scaleX:1.5, scaleY:1.5}, timeSpace, egret.Ease.cubicOut).
            to({scaleX:1, scaleY:1}, timeSpace, egret.Ease.cubicOut).wait(900 - timeSpace * i);
        }


    }

    private showCharAct():void{
        for(let i = 0; i < 4; i++){
            this['charLb' + i].anchorOffsetX = 9;
            this['charLb' + i].anchorOffsetY = 15;
            this['charLb' + i].x += 9;
            this['charLb' + i].y += 15;


            this['charLb' + i].alpha = 0;
            this['charLb' + i].scaleX = 3;
            this['charLb' + i].scaleY = 3;
        }

        for(let j = 0; j < 4; j++){
            egret.Tween.get(this['charLb' + j]).wait(100 * j).
            to({scaleX:1, scaleY:1, alpha:1}, 1000)
        }


    }

    //清楚所有动效相关
    private removeAllAct():void{
        for(let i = 0; i < 9; i++){
            egret.Tween.removeTweens(this['tLb' + i]);
        }

        clearInterval(this.changeWordIntervalIdx);
    }


    //打乱数组顺序
    private shuffleArray(array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    }
}