// import { MovieClip } from './../../libs/svga/MovieClip';
// import { Parser } from './../../libs/svga/parser';
export default class SVGACtrl {

    static _instance: SVGACtrl;

    public SVGAPool: any[] = [];

    public static get instance() { return SVGACtrl._instance || (SVGACtrl._instance = new SVGACtrl()) }

    public load(path) {
        return new Promise((resolve, reject) => {
            let parser = new window['SVGA'].Parser();
            parser.load(path, (videoItem) => {
                var mv = new window['SVGA'].EgretMovieClip(videoItem);
                let file = path.substring(path.lastIndexOf("/") + 1);//去掉了路径
                let name = file.substring(0,file.lastIndexOf("."));//去掉了后缀名
                mv.name = name;
                this.SVGAPool.push(mv)
                resolve(mv);
                let fun
                mv.addEventListener(egret.Event.COMPLETE, fun = function () {
                    mv.removeEventListener(egret.Event.COMPLETE, fun, this)
                    ///mv.gotoAndStop();
                    //mv.stop()
                    //mv.startAniRange(30, 60);
                }, this)
            }, function (error) {
                reject(error.message)
            })
        })
    }
    public gotoAndStop(name:string){
        let mv = this.getSVGAItem(name);
        if(mv)
        {
            mv.gotoAndStop();
            return true;
        }
        return false;
    }
    public gotoAndPlay(name:string){
        let mv = this.getSVGAItem(name);
        if(mv)
        {
            mv.gotoAndPlay();
            return true;
        }
        return false;
    }
    public getSVGAItem(name:string){
        for(let index = 0; index < this.SVGAPool.length ;index++)
        {
            if(this.SVGAPool[index].name == name)
            {
                return this.SVGAPool[index];
            }
        }
        return null;
    }

    public play(name:string,isLoop,callBack: Function) {
        let mv= this.getSVGAItem(name);
        if(mv)
        {
            mv.play();
            console.log("播放动画",mv.name);
            let fun;
            mv.addEventListener(egret.Event.COMPLETE, fun = function () {
                if(!isLoop)
                {
                    mv.stop();
                }
                if(callBack)
                {
                    callBack();
                }
                mv.removeEventListener(egret.Event.COMPLETE, fun, this)
            }, this)
            return true;
        }
        return false;
    }
    public stop(name:string){
        let mv= this.getSVGAItem(name);
        if(mv)
        {
            mv.stop();
            return true;
        }
        return false;
    }
}
