"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var sceneTypes_1 = require("../types/sceneTypes");
var Loading_1 = require("../loading/Loading");
var PanelCtrl = (function () {
    function PanelCtrl() {
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    PanelCtrl.prototype.show = function (type, data, hasMask) {
        if (hasMask === void 0) { hasMask = true; }
        if (type == sceneTypes_1.ModuleTypes.MSG_PANEL) {
            if (this.msgPanel) {
                return;
            }
        }
        var cls = this._panelClassMap[type];
        Loading_1.default.instace.show();
        var panel = new cls(data, hasMask);
        this._current = panel;
        // panel.setSkinName();
        // panel.setMask();
        // panel.setShowAct();
        // panel.start(data);
        if (type == sceneTypes_1.ModuleTypes.MSG_PANEL) {
            this.msgPanel = panel;
        }
        this.add(panel);
        this._parent.visible = true;
    };
    /**
     * 防止连点
     * @param targe 可交互对象
     * @param dtime 延时默认500ms
     */
    PanelCtrl.prototype.btnDelay = function (targe, dtime) {
        if (dtime === void 0) { dtime = 500; }
        targe.touchEnabled = false;
        setTimeout(function () {
            targe.touchEnabled = true;
        }, dtime);
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.$children.forEach(function (child) {
            child['clearEvent']();
        });
        this._parent.removeChildren();
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
        // panel.addEventListener('onCreditsOut', this.onCreditsOut, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
    };
    /**
     * 立即移除Panel
     * @param panel
     */
    PanelCtrl.prototype.removeImmediately = function (panel) {
        this._parent.removeChild(panel);
        this._parent.visible = false;
        this._current = null;
        // this.removeMaskImmediately();
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        // panel.removeEventListener('onCreditsOut', this.onCreditsOut, this);
        this.remove(panel);
        if (this.msgPanel == panel) {
            this.msgPanel = null;
        }
        if (this._parent.numChildren == 0) {
            this._parent.visible = false;
        }
    };
    PanelCtrl.prototype.registerPanelClass = function (name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    //消息弹出框
    PanelCtrl.prototype.showMsg = function (bname, titleIdx, callBack, closeCallBack, msg, msg0) {
        var msgData = {
            msg: msg,
            msg0: msg0,
            btnName: bname,
            callBack: callBack ? callBack.bind(this) : null,
            closeCallBack: closeCallBack ? closeCallBack.bind(this) : null
        };
        msgData.titleIdx = titleIdx;
        PanelCtrl.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, msgData);
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;
__reflect(PanelCtrl.prototype, "\"/Users/chiwang/Desktop/\u5151\u5427\u5DE5\u4F5C/newGame/saolei19.03.06/db-game-template/egret/src/ctrls/panelCtrl\".PanelCtrl");
//# sourceMappingURL=panelCtrl.js.map