import MovieClipManager from './../ctrls/MovieClipManager';
import Panel from "../views/Panel";
import { GFun } from "duiba-tc"
import PanelCtrl from "../ctrls/panelCtrl";
import showAlertPanel from "../ctrls/showAlertPanel";
export default class ResultPanel extends Panel {

    constructor(baseImg?:any){
        super()
        this.baseImg = baseImg;
        this.show()
    }

    public eleBg:eui.Image;
    public face:eui.Image;
    public ani1:eui.Image;
    public ani2:eui.Image;
    public ani3:eui.Image;
    public shareBtn:eui.Button;

    private baseImg:any;
    private drawImg:any;

    private count:number = 0;
    private show(){
        let scope = this;
        let imageBase64 = scope.baseImg ? `data:image/png;base64,${scope.baseImg}` : 'data:image/png;base64,https://shp.qpic.cn/tu_act_pic/0/GfM3Ir4WajY9/0';
        
        let img = document.createElement("img");
        img.src = imageBase64;
        img.onload = () => {
            let texture:egret.Texture = new egret.Texture();
            let bitmapdata:egret.BitmapData = new egret.BitmapData(img);
            texture.bitmapData = bitmapdata;
            scope.face.source = texture;
            scope.face.x = 315;
            scope.face.y = 440;
            console.log(scope.face)
        }


        // setTimeout(()=>{
        //     GFun.loadImage(this.baseImg,(img)=>{
        //         console.log(img)
        //         img.setAttribute("crossOrigin",'anonymous')
        //         // let _data = getImageBase64(img);
        //         // this.face.source = _data;
        //         let canvas = document.querySelectorAll("canvas")[1]; //创建canvas DOM元素，并设置其宽高和图片一样 
        //         console.log(canvas)
        //         this.drawImg = img;
        //         egret.Ticker.getInstance().register(this.onEnterFrame, this);
        //         // let ctx = canvas.getContext("2d"); 
        //         // ctx.drawImage(img, 0, 0);
        //         let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        //         renderTexture.drawToTexture(this.drawImg,new egret.Rectangle(0,0,this.drawImg.width,this.drawImg.height));
        //     })
        // },500)
    }

    private onEnterFrame(){

    }

    // 加载动画资源
    protected childrenCreated():void{
        super.childrenCreated();
        let mc = MovieClipManager.instance.getMovieClipByName("facePackE1");
        mc.gotoAndPlay('active', -1);
        this.addChild(mc);
        mc.x = 180;
        mc.y = 400;

        this.addChild(this.face);
    }


    initEvents(){

    }

    removeEvents(){

    }

    protected get skinKey() { return 'Result' }
}