'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api/index.js';
import 'spark-design/dist/index.css'
import { Toast, Loading, getModalHoc } from '../../../node_modules/spark-design';
import './pagemainscene.less';
import ruleModal from '../../components/comrulep/comrulep.jsx';
import rankModal from '../../components/comrankp/comrankp.jsx';
import rankPrizeModal from '../../components/comawardp/comawardp.jsx';
import exchangeModal from '../../components/comexp/comexp.jsx';
import inviteRcordModal from '../../components/cominvitep/cominvitep.jsx';
import exchangeEnergySuccess from '../../components/comsuccessp/comsuccessp.jsx';
import { getPxToken } from '../../libs/spark_gettoken';
import { MODAL_MAP, PRIZE_PANEL } from '../../constant';
import { loadSvga, SvgaStage, MovieClip } from "@mrkwon/svga-player"
const RuleModal = getModalHoc(ruleModal);
const RankModal = getModalHoc(rankModal);
const RankPrizeModal = getModalHoc(rankPrizeModal);
const ExchangeModal = getModalHoc(exchangeModal);
const InviteRcordModal = getModalHoc(inviteRcordModal);
const ExchangeEnergySuccess = getModalHoc(exchangeEnergySuccess);
class Pagemainscene extends Component {
  dataStore = {};
  inviteNum = 0;
  inviteshownum = 0;
  inviteshowlength = 0;
  noinviteList = []
  constructor(props) {
    super(props);
    // this.state = this.state || { resList: resList };
    this.state = {
      resList: resList,
      nickname: "",
      avatar: "",
      energy: 0,
      yesterdayStepCount: 0,
      submit:false,
      yescount:0,
      myscore: 0,
      myindex: "1000+",
      modalState: 0,
      activityRule: "",
      taskList: [{
        "taskName": "",
        "taskId": 1,
        "taskTotalCount": 0,
        "taskFinishCount": 0,
        "taskBonus": 0,
        "icon": "",
        "url": "",
        "finish": false
      },
      {
        "taskName": "",
        "taskId": 1,
        "taskTotalCount": 0,
        "taskFinishCount": 0,
        "taskBonus": 0,
        "icon": "",
        "url": "",
        "finish": false
      }, {
        "taskName": "",
        "taskId": 1,
        "taskTotalCount": 0,
        "taskFinishCount": 0,
        "taskBonus": 0,
        "icon": "",
        "url": "",
        "finish": false
      }],
      rankList: [],//排行榜信息
      inviteList: [],
      goodlist: [],
      shareMask: false,
      rankPrizeInfo: {},
      inviteRecordList: [],//邀请记录
      exchangeGoodsList: [],//兑换商品列表
      chooseGoodsInfo: {},
      peolab: "",//气泡文案
      submitEnergy: 0,
    }
  }
  componentDidMount() {
    Loading.show();
    this.getIndexInfo()
    this.getMyrankInfo()
    // this.getInviteList()  //邀请好友的能量接口 
    this.getExchangeList()
    this.showRankPrizeModal();
    // this.getExchangeGoods();
    this.getPeoSvga();
    this.showpeoLab();
    this.acceptShare();
    this.getShareInfo();

    var o = document.getElementById("peopbg");
    // 动画重复运动时事件
    o.addEventListener("webkitAnimationIteration", ()=> {
        this.showpeoLab()
    })
  }

  async getIndexInfo() {
    let yesStep = this.getUrlparam('step');
    yesStep = decodeURIComponent(yesStep)
    console.log("ASD%3d%3d",yesStep)
    this.dataStore.indexinfo = await API.index({step:yesStep})
    Loading.hide()
    if (!this.dataStore.indexinfo.success) {
      // this.hideWaitting()
      Toast(this.dataStore.indexinfo.message)
      return
    }
    let { nickname, avatar, energy, yesterdayStepCount,activityRule, tasks, submit } = this.dataStore.indexinfo.data
    let yescount = 0;
    if (yesterdayStepCount > 30000) {
      yescount = 30000;
    } else {
      yescount = yesterdayStepCount;
    }
    this.setState({
      nickname: nickname,
      avatar: avatar,
      energy: energy,
      yesterdayStepCount: yesterdayStepCount,
      taskList: tasks,
      yescount: yescount,
      activityRule:activityRule,
      submit:submit
    })
    
    
  }
  async getMyrankInfo() {
    this.dataStore.myrank = await API.myrank({phaseType:0,nickname:1,avatar:1})
    if (!this.dataStore.myrank.success) {
      Toast(this.dataStore.myrank.message)
      return
    }
    let myrankscore ;
    let myrankindex ;
    if(this.dataStore.myrank.data){
      myrankscore = this.dataStore.myrank.data.score || 0;
      myrankindex = this.dataStore.myrank.data.index || "1000+"
    }else{
      myrankscore = 0;
      myrankindex = "1000+"
      this.dataStore.myrank.data = {score:0,index:"1000+"}
    }
    
    this.setState({
      myscore: myrankscore,
      myindex: myrankindex
    })

  }
  
  goFinishTask(index, taskId) {
    Loading.show()
    let taskList = this.dataStore.indexinfo.data.tasks
    if (taskList[index].url) {
      setTimeout(()=>{
        // Loading.hide();
        window.location.href = taskList[index].url
        
      },500)
    }
    if(!taskList[index].finish){
      // if(taskId == 1){
        this.finishTask(index,taskId)
      // }else{
      //   setTimeout(()=>{
      //     this.finishTask(index,taskId)
      //   },5000)
      // }
    }else{
      Loading.hide();
    }
    
    

  }
  finishTask(index, taskId){
    getPxToken(async token => {
      const res = await API.completeTask({ token: token, taskId: taskId });
      Loading.hide()
      if (res.success) {
        //刷新首页
        this.getIndexInfo();
      } else {
        
        Toast(res.message)
        return;
      }
    })
  }

  hrefTaskUrl(index){
    let taskList = this.dataStore.indexinfo.data.tasks
    if (taskList[index].url) {
      window.location.href = taskList[index].url
    }
  }
  //获取邀请列表
  async getInviteList() {
    this.dataStore.inviteList = await API.inviteList();
    if (!this.dataStore.inviteList.success) { 
      Toast(this.dataStore.inviteList.message);
      return
    }
    let { data } = this.dataStore.inviteList
    this.inviteNum = data.length;
    if (this.inviteNum < 10) {
      for (let i = this.inviteNum; i < 10; i++) {
        this.noinviteList.push(i);
      }
      console.info(this.noinviteList)
    }
    if (this.inviteNum <= 4) {
      this.inviteshownum = 0
      this.inviteshowlength = 0
    } else if (this.inviteNum >= 10) {
      this.inviteshownum = 10
      this.inviteshowlength = 390
    } else {
      this.inviteshownum = this.inviteNum
      if (this.inviteNum == 5) {
        this.inviteshowlength = 185;
      } else {
        this.inviteshowlength = 235 + 107 / 6 * (this.inviteNum - 4)
      }
    }
    this.setState({
      inviteList: data
    })

  }
  async getEnergy() {
    // event.stopPropagation();
    Loading.show();
    if(!this.dataStore.indexinfo.data.submit){
      getPxToken(async token => {
        this.dataStore.submit = await API.submit({ token: token, score: 0 ,startId:this.dataStore.indexinfo.data.startId});
        Loading.hide();
        if (!this.dataStore.submit.success) {
          Toast(this.dataStore.submit.message);
          return;
        }
        console.info('this.dataStore.submit', this.dataStore.submit, '===', MODAL_MAP['energySuccess']);
        this.modalControl('energySuccess');
        this.setState({
          submitEnergy: this.dataStore.submit.data
        })
        this.getIndexInfo()
      })
    }else{
      Loading.hide();
      Toast("昨日能量已兑换")
    }
    

  }

  inviteShare() {
    //调用分享方法 出分享蒙层。。。//分享方法没写
    
    console.info("调用分享")
    this.setState({
      shareMask: true
    })
    let {success,message,data} = API.buriedPoint({pageBizId:505})
  }
  closeShare() {
    //调用分享方法 关闭分享蒙层。。。
    console.info("关闭蒙层")
    this.setState({
      shareMask: false
    })
  }
  //获取邀请码
  async getShareInfo(){
    this.dataStore.shareCode = await API.genInvite()
    if(!this.dataStore.shareCode.success){
      Toast(this.dataStore.shareCode.message)
      return
    }
    let shareInfo = {
      ...window.projectData.wxMiniShareConfig,
      url:CFG.shareUrlHead+encodeURIComponent(CFG.shareUrl+"&avatar="+encodeURIComponent(this.state.avatar)+"&nickname="+encodeURIComponent(this.state.nickname)+"&shareCode="+this.dataStore.shareCode.data)
    }
    console.info("本人邀请码",this.dataStore.shareCode.data,shareInfo)
    window['postMsgToMini'](shareInfo);
  }
  //是否接受邀请
  //???
  async acceptShare(){
    console.info("当前链接：",window.location.href);
    console.info("shareCode：",this.getUrlparam("shareCode"));
    
    
    if(this.getUrlparam("shareCode")){
      console.info("getToken!!!!!!!!!!")
      getPxToken(async token => {
        console.info("getToke25646!!",token)
        const res = await API.accept({token:token,inviteCode:this.getUrlparam("shareCode")})
        if(!res.success){
          if(res.code == 100014){
            Toast("不能给自己助力哦~")
          }else{
            Toast(res.message)
          }
          
          return
        }

      })
    }
  }
  //获取连接上参数
  getUrlparam(name)
  {
    const search = window.location.search;
    const matched = search
    .slice(1)
    .match(new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i'));
    return search.length ? matched && matched[2] : null;
               
  }


  //获取兑换列表
  async getExchangeList() {
    this.dataStore.exchangeList = await API.exchangeList();
    if (!this.dataStore.exchangeList.success) {
      Toast(this.dataStore.exchangeList.message);
      return;
    }
    this.setState({
      goodlist: this.dataStore.exchangeList.data
    })
    console.info(this.dataStore.exchangeList.data)
    console.info(this.state.goodlist)
  }

  //导入小人svga svga引入
  getPeoSvga() {
    var svgaStage = new SvgaStage(document.getElementById('walkpeo'))
    console.info("123456")
    loadSvga("//yun.duiba.com.cn/spark/assets/a296f2ee5ce2b0be644c4fc42d8625cb14ccdfdb.svga", (v) => {
      var mv = new MovieClip(v);
      document.getElementById('walkpeo').width = mv.videoWidth;
      document.getElementById('walkpeo').height = mv.videoHeight
      // console.info(mv.videoWidth,mv.videoHieght)
      //添加进动画容器
      mv.lockStep = true;
      svgaStage.addChild(mv)
      this.moveStage = svgaStage;
      // this.halfHoney()
      this.isLoadsvga = true
    }, (err) => { console.info(err) })
    //循环起来
    loop()
    function loop() {
      svgaStage.flush()
      requestAnimationFrame(loop)
    }
  }
  showpeoLab() {

    // document.getElementById('peopbg').style.animationPlayState = "paused";
    // document.getElementById('peoplab').style.animationPlayState = "paused";
    let labnum = Math.random() * 3;
    let lab = ""
    if (Math.floor(labnum) == 0) {
      lab = "Hi，今天你签到了吗～";
    } else if (Math.floor(labnum) == 1) {
      lab = "微众优保提醒您：要天天锻炼哦～～" //"坚持运动是一个了不起的习惯哦～";
    } else {
      lab = "做任务可以领取更多福利哦～";
    }
    this.setState({
      peolab: lab
    })
    // document.getElementById('peopbg').style.animationPlayState = "running";
    // document.getElementById('peoplab').style.animationPlayState = "running";
    // document.getElementById('peopbg').addEventListener("webkitAnimationEnd",()=>{
    //   // setTimeout(() => {
    //     console.info("shijian wanjie")
    //     // this.showpeoLab()
    //   // },8000)
    // })
    
  }
  /**
   * LS20201030
   * 控制弹窗
   * @param {*} type 
   */
  modalControl(type) {
    this.setState({
      modalState: MODAL_MAP[type]
    })
  }
  /**
   * LS20201030
   * 获取规则信息
   */
  async showRule() {
    this.modalControl('rule');
    // let { data } = await API.getRule();
    // console.info('data===', data);
    // this.setState({
    //   activityRule: '7888888'
    // })
    // console.info('+++++++', this.state.modalState);
  }
  /**
   * LS20201030
   * 获取排行榜信息
    myrank//我的排行榜名次
    rankList,//排行榜列表 
    avatar: ""
    index: 10
    nickname: "ullamco"
    score: 12112
    userId: "121211111"
   */
  async showRank() {
    this.modalControl("rankInfo------");
    //所有排行榜用户信息
    let { data, success, message } = await API.rankList({phaseType:0,topN:50,nickname:1});
    //我的排行榜信息
    let myRankData = this.dataStore.myrank;
    console.info('data=------=', data);
    console.info('myRankData=', myRankData);
    if (success) {
      console.info('给排行榜信息赋值');
      this.setState({
        rankList: data,
        modalState: MODAL_MAP['rankInfo']
      })
    } else {
      return Toast('获取排行榜信息出错');
    }
  }
  /**
   * 展示排行榜奖品弹窗
   */
  async showRankPrizeModal() {
    let { data, success, message } = await API.rankPop();
    console.info('rankprize====', success, data);
    if (success) {
      if(data.show){
        this.setState({
          rankPrizeInfo: data,
          modalState: MODAL_MAP.rankPrize
        })
      }
    } else {
      return Toast(message);
    }
  }
  /**
   * 获取邀请记录弹窗
    userName	string	
    userId	number	
    avatar	string	
    bonus	number	
    inviteTime
   */
  async onShowInviteRecord() {
    let { success, data } = await API.inviteList();
    console.info('data==', data);
    this.modalControl('inviteRecord');
    if (!success) {
      return Toast(message);
    } else {
      this.setState({
        inviteRecordList: data
      })
    }

  }

  async getExchangeGoods() {
    let { success, data, message } = await API.exchangeList();
    console.info('exchangelis-----===', data);
    if (success) {
      this.setState({
        exchangeGoodsList: data
      })
    } else {
      Toast(message || '获取兑换商品信息出错');
    }
  }
  /**
   * 选择兑换商品
   * @param {*} goodsInfo 
   */
  showExchangeGoodsModal(goodsInfo) {
    let { chooseGoodsInfo } = this.state;
    this.setState({
      chooseGoodsInfo: goodsInfo,
      modalState: MODAL_MAP['exchangeGoods']
    })
  }


  render() {
    let { nickname, avatar, energy, yesterdayStepCount, submit, yescount, myscore, myindex, taskList, activityRule, modalState,
      rankList, inviteList, rankPrizeInfo, inviteRecordList, chooseGoodsInfo, goodlist, shareMask, peolab ,submitEnergy} = this.state
    return (
      <div className="mainscene">
        <img className="mainbg" src={this.state.resList['239f9738-1a44-4fed-93e2-cbb52b2c07dd'].url} />
        <img className="ruihualoga" src={this.state.resList['65ee7c59-6476-4a47-9c36-cc7b6954b9ec'].url}/>
        <img className="rulebtn" onClick={() => { this.showRule() }} src={this.state.resList['bb5d7e1f-026c-460d-a7a7-99bb089fc022'].url} />
        <img className="recordbtn" onClick={() => { window.location.href = PRIZE_PANEL }} src={this.state.resList['bd96b86c-782c-4375-b899-5b2d421ddd06'].url} />
        <div className="usermes">
          <img className="usermesbg" src={this.state.resList['9ce50cdd-59ed-4d60-a7b5-4509e2dd030f'].url} />
          <img className="usermesiconbg" src={this.state.resList['c56a8a4b-a0ce-48ff-acc2-e4b3f98d86fc'].url} />
          <img className="usermesicon" src={avatar} />
          <label className="usermesname">{nickname}</label>
          <label className="usermesenerge">我的能量:{energy}</label>
        </div>
        <div className="poptask">
          <img className="poptaskimg3" src={this.state.resList['fce08be8-3834-4bc6-bce1-2580e82feb55'].url} onClick={this.goFinishTask.bind(this, 0, taskList[0].taskId)}/>
          <label className="poptasklab3" onClick={this.goFinishTask.bind(this, 0, taskList[0].taskId)}>{taskList[0].taskBonus}</label>
          <img className="poptaskimg5" src={this.state.resList['911b338d-5edc-4330-b023-3c5d06ed6297'].url} onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)}/>
          <label className="poptasklab5" onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)}>{taskList[1].taskBonus}</label>
          <img className="poptaskimg4" src={this.state.resList['57c4d641-4b51-4d55-94fe-21f3c1c1e478'].url} onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)}/>
          <label className="poptasklab4" onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)}>{taskList[2].taskBonus}</label>
          <img className="poptaskimg2" src={this.state.resList['4381d12a-1a9e-4e49-84e4-8d6cf9134f5b'].url} onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)}/>
          <label className="poptasklab2" onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)}>{taskList[1].taskBonus}</label>
          <img className="poptaskimg1" src={this.state.resList['33aadbe5-7e84-4c40-9e0e-6a8ac7c340bf'].url} onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)}/>
          <label className="poptasklab1" onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)}>{taskList[2].taskBonus} </label>
        </div>
        
        <div className="laststep">
          <label className="laststepnum">{yesterdayStepCount}</label>
          <img className="laststepbar" src={this.state.resList['2f57b289-a595-45d0-95f6-1ca310c0b845'].url} />
          <div className="mask-box">
            <div className="mask-box-wrap" style={{ transform: `rotate(${yescount / 30000 * 180 - 180}deg)` }}>
              <img className="laststepbar" src={this.state.resList['51f43650-9c33-4746-bf74-5dc911a76833'].url} />
            </div>
          </div>
          <img className="laststeplab" src={this.state.resList['2a115def-3711-469b-b785-d61a03034a28'].url} />
          {
            submit?<img className="laststepbtnGray" src={this.state.resList['3ea2a888-7ed4-4655-97cb-b9011afc84b5'].url} />
            :<img className="laststepbtn point1" src={this.state.resList['0f7e7944-459d-45c6-84c5-a4ffe94be265'].url} onClick={this.getEnergy.bind(this)} />
          }
          
          <img className="laststeptip" src={this.state.resList['f8645202-7257-4878-9cdf-ffd1fb675555'].url}/>
        </div>
        
        <div className="step">
          <img className="stepbg" src={this.state.resList['015e1dc4-b72e-42a7-991c-44ea23a973ad'].url} />
          <img className="steplibg" src={this.state.resList['bd563f58-8246-4ff5-a80c-a2d3f7a38caf'].url} />
          <img className="stepnum" src={this.state.resList['60f68768-5464-4a8f-a8bc-766b93e36dbf'].url} />
          <label className="stepnumlab">{myscore}</label>
          <img className="steprank" src={this.state.resList['e2a5dcd1-5b3b-468c-94f5-98d1ad511463'].url} />
          {/* 调用接口获取排行榜信息 */}
          <label className="stepranknum" onClick={() => { console.info('点击获取排行榜信息'); this.showRank() }}>{`${myindex}  >`}</label>
        </div>
        <div className="people">
          <img className="peoplebg" id="peopbg" src={this.state.resList['f28dfeb9-cc40-4410-af01-63686d775867'].url} />
          <label className="peoplelab" id="peoplab">{peolab}</label>
          {/* <img className="peopleimg" src={this.state.resList['6d181837-2468-4ecd-a496-afddc37408a3'].url} /> */}
          <canvas className="canvas" id="walkpeo" ></canvas>
        </div>
        
        <div className="task">
          <img className="taskbg" src={this.state.resList['5ab12e23-4d42-4e01-bdea-27c15ff7bc47'].url} />
          <div className="tasks">
            <div className="task3">
              <img className="task3icon float" src={taskList[0].icon} />
              {/* <div className="task3icon float"></div> */}
              <label className="task3lab float">{taskList[0].taskTotalCount > 1 ? `${taskList[0].taskName}(${taskList[0].taskFinishCount}/${taskList[0].taskTotalCount})` : taskList[0].taskName}</label>
              <img className="taskprize3img float" src={this.state.resList['bff0ebf6-92f0-4331-be4e-be162d2f7da6'].url} />
              <label className="taskprize3num float">+{taskList[0].taskBonus}</label>
              {!taskList[0].finish ?
                <div>
                  {taskList[0].url ? <img className="task3gobtn point2" src={this.state.resList['66341566-3f57-487b-ba38-6bacea0efad9'].url} onClick={this.goFinishTask.bind(this, 0, taskList[0].taskId)} />
                    : <img className="task3gobtn point2" src={this.state.resList['89ae47c5-e6b9-44d6-8be5-fd425c33b569'].url} onClick={this.goFinishTask.bind(this, 0, taskList[0].taskId)} />}
                </div>
                :<div>
                  {taskList[0].url ?
                  <img className="task3finbtn " src={this.state.resList['04f08f5c-f8e7-4b19-9b3f-7adafcd72010'].url} onClick={this.hrefTaskUrl.bind(this,0)}/>
                  :<img className="task3finbtn " src={this.state.resList['5eb5dbe3-3ad7-4f0c-91b2-ba790167c98b'].url} onClick={this.hrefTaskUrl.bind(this,0)}/>}
                </div>
                 
              }
            </div>
            <div className="task3">
              <img className="task3icon float" src={taskList[1].icon} />
              {/* <div className="task3icon float"></div> */}
              <label className="task3lab float">{taskList[1].taskTotalCount > 1 ? `${taskList[1].taskName}(${taskList[1].taskFinishCount}/${taskList[1].taskTotalCount})` : taskList[1].taskName}</label>
              <img className="taskprize3img float" src={this.state.resList['bff0ebf6-92f0-4331-be4e-be162d2f7da6'].url} />
              <label className="taskprize3num float">+{taskList[1].taskBonus}</label>
              {!taskList[1].finish ?
                <div>
                  {taskList[1].url ? <img className="task3gobtn point3" src={this.state.resList['66341566-3f57-487b-ba38-6bacea0efad9'].url} onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)} />
                    : <img className="task3gobtn point3" src={this.state.resList['89ae47c5-e6b9-44d6-8be5-fd425c33b569'].url} onClick={this.goFinishTask.bind(this, 1, taskList[1].taskId)} />}
                </div>
                : <div>
                  {taskList[1].url ?
                  <img className="task3finbtn " src={this.state.resList['04f08f5c-f8e7-4b19-9b3f-7adafcd72010'].url} onClick={this.hrefTaskUrl.bind(this,1)}/>
                  :<img className="task3finbtn " src={this.state.resList['5eb5dbe3-3ad7-4f0c-91b2-ba790167c98b'].url} onClick={this.hrefTaskUrl.bind(this,1)}/>}
                </div>
              }
            </div>
            <div className="task3">
              <img className="task3icon float" src={taskList[2].icon} />
              {/* <div className="task3icon float"></div> */}
              <label className="task3lab float">{taskList[2].taskTotalCount > 1 ? `${taskList[2].taskName}(${taskList[2].taskFinishCount}/${taskList[2].taskTotalCount})` : taskList[2].taskName}</label>
              <img className="taskprize3img float" src={this.state.resList['bff0ebf6-92f0-4331-be4e-be162d2f7da6'].url} />
              <label className="taskprize3num float">+{taskList[2].taskBonus}</label>
              {!taskList[2].finish ?
                <div>
                  {taskList[2].url ? <img className="task3gobtn point4" src={this.state.resList['66341566-3f57-487b-ba38-6bacea0efad9'].url} onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)} />
                    : <img className="task3gobtn point4" src={this.state.resList['89ae47c5-e6b9-44d6-8be5-fd425c33b569'].url} onClick={this.goFinishTask.bind(this, 2, taskList[2].taskId)} />}
                </div>
                : <div>
                    {taskList[2].url ?
                    <img className="task3finbtn " src={this.state.resList['04f08f5c-f8e7-4b19-9b3f-7adafcd72010'].url} onClick={this.hrefTaskUrl.bind(this,2)}/>
                    :<img className="task3finbtn " src={this.state.resList['5eb5dbe3-3ad7-4f0c-91b2-ba790167c98b'].url} onClick={this.hrefTaskUrl.bind(this,2)}/>}
                  </div>
              }
            </div>
          </div>
          <img className="tasktitle" src={this.state.resList['aca71fa0-8903-4e2e-8dec-d09c01474301'].url} />
        </div>

        {/* 邀请好友得能量,释放注释，调整奖品列表位置，即可开放此功能 */}

        {/* <div className="invite">
          <img className="invitebg" src={this.state.resList['c8f3c748-5f59-4149-ba87-92476a69d06c'].url} />
          <div className="invitepeo">
            {
              inviteList && inviteList.map((item, index) => {
                return (
                  <div key={index}>
                    {index < 10 ?
                      <div className="invitepeoitem">
                        <img className="invitepeoitembg" src={this.state.resList['5df866e6-9da7-4602-a40c-f741185befd7'].url} />
                        <img className="invitepeoitemicon" src={item.avatar} />
                      </div> : null
                    }
                  </div>
                )
              })
            }
            {
              this.noinviteList && this.noinviteList.map((item, index) => {
                return (
                  <div className="invitepeoitem" key={index}>
                    <img className="invitepeoitembg" src={this.state.resList['5df866e6-9da7-4602-a40c-f741185befd7'].url} />
                    <img className="invitepeoitemicon" onClick={this.inviteShare.bind(this)} />
                    <img className="invitepeoitemadd" src={this.state.resList['8ab64c8d-d154-4e50-ac3f-6b5eacbbfc3d'].url} onClick={this.inviteShare.bind(this)} />
                  </div>
                )
              })
            }

          </div>
          <img className="invitebtn point5" src={this.state.resList['987a106c-113c-4bb5-ab98-b903fbc3064f'].url} onClick={this.inviteShare.bind(this)} />
          <img className="invitelab" src={this.state.resList['507f09ac-cfef-4c08-b371-12b95a9cbbd4'].url} />
          <img className="inviterecord" onClick={() => { this.onShowInviteRecord() }} src={this.state.resList['4d39de00-ebcc-4d85-826f-a4600c3de49b'].url} />
          <img className="invitetitle" src={this.state.resList['ef0eec26-ee89-413e-8d6d-dd1a9c995397'].url} />
          <div className="inviteimg">
            <img className="inviteimgbar" src={this.state.resList['aa11361b-d5d9-4890-a635-e33228a2f868'].url} />
            <div className="inviteimgbar_top" style={{ width: `${(this.inviteshowlength / 390) * 100}%` }} />
            <img className="inviteimg1" src={this.state.resList['2c9b86cf-4533-4a1a-8a4d-1bf643bb88eb'].url} />
          </div>
        </div> */}

        <div className="exchange">
          <img className="exchangebg" src={this.state.resList['c862929e-ba89-4078-b98a-331322f8ee3e'].url} />
          <div className="exchangelist">
            {
              goodlist && goodlist.map((item, index) => {
                return (
                  <div className="exchangelistitem" key={index}>
                    <img
                      className="exchangelistitemimg"
                      src={item.prizePic}
                    />
                    <img
                      className="exchangelistitembtn"
                      src={resList['e2decafd-8da8-422d-afab-37410d3749e0'].url}
                      onClick={() => { this.showExchangeGoodsModal(item); }}
                    />
                    <label className="exchangelistitemname">{item.prizeName}</label>
                    <div className="prizeBar">
                      <label className="exchangelistitemprize">{item.needCount}能量</label>
                      <label className="exchangelistitemold">原价:{item.prizePrice}元</label>
                    </div>
                  </div>
                )

              })
            }

          </div>
        </div>
        {
          shareMask ?
            <div className="shareMask" onClick={this.closeShare.bind(this)}>
              <div className="shareImg">
              </div>
            </div> : null
        }
        {/* <div className="shareMask" onClick={this.closeShare.bind(this)}>
            <div className="shareImg">
            </div>
        </div> */}
        {/* 规则弹窗 */}
        { MODAL_MAP["rule"] === modalState && <RuleModal rule={activityRule} onClose={() => { this.modalControl() }}></RuleModal>}
        { MODAL_MAP["rankInfo"] === modalState && <RankModal myRankData={this.dataStore.myrank} rankList={rankList} onClose={() => { this.modalControl() }}></RankModal>}
        {/* RankPrizeModal ExchangeModal InviteRcordModal  */}
        { MODAL_MAP["rankPrize"] === modalState && <RankPrizeModal rankPrizeInfo={rankPrizeInfo} onClose={() => { this.modalControl() }} />}
        { MODAL_MAP["exchangeGoods"] === modalState && <ExchangeModal myEnergy={energy} goodsInfo={chooseGoodsInfo} onClose={() => { this.modalControl()}} getIndexInfo={()=>{this.getIndexInfo()}} />}
        { MODAL_MAP["inviteRecord"] === modalState && <InviteRcordModal inviteRecordList={inviteRecordList} onClose={() => { this.modalControl() }} />}
        { MODAL_MAP["energySuccess"] === modalState && <ExchangeEnergySuccess submitEnergy={submitEnergy} onClose={() => { this.modalControl();this.getMyrankInfo(); }} />}

      </div>
    );
  }
}
export default Pagemainscene;
