'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api/index.js';
import './comexp.less';
import { Toast } from 'spark-design';
import { getPxToken } from '../../libs/spark_gettoken';
import { PRIZE_PANEL } from '../../constant'
class Comexp extends Component {
  isExchange = true
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      // isExchange: true
    };
  }
  /**
   * 兑换商品
   */
  exchangeGoodsInfo(ruleId) {
    let { onClose, myEnergy, goodsInfo, getIndexInfo } = this.props;
    setTimeout(() => {
      this.isExchange = true;
    }, 2000);
    if (this.isExchange) {
      this.isExchange = false;
      if (myEnergy < goodsInfo.needCount) {
        return Toast('兑换能量不足~', 1000);
      } else {
        getPxToken(async token => {
          let { message, success, data } = await API.exchange({ ruleId: ruleId, token: token });
          if (success) {
            Toast('兑换成功', 1000);
            window.location.href = CFG.recordUrl
            setTimeout(() => { onClose();getIndexInfo() }, 1000);
          } else {
            return Toast(message);
          }
        });
      }
    }
  }
  render() {
    let { goodsInfo, onClose, getIndexInfo } = this.props;
    return (
      <div className="exp">
        <img className="exchangeBg" />
        <img className="exbg" src={this.state.resList['b9fa76f3-55ea-4bb8-bfbb-ff5900b7c7f2'].url} />
        <label className="energyn">{goodsInfo.needCount}能量</label>
        <label className="goodsna">{goodsInfo.prizeName}</label>
        <img className="rewardi" src={goodsInfo.prizePic} />
        <img className="exclose" onClick={onClose} src={this.state.resList['665b8867-e35c-485e-a01c-6a2d94023436'].url} />
        <img className="exbtn" onClick={this.exchangeGoodsInfo.bind(this, goodsInfo.ruleId)} src={this.state.resList['a2fa486a-50ab-444d-9acd-3e15dbbe9d7c'].url} />
      </div>
    );
  }
}
export default Comexp;
